 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                                 N   N  TTTTT                                % O %                                 NN  N    T                                  % O %                                 N N N    T                                  % O %                                 N  NN    T                                  % O %                                 N   N    T                                  % O %                                                                             % O %                                                                             % O %                  Windows NT Utility Methods for ImageMagick                 % O %                                                                             % O %                                                                             % O %                               Software Design                               % O %                                 John Cristy                                 % O %                                December 1996                                % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   #if defined(WIN32) /*   Include declarations.  */ #include "magick.h"  #include "defines.h" #include "nt.h"    /*   External declarations. */ #if !defined(_VISUALC_)  extern "C" BOOL WINAPIA   DllMain(HINSTANCE instance,DWORD data_segment,LPVOID reserved);  #endif   extern char    *SetClientName(const char *);    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   c l o s e d i r                                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method closedir closes the named directory stream and frees the DIR
 %  structure.  % ( %  The format of the closedir method is: %   %      void closedir(DIR *entry) % + %  A description of each parameter follows:  % 5 %    o entry: Specifies a pointer to a DIR structure.  %  %  */  Export void closedir(DIR *entry) {     assert(entry != (DIR *) NULL);   FindClose(entry->hSearch);   FreeMemory(entry); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   E x i t                                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 0 %  Method Exit calls TerminateProcess for Win95. % $ %  The format of the Exit method is: %  %      int Exit(int status)  % + %  A description of each parameter follows:  % J %    o status: an integer value representing the status of the terminating %      process.  %  %  */ Export int Exit(int status)  {    if (IsWindows95())@     TerminateProcess(GetCurrentProcess(),(unsigned int) status);   exit(status);    return(0); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I m a g e F o r m a t C o n f l i c t                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method ImageFormatConflict returns true if the image format conflicts with  %  a logical drive (.e.g. X:). % 3 %  The format of the ImageFormatConflict method is:  % 2 %      int ImageFormatConflict(const char *magick) % + %  A description of each parameter follows:  % J %    o status: Method ImageFormatConflict returns true if the image format& %      conflicts with a logical drive. % * %    o magick: Specifies the image format. %  %  */2 Export int ImageFormatConflict(const char *magick) { "   assert(magick != (char *) NULL);   if (strlen(magick) > 1)      return(False);I   return((GetLogicalDrives()) & (1 << ((toupper((int) (*magick)))-'A')));  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s W i n d o w s 9 5                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ? %  Method IsWindows95 returns true if the system is Windows 95.  % + %  The format of the IsWindows95 method is:  %  %      int IsWindows95() % + %  A description of each parameter follows:  % J %    o status: an integer value representing the status of the terminating %      process.  %  %  */ Export int IsWindows95() {    OSVERSIONINFO      version_info;   8   version_info.dwOSVersionInfoSize=sizeof(version_info);$   if (GetVersionEx(&version_info) &&@       (version_info.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS))     return(1);   return(0); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  m m a p                                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 9 %  Method mmap emulates the Unix method of the same name.  % $ %  The format of the mmap method is: % M %    Export void *mmap(char *address,size_t length,int protection,int access, # %      int descriptor,off_t offset)  %  %  */H Export void *mmap(char *address,size_t length,int protection,int access,   int descriptor,off_t offset) {    void	     *map;      HANDLE     handle;      map=(void *) NULL;   handle=INVALID_HANDLE_VALUE;   switch (protection)    {      case PROT_READ:      default:     { E       handle=CreateFileMapping((HANDLE) _get_osfhandle(descriptor),0, "         PAGE_READONLY,0,length,0);       if (!handle)         break;B       map=(void *) MapViewOfFile(handle,FILE_MAP_READ,0,0,length);       CloseHandle(handle);       break;     }      case PROT_WRITE:     { E       handle=CreateFileMapping((HANDLE) _get_osfhandle(descriptor),0, #         PAGE_READWRITE,0,length,0);        if (!handle)         break;C       map=(void *) MapViewOfFile(handle,FILE_MAP_WRITE,0,0,length);        CloseHandle(handle);       break;     }      case PROT_READWRITE:     { E       handle=CreateFileMapping((HANDLE) _get_osfhandle(descriptor),0, #         PAGE_READWRITE,0,length,0);        if (!handle)         break;H       map=(void *) MapViewOfFile(handle,FILE_MAP_ALL_ACCESS,0,0,length);       CloseHandle(handle);       break;     }    }    if (map == (void *) NULL)       return((void *) MAP_FAILED);)   return((void *) ((char *) map+offset));  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   N T E r r o r H a n d l e r                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method NTErrorHandler displays an error message and then terminates %  the program.  % . %  The format of the NTErrorHandler method is: % H %      void NTErrorHandler(const unsigned int error,const char *message, %        const char *qualifier)  % + %  A description of each parameter follows:  % 3 %    o error: Specifies the numeric error category.  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */H Export void NTErrorHandler(const unsigned int error,const char *message,   const char *qualifier) {    char     buffer[3*MaxTextExtent];     if (message == (char *) NULL)      Exit(0);,   if ((qualifier != (char *) NULL) && errno)B     FormatString(buffer,"%.1024s: %.1024s (%.1024s) [%.1024s].\n",F       SetClientName((char *) NULL),message,qualifier,strerror(errno));   else#     if (qualifier != (char *) NULL) :       FormatString(buffer,"%.1024s: %.1024s (%.1024s).\n",8         SetClientName((char *) NULL),message,qualifier);     else       if (errno)<         FormatString(buffer,"%.1024s: %.1024s [%.1024s].\n",@           SetClientName((char *) NULL),message,strerror(errno));
       elseO         FormatString(buffer,"%.1024s: %.1024s.\n",SetClientName((char *) NULL),            message); J   (void) MessageBox(NULL,buffer,"ImageMagick Error",MB_OK | MB_TASKMODAL |+     MB_SETFOREGROUND | MB_ICONEXCLAMATION); 
   Exit(0); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   N T S y s t e m C o m m a n d                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %   Method NTSystemCommand executes the specified command and waits until itF %   terminates.  The returned value is the exit status of the command. % / %  The format of the NTSystemCommand method is:  % / %      int NTSystemCommand(const char *command)  % + %  A description of each parameter follows:  % 6 %    o command: This string is the command to execute. %  %  *// Export int NTSystemCommand(const char *command)  {    char     local_command[2048];     DWORD      child_status;      int      status;      PROCESS_INFORMATION      process_info;   
   STARTUPINFO      startup_info;      unsigned int     background_process;      if (command == (char *) NULL)      return(-1);     GetStartupInfo(&startup_info);,   startup_info.dwFlags=STARTF_USESHOWWINDOW;.   startup_info.wShowWindow=SW_SHOWMINNOACTIVE;'   (void) strcpy(local_command,command); 7   background_process=command[strlen(command)-1] == '&';    if (background_process) *     local_command[strlen(command)-1]='\0';(   if (command[strlen(command)-1] == '|')+      local_command[strlen(command)-1]='\0';     else -      startup_info.wShowWindow=SW_SHOWDEFAULT; 4   status=CreateProcess((LPCTSTR) NULL,local_command,K     (LPSECURITY_ATTRIBUTES) NULL,(LPSECURITY_ATTRIBUTES) NULL,(BOOL) FALSE, L     (DWORD) NORMAL_PRIORITY_CLASS,(LPVOID) NULL,(LPCSTR) NULL,&startup_info,     &process_info);    if (status == 0)     return(-1);    if (background_process)      return(status == 0);=   status=WaitForSingleObject(process_info.hProcess,INFINITE);    if (status != WAIT_OBJECT_0)     return(status); A   status=GetExitCodeProcess(process_info.hProcess,&child_status);    if (status == 0)     return(-1); %   CloseHandle(process_info.hProcess); $   CloseHandle(process_info.hThread);   return((int) child_status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   N T T e m p o r a r y F i l e n a m e                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %   Method NTTemporaryFilename creates a name for a temporary file.  It $ %   returns zero if an error occurs. % 1 %  The format of the TemporaryFilename method is:  % . %      int NTTemporaryFilename(char *filename) % + %  A description of each parameter follows:  % G %    o filename: Specifies a pointer to a string to place the filename.  %  %  */. Export int NTTemporaryFilename(char *filename) {    char     path[1024];      int      status;   $   assert(filename != (char *) NULL);(   status=GetTempPath(sizeof(path),path);   if (status != 0)5     status=GetTempFileName(path,"magick",0,filename);    (void) remove(filename);   if (strlen(filename) > 4) 8     if (strcmp(filename+strlen(filename)-4,".tmp") == 0)(       filename[strlen(filename)-4]='\0';   return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +  m u n m a p                                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Method munmap emulates the Unix method with the same name.  % & %  The format of the munmap method is: % * %      int munmap(void *map,size_t length) % + %  A description of each parameter follows:  % A %    o status:  Method munmap returns 0 on success; otherwise, it 7 %      returns -1 and sets errno to indicate the error.  % 3 %    o map: The address of the binary large object.  % 5 %    o length: The length of the binary large object.  %  %  */* Export int munmap(void *map,size_t length) {    if (!UnmapViewOfFile(map))     return(-1);    return(0); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   N T W a r n i n g H a n d l e r                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 6 %  Method NTWarningHandler displays a warning message. % 0 %  The format of the NTWarningHandler method is: % L %      void NTWarningHandler(const unsigned int warning,const char *message, %        const char *qualifier)  % + %  A description of each parameter follows:  % 7 %    o warning: Specifies the numeric warning category.  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */L Export void NTWarningHandler(const unsigned int warning,const char *message,   const char *qualifier) {    char     buffer[2048];      if (message == (char *) NULL)      return; !   if (qualifier == (char *) NULL) .     FormatString(buffer,"%.1024s: %.1024s.\n",,       SetClientName((char *) NULL),message);   else8     FormatString(buffer,"%.1024s: %.1024s (%.1024s).\n",6       SetClientName((char *) NULL),message,qualifier);L   (void) MessageBox(NULL,buffer,"ImageMagick Warning",MB_OK | MB_TASKMODAL |+     MB_SETFOREGROUND | MB_ICONINFORMATION);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   o p e n d i r                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method opendir opens the directory named by filename and associates %  a directory stream with it. % ' %  The format of the opendir method is:  %  %      DIR *opendir(char *path)  % + %  A description of each parameter follows:  % 5 %    o entry: Specifies a pointer to a DIR structure.  %  %  */ Export DIR *opendir(char *path)  {    char     file_specification[2048];      DIR      *entry;       assert(path != (char *) NULL);)   (void) strcpy(file_specification,path); +   (void) strcat(file_specification,"/*.*"); ,   entry=(DIR *) AllocateMemory(sizeof(DIR));   if (entry != (DIR *) NULL)     entry->hSearch= >       FindFirstFile(file_specification,&entry->Win32FindData);   return(entry); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   r e a d d i r                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Method readdir returns a pointer to a structure representing the E %  directory entry at the current position in the directory stream to  %  which entry refers. %  %  The format of the readdir %  %      readdir(entry)  % + %  A description of each parameter follows:  % 5 %    o entry: Specifies a pointer to a DIR structure.  %  %  */) Export struct dirent *readdir(DIR *entry)  {    int      status;      static struct dirent     file_info;  <   status=FindNextFile(entry->hSearch,&entry->Win32FindData);   if (status == 0)#     return((struct dirent *) NULL); A   (void) strcpy(file_info.d_name,entry->Win32FindData.cFileName); .   file_info.d_namlen=strlen(file_info.d_name);   return(&file_info);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   s e e k d i r                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %   Method seekdir sets the position of the next readdir() operation %   on the directory stream. % ' %  The format of the seekdir method is:  % - %      void seekdir(DIR *entry,long position)  % + %  A description of each parameter follows:  % 5 %    o entry: Specifies a pointer to a DIR structure.  % E %    o position: specifies the position associated with the directory  %      stream. %  %  %  */- Export void seekdir(DIR *entry,long position)  {     assert(entry != (DIR *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   t e l l d i r                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %   Method telldir returns the current location associated  with  the  %   named directory stream.  % ' %  The format of the telldir method is:  %  %      long telldir(DIR *entry)  % + %  A description of each parameter follows:  % 5 %    o entry: Specifies a pointer to a DIR structure.  %  %  */ Export long telldir(DIR *entry)  {     assert(entry != (DIR *) NULL);   return(0); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D l l M a i n                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method Dllmain is the entry point for the ImageMagick DLL library.  %  %  */J BOOL WINAPI DllMain(HINSTANCE instance,DWORD data_segment,LPVOID reserved) {    switch(data_segment)   {      case DLL_PROCESS_ATTACH:     {        return(1);     }      case DLL_PROCESS_DETACH:     {        break;     }      default:     {        return(1);     }    }    return(0); }  #endif