 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            PPPP   DDDD   FFFFF                              % O %                            P   P  D   D  F                                  % O %                            PPPP   D   D  FFF                                % O %                            P      D   D  F                                  % O %                            P      DDDD   F                                  % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h" #if defined(HasTIFF) #define CCITTParam  "-1" #else  #define CCITTParam  "0"  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s P D F                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method IsPDF returns True if the image format type, identified by the %  magick string, is PDF.  % , %  The format of the ReadPDFImage method is: % 6 %      unsigned int IsPDF(const unsigned char *magick,# %        const unsigned int length)  % + %  A description of each parameter follows:  % J %    o status:  Method IsPDF returns True if the image format type is PDF. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */P Export unsigned int IsPDF(const unsigned char *magick,const unsigned int length) {    if (length < 5)      return(False);.   if (strncmp((char *) magick,"%PDF-",5) == 0)     return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d P D F I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method ReadPDFImage reads a Portable Document Format image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % , %  The format of the ReadPDFImage method is: % 7 %      Image *ReadPDFImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadPDFImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadPDFImage(const ImageInfo *image_info)  {  #define MediaBox  "/MediaBox ["      char     density[MaxTextExtent],      command[MaxTextExtent],      filename[MaxTextExtent],     geometry[MaxTextExtent],     options[MaxTextExtent], '     postscript_filename[MaxTextExtent];      DelegateInfo     delegate_info;     double     dx_resolution,     dy_resolution;     FILE
     *file;     Image      *image,      *next_image;     ImageInfo      *local_info;     int 
     count,     status;   
   long int
     filesize;      RectangleInfo      box,     page_info;     register char      *p;      register int     c;  
   SegmentInfo      bounding_box;      unsigned int     height, 
     portrait, 
     width;     if (image_info->monochrome)      { C       if (!GetDelegateInfo("gs-mono",(char *) NULL,&delegate_info))          return((Image *) NULL);      }    elseB     if (!GetDelegateInfo("gs-color",(char *) NULL,&delegate_info))       return((Image *) NULL);    /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*     Open temporary output file.    */)   TemporaryFilename(postscript_filename); 2   file=fopen(postscript_filename,WriteBinaryType);   if (file == (FILE *) NULL)=     ReaderExit(FileOpenWarning,"Unable to write file",image);    /*     Set the page geometry.   */   dx_resolution=72.0;    dy_resolution=72.0; C   if ((image->x_resolution == 0.0) || (image->y_resolution == 0.0))      { .      (void) strcpy(density,PSDensityGeometry);P       count=sscanf(density,"%lfx%lf",&image->x_resolution,&image->y_resolution);       if (count != 2) 0         image->y_resolution=image->x_resolution;     } H   FormatString(density,"%gx%g",image->x_resolution,image->y_resolution);   page_info.width=612;   page_info.height=792;    page_info.x=0;   page_info.y=0;E   (void) ParseImageGeometry(PSPageGeometry,&page_info.x,&page_info.y, (     &page_info.width,&page_info.height);   portrait=True;   /*3     Determine page geometry from the PDF media box.    */   box.width=0;   box.height=0;    for (p=command; ; )    {      c=ReadByte(image);     if (c == EOF)        break;     (void) fputc(c,file);      *p++=(char) c;H     if ((c != '\n') && (c != '\r') && ((p-command) < (MaxTextExtent-1)))       continue;      *p='\0';     p=command;     /*3       Continue unless this is a MediaBox statement.      */.     if (strncmp(command,"/Rotate 90",10) == 0)       portrait=False; 8     if (strncmp(MediaBox,command,Extent(MediaBox)) != 0)       continue; H     count=sscanf(command,"/MediaBox [ %lf %lf %lf %lf",&bounding_box.x1,:       &bounding_box.y1,&bounding_box.x2,&bounding_box.y2);     if (count != 4)        continue; .     if ((bounding_box.x1 > bounding_box.x2) ||,         (bounding_box.y1 > bounding_box.y2))       continue;      /*%       Set Postscript render geometry.      */;     width=(unsigned int) (bounding_box.x2-bounding_box.x1); ;     if ((float) ((int) bounding_box.x2) != bounding_box.x2)        width++;<     height=(unsigned int) (bounding_box.y2-bounding_box.y1);;     if ((float) ((int) bounding_box.y2) != bounding_box.y2)        height++; 7     if ((width <= box.width) && (height <= box.height))        continue;      page_info.width=width;     page_info.height=height;     box=page_info;   } (   if (image_info->page != (char *) NULL)I     (void) ParseImageGeometry(image_info->page,&page_info.x,&page_info.y, *       &page_info.width,&page_info.height);    FormatString(geometry,"%ux%u",M     (unsigned int) ((page_info.width*image->x_resolution+0.5)/dx_resolution), O     (unsigned int) ((page_info.height*image->y_resolution+0.5)/dy_resolution));    if (ferror(file))      { L       MagickWarning(FileOpenWarning,"An error has occurred writing to file",         postscript_filename);        (void) fclose(file);       return((Image *) NULL);      }    (void) fclose(file);   CloseBlob(image);    filesize=image->filesize;    DestroyImage(image);   /*0     Use Ghostscript to convert Postscript image.   */   *options='\0';    if (image_info->subrange != 0)8     FormatString(options,"-dFirstPage=%u -dLastPage=%u",H       image_info->subimage+1,image_info->subimage+image_info->subrange);/   (void) strcpy(filename,image_info->filename); 3   TemporaryFilename((char *) image_info->filename); L   FormatString(command,delegate_info.commands,image_info->antialias ? 4 : 1,P     image_info->antialias ? 4 : 1,geometry,density,options,image_info->filename,     postscript_filename); ,   ProgressMonitor(RenderPostscriptText,0,8);4   status=SystemCommand(image_info->verbose,command);,   ProgressMonitor(RenderPostscriptText,7,8);
   if (status)      { N       MagickWarning(CorruptImageWarning,"Portable Document delegation failed",         image_info->filename);)       (void) remove(postscript_filename);        return((Image *) NULL);      } (   local_info=CloneImageInfo(image_info);&   GetBlobInfo(&local_info->blob_info);!   image=ReadPNMImage(local_info);    DestroyImageInfo(local_info); %   (void) remove(postscript_filename); &   (void) remove(image_info->filename);   if (image == (Image *) NULL)     { N       MagickWarning(CorruptImageWarning,"Portable Document delegation failed",         image_info->filename);       return((Image *) NULL);      } 8   (void) strcpy((char *) image_info->filename,filename);   do   { '     (void) strcpy(image->magick,"PDF"); 1     (void) strcpy(filename,image_info->filename);      image->filesize=filesize;      if (!portrait)       { 
         Image            *rotated_image;   
         /*           Rotate image. 
         */,         rotated_image=RotateImage(image,90);,         if (rotated_image != (Image *) NULL)           {               DestroyImage(image);              image=rotated_image;           }        }      next_image=image->next; %     if (next_image != (Image *) NULL)        image=next_image; )   } while (next_image != (Image *) NULL); +   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P D F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method WritePDFImage writes an image in the Portable Document image
 %  format. % - %  The format of the WritePDFImage method is:  % K %      unsigned int WritePDFImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % H %    o status: Method WritePDFImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K Export unsigned int WritePDFImage(const ImageInfo *image_info,Image *image)  { 8 #define CFormat  "/Filter [ /ASCII85Decode /%.1024s ]\n" #define ObjectsPerImage  12      char     buffer[MaxTextExtent],     date[MaxTextExtent],     density[MaxTextExtent],      geometry[MaxTextExtent],
     **labels;      CompressionType      compression;     double     dx_resolution,     dy_resolution,     x_resolution,      x_scale,     y_resolution,      y_scale;     int 
     count,     status,      x,     y;     Image      encode_image,      *tile_image;     RectangleInfo      media_info;      register PixelPacket     *p;      register unsigned char     *q;      register int     i;     time_t
     timer;     unsigned char      *pixels;     unsigned int     height,      info_id,     object, 
     pages_id,      root_id,
     scene,     text_size,
     width;     unsigned long      length,      number_packets, 
     *xref;     /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);-   if ((image->file == stdout) || image->pipe)      {        /*8         Write standard output or pipe to temporary file.       */       encode_image=(*image);)       TemporaryFilename(image->filename);        image->temporary=True;8       status=OpenBlob(image_info,image,WriteBinaryType);       if (status == False)@         WriterExit(FileOpenWarning,"Unable to open file",image);     } !   compression=image->compression; 6   if (image_info->compression != UndefinedCompression)(     compression=image_info->compression;   /*     Allocate X ref memory.   */D   xref=(unsigned long *) AllocateMemory(2048*sizeof(unsigned long));%   if (xref == (unsigned long *) NULL) F     WriterExit(ResourceLimitWarning,"Memory allocation failed",image);   /*     Write Info object.   */   object=0; &   (void) strcpy(buffer,"%PDF-1.2 \n");0   (void) WriteBlob(image,strlen(buffer),buffer);!   xref[object++]=TellBlob(image);    info_id=object; -   (void) sprintf(buffer,"%u 0 obj\n",object); 0   (void) WriteBlob(image,strlen(buffer),buffer);   (void) strcpy(buffer,"<<\n"); 0   (void) WriteBlob(image,strlen(buffer),buffer);   timer=time((time_t *) NULL);   (void) localtime(&timer); $   (void) strcpy(date,ctime(&timer));   date[Extent(date)-1]='\0';:   (void) sprintf(buffer,"/CreationDate (%.1024s)\n",date);0   (void) WriteBlob(image,strlen(buffer),buffer);?   (void) sprintf(buffer,"/Producer (%.1024s)\n",MagickVersion); 0   (void) WriteBlob(image,strlen(buffer),buffer);   (void) strcpy(buffer,">>\n"); 0   (void) WriteBlob(image,strlen(buffer),buffer);#   (void) strcpy(buffer,"endobj\n"); 0   (void) WriteBlob(image,strlen(buffer),buffer);   /*     Write Catalog object.    */!   xref[object++]=TellBlob(image);    root_id=object; -   (void) sprintf(buffer,"%u 0 obj\n",object); 0   (void) WriteBlob(image,strlen(buffer),buffer);   (void) strcpy(buffer,"<<\n"); 0   (void) WriteBlob(image,strlen(buffer),buffer);+   (void) strcpy(buffer,"/Type /Catalog\n"); 0   (void) WriteBlob(image,strlen(buffer),buffer);4   (void) sprintf(buffer,"/Pages %u 0 R\n",object+1);0   (void) WriteBlob(image,strlen(buffer),buffer);   (void) strcpy(buffer,">>\n"); 0   (void) WriteBlob(image,strlen(buffer),buffer);#   (void) strcpy(buffer,"endobj\n"); 0   (void) WriteBlob(image,strlen(buffer),buffer);   /*     Write Pages object.    */!   xref[object++]=TellBlob(image);    pages_id=object;-   (void) sprintf(buffer,"%u 0 obj\n",object); 0   (void) WriteBlob(image,strlen(buffer),buffer);   (void) strcpy(buffer,"<<\n"); 0   (void) WriteBlob(image,strlen(buffer),buffer);)   (void) strcpy(buffer,"/Type /Pages\n"); 0   (void) WriteBlob(image,strlen(buffer),buffer);4   (void) sprintf(buffer,"/Kids [ %u 0 R ",object+1);0   (void) WriteBlob(image,strlen(buffer),buffer);#   count=pages_id+ObjectsPerImage+1;    if (image_info->adjoin)      {        Image          *kid_image;          /*!         Predict page object id's.        */       kid_image=image;H       for ( ; kid_image->next != (Image *) NULL; count+=ObjectsPerImage)       { /         (void) sprintf(buffer,"%d 0 R ",count); 6         (void) WriteBlob(image,strlen(buffer),buffer);"         kid_image=kid_image->next;       }        xref=(unsigned long *)K         ReallocateMemory((char *) xref,(count+2048)*sizeof(unsigned long)); )       if (xref == (unsigned long *) NULL) J         WriterExit(ResourceLimitWarning,"Memory allocation failed",image);     }    (void) strcpy(buffer,"]\n");0   (void) WriteBlob(image,strlen(buffer),buffer);H   (void) sprintf(buffer,"/Count %u\n",(count-pages_id)/ObjectsPerImage);0   (void) WriteBlob(image,strlen(buffer),buffer);   (void) strcpy(buffer,">>\n"); 0   (void) WriteBlob(image,strlen(buffer),buffer);#   (void) strcpy(buffer,"endobj\n"); 0   (void) WriteBlob(image,strlen(buffer),buffer);
   scene=0;   do   {      /*4       Scale image to size of Portable Document page.     */     text_size=0;&     if (image->label != (char *) NULL)G       text_size=MultilineCensus(image->label)*image_info->pointsize+12;      width=image->columns;      height=image->rows;      x=0;     y=text_size;>     FormatString(geometry,"%ux%u",image->columns,image->rows);*     if (image_info->page != (char *) NULL)/       (void) strcpy(geometry,image_info->page);      elseJ       if ((image->page_info.width != 0) && (image->page_info.height != 0))J         (void) FormatString(geometry,"%ux%u%+d%+d",image->page_info.width,B 	  image->page_info.height,image->page_info.x,image->page_info.y);
       else9         if (Latin1Compare(image_info->magick,"PDF") == 0) 1           (void) strcpy(geometry,PSPageGeometry); =     (void) ParseImageGeometry(geometry,&x,&y,&width,&height); <     (void) GetGeometry(geometry,&media_info.x,&media_info.y,,       &media_info.width,&media_info.height);     /*&       Scale relative to dots-per-inch.     */     dx_resolution=72.0;      dy_resolution=72.0;      x_resolution=72.0;-     (void) strcpy(density,PSDensityGeometry); @     count=sscanf(density,"%lfx%lf",&x_resolution,&y_resolution);     if (count != 2)         y_resolution=x_resolution;-     if (image_info->density != (char *) NULL)        { P         count=sscanf(image_info->density,"%lfx%lf",&x_resolution,&y_resolution);         if (count != 2) $           y_resolution=x_resolution;       } /     x_scale=(width*dx_resolution)/x_resolution; '     width=(unsigned int) (x_scale+0.5); 0     y_scale=(height*dy_resolution)/y_resolution;(     height=(unsigned int) (y_scale+0.5);     /*       Write Page object.     */#     xref[object++]=TellBlob(image); /     (void) sprintf(buffer,"%u 0 obj\n",object); 2     (void) WriteBlob(image,strlen(buffer),buffer);!     (void) strcpy(buffer,"<<\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);*     (void) strcpy(buffer,"/Type /Page\n");2     (void) WriteBlob(image,strlen(buffer),buffer);7     (void) sprintf(buffer,"/Parent %u 0 R\n",pages_id); 2     (void) WriteBlob(image,strlen(buffer),buffer);,     (void) strcpy(buffer,"/Resources <<\n");2     (void) WriteBlob(image,strlen(buffer),buffer);C     (void) sprintf(buffer,"/Font << /F%u %u 0 R >>\n",image->scene,        object+4);2     (void) WriteBlob(image,strlen(buffer),buffer);G     (void) sprintf(buffer,"/XObject << /Im%u %u 0 R >>\n",image->scene,        object+5);2     (void) WriteBlob(image,strlen(buffer),buffer);;     (void) sprintf(buffer,"/ProcSet %u 0 R >>\n",object+3); 2     (void) WriteBlob(image,strlen(buffer),buffer);<     (void) sprintf(buffer,"/MediaBox [ %d %d %d %d ]\n",0,0,*       media_info.width,media_info.height);2     (void) WriteBlob(image,strlen(buffer),buffer);9     (void) sprintf(buffer,"/Contents %u 0 R\n",object+1); 2     (void) WriteBlob(image,strlen(buffer),buffer);6     (void) sprintf(buffer,"/Thumb %u 0 R\n",object+8);2     (void) WriteBlob(image,strlen(buffer),buffer);!     (void) strcpy(buffer,">>\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);%     (void) strcpy(buffer,"endobj\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);     /*       Write Contents object.     */#     xref[object++]=TellBlob(image); /     (void) sprintf(buffer,"%u 0 obj\n",object); 2     (void) WriteBlob(image,strlen(buffer),buffer);!     (void) strcpy(buffer,"<<\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);7     (void) sprintf(buffer,"/Length %u 0 R\n",object+1); 2     (void) WriteBlob(image,strlen(buffer),buffer);!     (void) strcpy(buffer,">>\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);%     (void) strcpy(buffer,"stream\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);     length=TellBlob(image);       (void) strcpy(buffer,"q\n");2     (void) WriteBlob(image,strlen(buffer),buffer);&     labels=StringToList(image->label);!     if (labels != (char **) NULL)        { 2         for (i=0; labels[i] != (char *) NULL; i++)	         { '           (void) strcpy(buffer,"BT\n"); 8           (void) WriteBlob(image,strlen(buffer),buffer);<           (void) sprintf(buffer,"/F%u %f Tf\n",image->scene,#             image_info->pointsize); 8           (void) WriteBlob(image,strlen(buffer),buffer);8           (void) sprintf(buffer,"%d %f Td\n",x,y+height+(             i*image_info->pointsize+12);8           (void) WriteBlob(image,strlen(buffer),buffer);<           (void) sprintf(buffer,"(%.1024s) Tj\n",labels[i]);8           (void) WriteBlob(image,strlen(buffer),buffer);'           (void) strcpy(buffer,"ET\n"); 8           (void) WriteBlob(image,strlen(buffer),buffer);            FreeMemory(labels[i]);	         }          FreeMemory(labels);        } F     (void) sprintf(buffer,"%g 0 0 %g %d %d cm\n",x_scale,y_scale,x,y);2     (void) WriteBlob(image,strlen(buffer),buffer);5     (void) sprintf(buffer,"/Im%u Do\n",image->scene); 2     (void) WriteBlob(image,strlen(buffer),buffer);      (void) strcpy(buffer,"Q\n");2     (void) WriteBlob(image,strlen(buffer),buffer);"     length=TellBlob(image)-length;(     (void) strcpy(buffer,"endstream\n");2     (void) WriteBlob(image,strlen(buffer),buffer);%     (void) strcpy(buffer,"endobj\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);     /*       Write Length object.     */#     xref[object++]=TellBlob(image); /     (void) sprintf(buffer,"%u 0 obj\n",object); 2     (void) WriteBlob(image,strlen(buffer),buffer);*     (void) sprintf(buffer,"%lu\n",length);2     (void) WriteBlob(image,strlen(buffer),buffer);%     (void) strcpy(buffer,"endobj\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);     /*       Write Procset object.      */#     xref[object++]=TellBlob(image); /     (void) sprintf(buffer,"%u 0 obj\n",object); 2     (void) WriteBlob(image,strlen(buffer),buffer);5     if (!IsPseudoClass(image) && !IsGrayImage(image)) 3       (void) strcpy(buffer,"[ /PDF /Text /ImageC");      else       if (IsFaxImage(image))5         (void) strcpy(buffer,"[ /PDF /Text /ImageB"); 
       else5         (void) strcpy(buffer,"[ /PDF /Text /ImageI"); 2     (void) WriteBlob(image,strlen(buffer),buffer);!     (void) strcpy(buffer," ]\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);%     (void) strcpy(buffer,"endobj\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);     /*       Write Font object.     */#     xref[object++]=TellBlob(image); /     (void) sprintf(buffer,"%u 0 obj\n",object); 2     (void) WriteBlob(image,strlen(buffer),buffer);!     (void) strcpy(buffer,"<<\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);*     (void) strcpy(buffer,"/Type /Font\n");2     (void) WriteBlob(image,strlen(buffer),buffer);.     (void) strcpy(buffer,"/Subtype /Type1\n");2     (void) WriteBlob(image,strlen(buffer),buffer);7     (void) sprintf(buffer,"/Name /F%u\n",image->scene); 2     (void) WriteBlob(image,strlen(buffer),buffer);3     (void) strcpy(buffer,"/BaseFont /Helvetica\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);:     (void) strcpy(buffer,"/Encoding /MacRomanEncoding\n");2     (void) WriteBlob(image,strlen(buffer),buffer);!     (void) strcpy(buffer,">>\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);%     (void) strcpy(buffer,"endobj\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);     /*       Write XObject object.      */#     xref[object++]=TellBlob(image); /     (void) sprintf(buffer,"%u 0 obj\n",object); 2     (void) WriteBlob(image,strlen(buffer),buffer);!     (void) strcpy(buffer,"<<\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);-     (void) strcpy(buffer,"/Type /XObject\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);.     (void) strcpy(buffer,"/Subtype /Image\n");2     (void) WriteBlob(image,strlen(buffer),buffer);8     (void) sprintf(buffer,"/Name /Im%u\n",image->scene);2     (void) WriteBlob(image,strlen(buffer),buffer);%     if (compression == NoCompression) 7       (void) strcpy(buffer,"/Filter /ASCII85Decode\n");      else       if (!IsFaxImage(image)) 	         {            switch (compression)           { M             case JPEGCompression: sprintf(buffer,CFormat,"DCTDecode"); break; L             case LZWCompression: sprintf(buffer,CFormat,"LZWDecode"); break;N             case ZipCompression: sprintf(buffer,CFormat,"FlateDecode"); break;F             default: sprintf(buffer,CFormat,"RunLengthDecode"); break;           } 8           (void) WriteBlob(image,strlen(buffer),buffer);	         } 
       else	         {            (void) strcpy(buffer, <             "/Filter [ /ASCII85Decode /CCITTFaxDecode ]\n");8           (void) WriteBlob(image,strlen(buffer),buffer);            (void) sprintf(buffer,M             "/DecodeParms [ << >> << /K %.1024s /Columns %d /Rows %d >> ]\n", 3             CCITTParam,image->columns,image->rows); 8           (void) WriteBlob(image,strlen(buffer),buffer);	         } 8     (void) sprintf(buffer,"/Width %u\n",image->columns);2     (void) WriteBlob(image,strlen(buffer),buffer);6     (void) sprintf(buffer,"/Height %u\n",image->rows);2     (void) WriteBlob(image,strlen(buffer),buffer);;     (void) sprintf(buffer,"/ColorSpace %u 0 R\n",object+2); 2     (void) WriteBlob(image,strlen(buffer),buffer);3     (void) sprintf(buffer,"/BitsPerComponent %d\n", !       IsFaxImage(image) ? 1 : 8); 2     (void) WriteBlob(image,strlen(buffer),buffer);7     (void) sprintf(buffer,"/Length %u 0 R\n",object+1); 2     (void) WriteBlob(image,strlen(buffer),buffer);!     (void) strcpy(buffer,">>\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);%     (void) strcpy(buffer,"stream\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);     length=TellBlob(image);      p=image->pixels;5     if (!IsPseudoClass(image) && !IsGrayImage(image))        switch (compression)       {          case JPEGCompression: 	         {            char$             filename[MaxTextExtent];             FILE             *file;             Image              *jpeg_image;  
           int              c;             /*9             Write image to temporary file in JPEG format.            */&           TemporaryFilename(filename);G           jpeg_image=CloneImage(image,image->columns,image->rows,True); +           if (jpeg_image == (Image *) NULL) F             WriterExit(DelegateWarning,"Unable to clone image",image);7           (void) strcpy(jpeg_image->filename,filename); 7           status=WriteJPEGImage(image_info,jpeg_image); #           DestroyImage(jpeg_image);            if (status == False)F             WriterExit(DelegateWarning,"Unable to write image",image);.           file=fopen(filename,ReadBinaryType);$           if (file == (FILE *) NULL)D             WriterExit(FileOpenWarning,"Unable to open file",image);           Ascii85Initialize();6           for (c=fgetc(file); c != EOF; c=fgetc(file))#             Ascii85Encode(image,c);            Ascii85Flush(image);           (void) fclose(file);"           (void) remove(filename);           break;	         } )         case RunlengthEncodedCompression:          default:	         {            /*!             Allocate pixel array.            */G           number_packets=(image->colorspace == CMYKColorspace ? 4 : 3)* '             image->columns*image->rows; "           pixels=(unsigned char *)A             AllocateMemory(number_packets*sizeof(unsigned char)); /           if (pixels == (unsigned char *) NULL) N             WriterExit(ResourceLimitWarning,"Memory allocation failed",image);           /**             Dump runlength encoded pixels.           */           q=pixels; /           for (y=0; y < (int) image->rows; y++)            { 8             p=GetPixelCache(image,0,y,image->columns,1);*             if (p == (PixelPacket *) NULL)               break;4             for (x=0; x < (int) image->columns; x++)
             { >               if (image->matte && (p->opacity == Transparent))                 { )                   *q++=DownScale(MaxRGB); )                   *q++=DownScale(MaxRGB); )                   *q++=DownScale(MaxRGB);                  }                else8                 if (image->colorspace != CMYKColorspace)                   { +                     *q++=DownScale(p->red); -                     *q++=DownScale(p->green); ,                     *q++=DownScale(p->blue);                   }                  else                   { +                     *q++=DownScale(p->red); -                     *q++=DownScale(p->green); ,                     *q++=DownScale(p->blue);/                     *q++=DownScale(p->opacity);                    }                p++;
             } 2             if (image->previous == (Image *) NULL)-               if (QuantumTick(y,image->rows)) =                 ProgressMonitor(SaveImageText,y,image->rows);            } ,           if (compression == ZipCompression)             status= O               ZLIBEncodeImage(image,number_packets,image_info->quality,pixels);            else.             if (compression == LZWCompression)A               status=LZWEncodeImage(image,number_packets,pixels);              elseF               status=PackbitsEncodeImage(image,number_packets,pixels);           FreeMemory(pixels);            if (!status)
             {                CloseBlob(image);                return(False);
             }            break;	         }          case NoCompression: 	         {            /*2             Dump uncompressed DirectColor packets.           */           Ascii85Initialize();/           for (y=0; y < (int) image->rows; y++)            { 8             p=GetPixelCache(image,0,y,image->columns,1);*             if (p == (PixelPacket *) NULL)               break;4             for (x=0; x < (int) image->columns; x++)
             { >               if (image->matte && (p->opacity == Transparent))                 { 9                   Ascii85Encode(image,DownScale(MaxRGB)); 9                   Ascii85Encode(image,DownScale(MaxRGB)); 9                   Ascii85Encode(image,DownScale(MaxRGB));                  }                else8                 if (image->colorspace != CMYKColorspace)                   { ;                     Ascii85Encode(image,DownScale(p->red)); =                     Ascii85Encode(image,DownScale(p->green)); <                     Ascii85Encode(image,DownScale(p->blue));                   }                  else                   { ;                     Ascii85Encode(image,DownScale(p->red)); =                     Ascii85Encode(image,DownScale(p->green)); <                     Ascii85Encode(image,DownScale(p->blue));?                     Ascii85Encode(image,DownScale(p->opacity));                    }                p++;
             } 2             if (image->previous == (Image *) NULL)-               if (QuantumTick(y,image->rows)) =                 ProgressMonitor(SaveImageText,y,image->rows);            }            Ascii85Flush(image);           break;	         }        }      else       if (IsFaxImage(image))	         {             register unsigned char             bit,             byte,              polarity;   A           polarity=Intensity(image->colormap[0]) > (MaxRGB >> 1); !           if (image->colors == 2)              polarity= L               Intensity(image->colormap[0]) < Intensity(image->colormap[1]);           switch (compression)           { -             case RunlengthEncodedCompression:              default:
             { 5               if (Latin1Compare(CCITTParam,"0") == 0) J                 (void) HuffmanEncodeImage((ImageInfo *) image_info,image);               elseL                 (void) Huffman2DEncodeImage((ImageInfo *) image_info,image);               break;
             }              case NoCompression: 
             {                /*6                 Dump uncompressed PseudoColor packets.               */"               Ascii85Initialize();3               for (y=0; y < (int) image->rows; y++)                { ?                 if (!GetPixelCache(image,0,y,image->columns,1))                    break;                 bit=0;                 byte=0; 8                 for (x=0; x < (int) image->columns; x++)                 {                    byte<<=1; 4                   if (image->indexes[x] == polarity)                     byte|=0x01;                    bit++;                   if (bit == 8)                      { 0                       Ascii85Encode(image,byte);                       bit=0;                       byte=0;                      }                    p++;                 }                  if (bit != 0) 7                   Ascii85Encode(image,byte << (8-bit)); 6                 if (image->previous == (Image *) NULL)1                   if (QuantumTick(y,image->rows)) A                     ProgressMonitor(SaveImageText,y,image->rows);                } "               Ascii85Flush(image);               break;
             }            } 	         } 
       else	         {            /*/             Dump number of colors and colormap.            */           switch (compression)           { -             case RunlengthEncodedCompression:              default:
             {                /*%                 Allocate pixel array.                */8               number_packets=image->columns*image->rows;&               pixels=(unsigned char *)E                 AllocateMemory(number_packets*sizeof(unsigned char)); 3               if (pixels == (unsigned char *) NULL) K                 WriterExit(ResourceLimitWarning,"Memory allocation failed",                    image);                /*.                 Dump Runlength encoded pixels.               */               q=pixels; 3               for (y=0; y < (int) image->rows; y++)                { ?                 if (!GetPixelCache(image,0,y,image->columns,1))                    break;8                 for (x=0; x < (int) image->columns; x++)                 { 9                   *q++=(unsigned char) image->indexes[x];                    p++;                 } 6                 if (image->previous == (Image *) NULL)1                   if (QuantumTick(y,image->rows)) A                     ProgressMonitor(SaveImageText,y,image->rows);                } 0               if (compression == ZipCompression)P                 status=ZLIBEncodeImage(image,number_packets,image_info->quality,                   pixels);               else2                 if (compression == LZWCompression)E                   status=LZWEncodeImage(image,number_packets,pixels);                  elseJ                   status=PackbitsEncodeImage(image,number_packets,pixels);!               FreeMemory(pixels);                if (!status)                 { #                   CloseBlob(image);                     return(False);                 }                break;
             }              case NoCompression: 
             {                /*6                 Dump uncompressed PseudoColor packets.               */"               Ascii85Initialize();3               for (y=0; y < (int) image->rows; y++)                { ?                 if (!GetPixelCache(image,0,y,image->columns,1))                    break;8                 for (x=0; x < (int) image->columns; x++)                 { I                   Ascii85Encode(image,(unsigned char) image->indexes[x]);                    p++;                 } 6                 if (image->previous == (Image *) NULL)1                   if (QuantumTick(y,image->rows)) A                     ProgressMonitor(SaveImageText,y,image->rows);                } "               Ascii85Flush(image);               break;
             }            } 	         } "     length=TellBlob(image)-length;*     (void) strcpy(buffer,"\nendstream\n");2     (void) WriteBlob(image,strlen(buffer),buffer);%     (void) strcpy(buffer,"endobj\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);     /*       Write Length object.     */#     xref[object++]=TellBlob(image); /     (void) sprintf(buffer,"%u 0 obj\n",object); 2     (void) WriteBlob(image,strlen(buffer),buffer);*     (void) sprintf(buffer,"%lu\n",length);2     (void) WriteBlob(image,strlen(buffer),buffer);%     (void) strcpy(buffer,"endobj\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);     /*       Write Colorspace object.     */#     xref[object++]=TellBlob(image); /     (void) sprintf(buffer,"%u 0 obj\n",object); 2     (void) WriteBlob(image,strlen(buffer),buffer);,     if (image->colorspace == CMYKColorspace),       (void) strcpy(buffer,"/DeviceCMYK\n");     else7       if (!IsPseudoClass(image) && !IsGrayImage(image)) -         (void) strcpy(buffer,"/DeviceRGB\n"); 
       else         if (IsFaxImage(image))0           (void) strcpy(buffer,"/DeviceGray\n");         elseF           (void) sprintf(buffer,"[ /Indexed /DeviceRGB %u %u 0 R ]\n",&             image->colors-1,object+3);2     (void) WriteBlob(image,strlen(buffer),buffer);%     (void) strcpy(buffer,"endobj\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);     /*       Write Thumb object.      */     width=image->columns;      height=image->rows;      x=0;     y=0;     image->orphan=True; C     (void) ParseImageGeometry("106x106+0+0>",&x,&y,&width,&height); $     if (image->class == PseudoClass)1       tile_image=SampleImage(image,width,height);      else/       tile_image=ZoomImage(image,width,height);      image->orphan=False;%     if (tile_image == (Image *) NULL) H       WriterExit(ResourceLimitWarning,"Memory allocation failed",image);#     xref[object++]=TellBlob(image); /     (void) sprintf(buffer,"%u 0 obj\n",object); 2     (void) WriteBlob(image,strlen(buffer),buffer);!     (void) strcpy(buffer,"<<\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);%     if (compression == NoCompression) 7       (void) strcpy(buffer,"/Filter /ASCII85Decode\n");      else       if (!IsFaxImage(image)) 	         { H           (void) sprintf(buffer,"/Filter [ /ASCII85Decode /%.1024s ]\n",;             compression == ZipCompression ? "FlateDecode" : M             compression == LZWCompression ? "LZWDecode" : "RunLengthDecode"); 8           (void) WriteBlob(image,strlen(buffer),buffer);	         } 
       else	         {            (void) strcpy(buffer, <             "/Filter [ /ASCII85Decode /CCITTFaxDecode ]\n");8           (void) WriteBlob(image,strlen(buffer),buffer);            (void) sprintf(buffer,B             "/DecodeParms [ << >> << /Columns %d /Rows %d >> ]\n",2             tile_image->columns,tile_image->rows);8           (void) WriteBlob(image,strlen(buffer),buffer);	         } =     (void) sprintf(buffer,"/Width %u\n",tile_image->columns); 2     (void) WriteBlob(image,strlen(buffer),buffer);;     (void) sprintf(buffer,"/Height %u\n",tile_image->rows); 2     (void) WriteBlob(image,strlen(buffer),buffer);;     (void) sprintf(buffer,"/ColorSpace %u 0 R\n",object-1); 2     (void) WriteBlob(image,strlen(buffer),buffer);3     (void) sprintf(buffer,"/BitsPerComponent %d\n", &       IsFaxImage(tile_image) ? 1 : 8);2     (void) WriteBlob(image,strlen(buffer),buffer);7     (void) sprintf(buffer,"/Length %u 0 R\n",object+1); 2     (void) WriteBlob(image,strlen(buffer),buffer);!     (void) strcpy(buffer,">>\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);%     (void) strcpy(buffer,"stream\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);     length=TellBlob(image);      p=tile_image->pixels; ?     if (!IsPseudoClass(tile_image) && !IsGrayImage(tile_image))        switch (compression)       { )         case RunlengthEncodedCompression:          default:	         {            /*!             Allocate pixel array.            */G           number_packets=(image->colorspace == CMYKColorspace ? 4 : 3)* '             image->columns*image->rows; "           pixels=(unsigned char *)A             AllocateMemory(number_packets*sizeof(unsigned char)); /           if (pixels == (unsigned char *) NULL) 
             { '               DestroyImage(tile_image); P               WriterExit(ResourceLimitWarning,"Memory allocation failed",image);
             }            /**             Dump runlength encoded pixels.           */           q=pixels; 4           for (y=0; y < (int) tile_image->rows; y++)           { B             p=GetPixelCache(tile_image,0,y,tile_image->columns,1);*             if (p == (PixelPacket *) NULL)               break;9             for (x=0; x < (int) tile_image->columns; x++) 
             { C               if (tile_image->matte && (p->opacity == Transparent))                  { )                   *q++=DownScale(MaxRGB); )                   *q++=DownScale(MaxRGB); )                   *q++=DownScale(MaxRGB);                  }                else                 { )                   *q++=DownScale(p->red); +                   *q++=DownScale(p->green); *                   *q++=DownScale(p->blue);:                   if (image->colorspace == CMYKColorspace)/                     *q++=DownScale(p->opacity);                  }                p++;
             }            } ,           if (compression == ZipCompression)             status= O               ZLIBEncodeImage(image,number_packets,image_info->quality,pixels);            else.             if (compression == LZWCompression)A               status=LZWEncodeImage(image,number_packets,pixels);              elseF               status=PackbitsEncodeImage(image,number_packets,pixels);           FreeMemory(pixels);            if (!status)
             {                CloseBlob(image);                return(False);
             }            break;	         }          case NoCompression: 	         {            /*2             Dump uncompressed DirectColor packets.           */           Ascii85Initialize();4           for (y=0; y < (int) tile_image->rows; y++)           { B             p=GetPixelCache(tile_image,0,y,tile_image->columns,1);*             if (p == (PixelPacket *) NULL)               break;9             for (x=0; x < (int) tile_image->columns; x++) 
             { C               if (tile_image->matte && (p->opacity == Transparent))                  { 9                   Ascii85Encode(image,DownScale(MaxRGB)); 9                   Ascii85Encode(image,DownScale(MaxRGB)); 9                   Ascii85Encode(image,DownScale(MaxRGB));                  }                else                 { 9                   Ascii85Encode(image,DownScale(p->red)); ;                   Ascii85Encode(image,DownScale(p->green)); :                   Ascii85Encode(image,DownScale(p->blue));:                   if (image->colorspace == CMYKColorspace)?                     Ascii85Encode(image,DownScale(p->opacity));                  }                p++;
             }            }            Ascii85Flush(image);           break;	         }        }      else!       if (IsFaxImage(tile_image)) 	         {             register unsigned char             bit,             byte,              polarity;   F           polarity=Intensity(tile_image->colormap[0]) > (MaxRGB >> 1);!           if (image->colors == 2) 9             polarity=Intensity(tile_image->colormap[0]) < 1               Intensity(tile_image->colormap[1]);            switch (compression)           { -             case RunlengthEncodedCompression:              default:
             {                /*%                 Allocate pixel array.                */M               number_packets=((tile_image->columns+7) >> 3)*tile_image->rows; &               pixels=(unsigned char *)E                 AllocateMemory(number_packets*sizeof(unsigned char)); 3               if (pixels == (unsigned char *) NULL)                  { +                   DestroyImage(tile_image); M                   WriterExit(ResourceLimitWarning,"Memory allocation failed",                      image);                  }                /*.                 Dump Runlength encoded pixels.               */               q=pixels; 8               for (y=0; y < (int) tile_image->rows; y++)               { I                 if (!GetPixelCache(tile_image,0,y,tile_image->columns,1))                    break;                 bit=0;                 byte=0; =                 for (x=0; x < (int) tile_image->columns; x++)                  {                    byte<<=1; 9                   if (tile_image->indexes[x] == polarity)                      byte|=0x01;                    bit++;                   if (bit == 8)                      {                         *q++=byte;                       bit=0;                       byte=0;                      }                    p++;                 }                  if (bit != 0) '                   *q++=byte << (8-bit); 6                 if (image->previous == (Image *) NULL)6                   if (QuantumTick(y,tile_image->rows))F                     ProgressMonitor(SaveImageText,y,tile_image->rows);               } 0               if (compression == ZipCompression)P                 status=ZLIBEncodeImage(image,number_packets,image_info->quality,                   pixels);               else2                 if (compression == LZWCompression)E                   status=LZWEncodeImage(image,number_packets,pixels);                  elseJ                   status=PackbitsEncodeImage(image,number_packets,pixels);!               FreeMemory(pixels);                if (!status)                 { #                   CloseBlob(image);                     return(False);                 }                break;
             }              case NoCompression: 
             {                /*6                 Dump uncompressed PseudoColor packets.               */"               Ascii85Initialize();8               for (y=0; y < (int) tile_image->rows; y++)               { I                 if (!GetPixelCache(tile_image,0,y,tile_image->columns,1))                    break;                 bit=0;                 byte=0; =                 for (x=0; x < (int) tile_image->columns; x++)                  {                    byte<<=1; 9                   if (tile_image->indexes[x] == polarity)                      byte|=0x01;                    bit++;                   if (bit == 8)                      { 0                       Ascii85Encode(image,byte);                       bit=0;                       byte=0;                      }                    p++;                 }                  if (bit != 0) 7                   Ascii85Encode(image,byte << (8-bit)); 6                 if (image->previous == (Image *) NULL)6                   if (QuantumTick(y,tile_image->rows))F                     ProgressMonitor(SaveImageText,y,tile_image->rows);               } "               Ascii85Flush(image);               break;
             }            } 	         } 
       else	         {            /*/             Dump number of colors and colormap.            */           switch (compression)           { -             case RunlengthEncodedCompression:              default:
             {                /*%                 Allocate pixel array.                */B               number_packets=tile_image->columns*tile_image->rows;&               pixels=(unsigned char *)E                 AllocateMemory(number_packets*sizeof(unsigned char)); 3               if (pixels == (unsigned char *) NULL)                  { +                   DestroyImage(tile_image); M                   WriterExit(ResourceLimitWarning,"Memory allocation failed",                      image);                  }                /*.                 Dump Runlength encoded pixels.               */               q=pixels; 8               for (y=0; y < (int) tile_image->rows; y++)               { I                 if (!GetPixelCache(tile_image,0,y,tile_image->columns,1))                    break;=                 for (x=0; x < (int) tile_image->columns; x++)                  { >                   *q++=(unsigned char) tile_image->indexes[x];                   p++;                 }                } 0               if (compression == ZipCompression)P                 status=ZLIBEncodeImage(image,number_packets,image_info->quality,                   pixels);               else2                 if (compression == LZWCompression)E                   status=LZWEncodeImage(image,number_packets,pixels);                  elseJ                   status=PackbitsEncodeImage(image,number_packets,pixels);!               FreeMemory(pixels);                if (!status)                 { #                   CloseBlob(image);                     return(False);                 }                break;
             }              case NoCompression: 
             {                /*6                 Dump uncompressed PseudoColor packets.               */"               Ascii85Initialize();8               for (y=0; y < (int) tile_image->rows; y++)               { I                 if (!GetPixelCache(tile_image,0,y,tile_image->columns,1))                    break;=                 for (x=0; x < (int) tile_image->columns; x++)                  { >                   Ascii85Encode(image,tile_image->indexes[x]);                   p++;                 }                } "               Ascii85Flush(image);               break;
             }            } 	         }      DestroyImage(tile_image); "     length=TellBlob(image)-length;*     (void) strcpy(buffer,"\nendstream\n");2     (void) WriteBlob(image,strlen(buffer),buffer);%     (void) strcpy(buffer,"endobj\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);     /*       Write Length object.     */#     xref[object++]=TellBlob(image); /     (void) sprintf(buffer,"%u 0 obj\n",object); 2     (void) WriteBlob(image,strlen(buffer),buffer);*     (void) sprintf(buffer,"%lu\n",length);2     (void) WriteBlob(image,strlen(buffer),buffer);%     (void) strcpy(buffer,"endobj\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);;     if ((image->class == DirectClass) || IsFaxImage(image))        {          xref[object++]=0;          xref[object++]=0;        }      else       { 
         /*            Write Colormap object.
         */'         xref[object++]=TellBlob(image); 3         (void) sprintf(buffer,"%u 0 obj\n",object); 6         (void) WriteBlob(image,strlen(buffer),buffer);%         (void) strcpy(buffer,"<<\n"); 6         (void) WriteBlob(image,strlen(buffer),buffer);:         (void) strcpy(buffer,"/Filter /ASCII85Decode \n");6         (void) WriteBlob(image,strlen(buffer),buffer);;         (void) sprintf(buffer,"/Length %u 0 R\n",object+1); 6         (void) WriteBlob(image,strlen(buffer),buffer);%         (void) strcpy(buffer,">>\n"); 6         (void) WriteBlob(image,strlen(buffer),buffer);)         (void) strcpy(buffer,"stream\n"); 6         (void) WriteBlob(image,strlen(buffer),buffer);         length=TellBlob(image);          Ascii85Initialize();/         for (i=0; i < (int) image->colors; i++) 	         { A           Ascii85Encode(image,DownScale(image->colormap[i].red)); C           Ascii85Encode(image,DownScale(image->colormap[i].green)); B           Ascii85Encode(image,DownScale(image->colormap[i].blue));	         }          Ascii85Flush(image);&         length=TellBlob(image)-length;.         (void) strcpy(buffer,"\nendstream\n");6         (void) WriteBlob(image,strlen(buffer),buffer);)         (void) strcpy(buffer,"endobj\n"); 6         (void) WriteBlob(image,strlen(buffer),buffer);
         /*           Write Length object.
         */'         xref[object++]=TellBlob(image); 3         (void) sprintf(buffer,"%u 0 obj\n",object); 6         (void) WriteBlob(image,strlen(buffer),buffer);.         (void) sprintf(buffer,"%lu\n",length);6         (void) WriteBlob(image,strlen(buffer),buffer);)         (void) strcpy(buffer,"endobj\n"); 6         (void) WriteBlob(image,strlen(buffer),buffer);       } &     if (image->next == (Image *) NULL)       break;     image=GetNextImage(image);C     ProgressMonitor(SaveImagesText,scene++,GetNumberScenes(image));    } while (image_info->adjoin);    if (image_info->adjoin) -     while (image->previous != (Image *) NULL)        image=image->previous;   /*     Write Xref object.   */$   length=TellBlob(image)-xref[0]+10;!   (void) strcpy(buffer,"xref\n"); 0   (void) WriteBlob(image,strlen(buffer),buffer);+   (void) sprintf(buffer,"0 %u\n",object+1); 0   (void) WriteBlob(image,strlen(buffer),buffer);0   (void) strcpy(buffer,"0000000000 65535 f \n");0   (void) WriteBlob(image,strlen(buffer),buffer);"   for (i=0; i < (int) object; i++)   { 7     (void) sprintf(buffer,"%010lu 00000 n \n",xref[i]); 2     (void) WriteBlob(image,strlen(buffer),buffer);   } $   (void) strcpy(buffer,"trailer\n");0   (void) WriteBlob(image,strlen(buffer),buffer);   (void) strcpy(buffer,"<<\n"); 0   (void) WriteBlob(image,strlen(buffer),buffer);/   (void) sprintf(buffer,"/Size %u\n",object+1); 0   (void) WriteBlob(image,strlen(buffer),buffer);2   (void) sprintf(buffer,"/Info %u 0 R\n",info_id);0   (void) WriteBlob(image,strlen(buffer),buffer);2   (void) sprintf(buffer,"/Root %u 0 R\n",root_id);0   (void) WriteBlob(image,strlen(buffer),buffer);   (void) strcpy(buffer,">>\n"); 0   (void) WriteBlob(image,strlen(buffer),buffer);&   (void) strcpy(buffer,"startxref\n");0   (void) WriteBlob(image,strlen(buffer),buffer);(   (void) sprintf(buffer,"%lu\n",length);0   (void) WriteBlob(image,strlen(buffer),buffer);"   (void) strcpy(buffer,"%%EOF\n");0   (void) WriteBlob(image,strlen(buffer),buffer);   FreeMemory(xref);    CloseBlob(image);    if (image->temporary)      { 
       FILE         *file;  	       int 
         c;         /*7         Copy temporary file to standard output or pipe.        */1       file=fopen(image->filename,ReadBinaryType);         if (file == (FILE *) NULL)@         WriterExit(FileOpenWarning,"Unable to open file",image);2       for (c=fgetc(file); c != EOF; c=fgetc(file)))         (void) putc(c,encode_image.file);        (void) fclose(file);%       (void) remove(image->filename);        image->temporary=False;        CloseBlob(&encode_image);      }    return(True);  } 