 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            PPPP   N   N  M   M                              % O %                            P   P  NN  N  MM MM                              % O %                            PPPP   N N N  M M M                              % O %                            P      N  NN  M   M                              % O %                            P      N   N  M   M                              % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s P N M                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method IsPNM returns True if the image format type, identified by the %  magick string, is PNM.  % , %  The format of the ReadPNMImage method is: % 6 %      unsigned int IsPNM(const unsigned char *magick,# %        const unsigned int length)  % + %  A description of each parameter follows:  % J %    o status:  Method IsPNM returns True if the image format type is PNM. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */P Export unsigned int IsPNM(const unsigned char *magick,const unsigned int length) {    if (length < 2)      return(False);3   if ((*magick == 'P') && isdigit((int) magick[1]))      return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d P N M I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method ReadPNMImage reads a Portable Anymap image file and returns it. L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. % , %  The format of the ReadPNMImage method is: % 7 %      Image *ReadPNMImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadPNMImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */  D static unsigned int PNMInteger(Image *image,const unsigned int base) { $ #define P7Comment  "END_OF_COMMENTS"     int      c;     unsigned int
     value;     /*      Skip any leading whitespace.   */   do   {      c=ReadByte(image);     if (c == EOF)        return(0);     if (c == '#')        {          register char 
           *p, 
           *q;            unsigned int           length,            offset;   
         /*           Read comment. 
         */-         if (image->comments != (char *) NULL)            { 6             p=image->comments+Extent(image->comments);%             length=p-image->comments;            }          else           { !             length=MaxTextExtent; $             image->comments=(char *)H               AllocateMemory((length+strlen(P7Comment)+1)*sizeof(char));             p=image->comments;           } !         offset=p-image->comments; -         if (image->comments != (char *) NULL) 1           for ( ; (c != EOF) && (c != '\n'); p++)            { .             if ((p-image->comments) >= length)               {                  length<<=1; &                 length+=MaxTextExtent;B                 image->comments=(char *) ReallocateMemory((char *)M                   image->comments,(length+strlen(P7Comment)+1)*sizeof(char)); 5                 if (image->comments == (char *) NULL)                    break;:                 p=image->comments+Extent(image->comments);               }              c=ReadByte(image);             *p=(char) c;             *(p+1)='\0';           } -         if (image->comments == (char *) NULL)            { J             MagickWarning(ResourceLimitWarning,"Memory allocation failed",               (char *) NULL);              return(0);           } !         q=image->comments+offset; ,         if (Latin1Compare(q,P7Comment) == 0)           *q='\0';         continue;        }    } while (!isdigit(c));   if (base == 2)     return(c-'0');   /*     Evaluate number.   */
   value=0;   do   {      value*=10;     value+=c-'0';      c=ReadByte(image);     if (c == EOF)        return(0);   }    while (isdigit(c));    return(value); }   7 Export Image *ReadPNMImage(const ImageInfo *image_info)  {  #define MaxRawValue  255     char     format;      Image      *image;   
   IndexPacket 
     index;     int      y;     MonitorHandler     handler;  	   Quantum      *scale;      register int     i,     x;     register PixelPacket     *q;      unsigned int     max_value,     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*     Read PNM image.    */,   status=ReadBlob(image,1,(char *) &format);   do   {      /*       Verify PNM identifier.     */-     if ((status == False) || (format != 'P')) C       ReaderExit(CorruptImageWarning,"Not a PNM image file",image);      /*!       Initialize image structure.      */     format=ReadByte(image);      if (format == '7')"       (void) PNMInteger(image,10);(     image->columns=PNMInteger(image,10);%     image->rows=PNMInteger(image,10); +     if ((format == '1') || (format == '4'))         max_value=1;  /* bitmap */     else%       max_value=PNMInteger(image,10); +     if ((format != '3') && (format != '6'))        { !         image->class=PseudoClass; "         image->colors=max_value+1;       }      if (image_info->ping)        {          CloseBlob(image);          return(image);       } *     if ((image->columns*image->rows) == 0)%       ReaderExit(CorruptImageWarning, A         "Unable to read image: image dimensions are zero",image);      scale=(Quantum *) NULL; $     if (image->class == PseudoClass)       { 
         /*           Create colormap.
         */'         image->colormap=(PixelPacket *) <           AllocateMemory(image->colors*sizeof(PixelPacket));4         if (image->colormap == (PixelPacket *) NULL)L           ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);         if (format != '7')1           for (i=0; i < (int) image->colors; i++)            { #             image->colormap[i].red= =               ((unsigned long) (MaxRGB*i)/(image->colors-1)); %             image->colormap[i].green= =               ((unsigned long) (MaxRGB*i)/(image->colors-1)); $             image->colormap[i].blue==               ((unsigned long) (MaxRGB*i)/(image->colors-1));            }          else           {              int                blue,                green,               red;               /*&               Initialize 332 colormap.             */             i=0;'             for (red=0; red < 8; red++) /               for (green=0; green < 8; green++) .                 for (blue=0; blue < 4; blue++)                 { M                   image->colormap[i].red=((unsigned long) (MaxRGB*red)/0x07); +                   image->colormap[i].green= :                     ((unsigned long) (green*MaxRGB)/0x07);O                   image->colormap[i].blue=((unsigned long) (MaxRGB*blue)/0x03);                    i++;                 }            }        }      else       if (max_value != MaxRGB)	         {            /*(             Compute pixel scaling table.           */J           scale=(Quantum *) AllocateMemory((max_value+1)*sizeof(Quantum));(           if (scale == (Quantum *) NULL)N             ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);.           for (i=0; i <= (int) max_value; i++)G             scale[i]=(Quantum) ((i*MaxRGB+(max_value >> 1))/max_value); 	         }      /*;       Convert PNM pixels to runlength-encoded MIFF packets.      */     switch (format)      {        case '1':        { 
         /*-           Convert PBM image to pixel packets. 
         */-         for (y=0; y < (int) image->rows; y++) 	         { 6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           { '             index=!PNMInteger(image,2); $             image->indexes[x]=index;(             *q++=image->colormap[index];           } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(LoadImageText,y,image->rows); 	         }          break;       }        case '2':        { 
         /*-           Convert PGM image to pixel packets. 
         */-         for (y=0; y < (int) image->rows; y++) 	         { 6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           { '             index=PNMInteger(image,10); $             image->indexes[x]=index;(             *q++=image->colormap[index];           } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(LoadImageText,y,image->rows); 	         }          break;       }        case '3':        { 
         /*-           Convert PNM image to pixel packets. 
         */-         for (y=0; y < (int) image->rows; y++) 	         { 6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           { (             q->red=PNMInteger(image,10);*             q->green=PNMInteger(image,10);)             q->blue=PNMInteger(image,10); *             if (scale != (Quantum *) NULL)               { %                 q->red=scale[q->red]; )                 q->green=scale[q->green]; '                 q->blue=scale[q->blue];                }              q++;           } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(LoadImageText,y,image->rows); 	         }          break;       }        case '4':        {          unsigned char            bit,           byte;   
         /*1           Convert PBM raw image to pixel packets. 
         */-         for (y=0; y < (int) image->rows; y++) 	         { 6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;           bit=0;           byte=0; 2           for (x=0; x < (int) image->columns; x++)           {              if (bit == 0) #               byte=ReadByte(image); (             index=(byte & 0x80) ? 0 : 1;$             image->indexes[x]=index;(             *q++=image->colormap[index];             bit++;             if (bit == 8)                bit=0;             byte<<=1;            } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(LoadImageText,y,image->rows); 	         }          break;       }        case '5':        case '7':        { 
         /*1           Convert PGM raw image to pixel packets. 
         */-         for (y=0; y < (int) image->rows; y++) 	         { 6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           { )             if (max_value <= MaxRawValue) $               index=ReadByte(image);             else-               index=LSBFirstReadShort(image); "             if (index > max_value)               index=max_value;$             image->indexes[x]=index;(             *q++=image->colormap[index];           } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(LoadImageText,y,image->rows); 	         }          break;       }        case '6':        { 
         /*4           Convert PNM raster image to pixel packets.
         */-         for (y=0; y < (int) image->rows; y++) 	         { 6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           { )             if (max_value <= MaxRawValue)                { '                 q->red=ReadByte(image); )                 q->green=ReadByte(image); (                 q->blue=ReadByte(image);               }              else               { 0                 q->red=LSBFirstReadShort(image);2                 q->green=LSBFirstReadShort(image);1                 q->blue=LSBFirstReadShort(image);                } *             if (scale != (Quantum *) NULL)               { %                 q->red=scale[q->red]; )                 q->green=scale[q->green]; '                 q->blue=scale[q->blue];                }              q++;           } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(LoadImageText,y,image->rows); 	         } 9         handler=SetMonitorHandler((MonitorHandler) NULL); *         (void) SetMonitorHandler(handler);         break;       }        default:E         ReaderExit(CorruptImageWarning,"Not a PNM image file",image);      } "     if (scale != (Quantum *) NULL)       FreeMemory(scale);     if (EOFBlob(image)) M       MagickWarning(CorruptImageWarning,"not enough pixels",image->filename);      /*       Proceed to next image.     */"     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;>     if ((format == '1') || (format == '2') || (format == '3'))       do       { 
         /*           Skip to end of line.
         */)         status=ReadBlob(image,1,&format);          if (status == False)           break;       } while (format != '\n'); .     status=ReadBlob(image,1,(char *) &format);,     if ((status == True) && (format == 'P'))       { 
         /*(           Allocate next image structure.
         */,         AllocateNextImage(image_info,image);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            }          image=image->next;F         ProgressMonitor(LoadImagesText,(unsigned int) TellBlob(image),*           (unsigned int) image->filesize);       } 0   } while ((status == True) && (format == 'P'));+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P N M I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Procedure WritePNMImage writes an image to a file in the PNM rasterfile
 %  format. % - %  The format of the WritePNMImage method is:  % K %      unsigned int WritePNMImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % H %    o status: Method WritePNMImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K Export unsigned int WritePNMImage(const ImageInfo *image_info,Image *image)  {  #define MaxRawValue  255     char     buffer[MaxTextExtent],     *magick;     int      y;     register int     i,     j,     x;     register PixelPacket     *p;      unsigned char      format;      unsigned int
     scene,     status;      unsigned short
     index;     /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);
   scene=0;   do   {      /*/       Promote/Demote image based on image type.      */+     TransformRGBImage(image,RGBColorspace);       (void) IsPseudoClass(image);5     if (Latin1Compare(image_info->magick,"PPM") == 0)        image->class=DirectClass; '     magick=(char *) image_info->magick; F     if (((Latin1Compare(magick,"PGM") == 0) && !IsGrayImage(image)) ||J         ((Latin1Compare(magick,"PBM") == 0) && !IsMonochromeImage(image)))       {          QuantizeInfo           quantize_info;  (         GetQuantizeInfo(&quantize_info);-         quantize_info.number_colors=MaxRGB+1; 9         if (Latin1Compare(image_info->magick,"PBM") == 0) (           quantize_info.number_colors=2;0         quantize_info.dither=image_info->dither;0         quantize_info.colorspace=GRAYColorspace;3         (void) QuantizeImage(&quantize_info,image);        }      /*       Write PNM file header.     */5     if (!IsPseudoClass(image) && !IsGrayImage(image))        { 
         /*           Full color PNM image. 
         */         format='6'; 9         if ((image_info->compression == NoCompression) || #             (MaxRGB > MaxRawValue))            format='3';        }      else       { 
         /*            Colormapped PNM image.
         */         format='6'; 9         if ((image_info->compression == NoCompression) || #             (MaxRGB > MaxRawValue))            format='3'; E         if ((Latin1Compare(magick,"PPM") != 0) && IsGrayImage(image))            {              /*"               Grayscale PNM image.             */             format='5'; =             if ((image_info->compression == NoCompression) || '                 (MaxRGB > MaxRawValue))                format='2'; 1             if (Latin1Compare(magick,"PGM") != 0) %               if (image->colors == 2)                  {                    format='4'; ?                   if (image_info->compression == NoCompression)                      format='1';                  }            }        } (     if (Latin1Compare(magick,"P7") == 0)       {          format='7'; )         (void) strcpy(buffer,"P7 332\n");        }      else,       (void) sprintf(buffer,"P%c\n",format);2     (void) WriteBlob(image,strlen(buffer),buffer);)     if (image->comments != (char *) NULL)        {          register char 
           *p;   
         /*!           Write comments to file. 
         */$         (void) WriteByte(image,'#');0         for (p=image->comments; *p != '\0'; p++)	         { %           (void) WriteByte(image,*p); /           if ((*p == '\n') && (*(p+1) != '\0')) (             (void) WriteByte(image,'#');	         } %         (void) WriteByte(image,'\n');        }      if (format != '7')       { D         (void) sprintf(buffer,"%u %u\n",image->columns,image->rows);6         (void) WriteBlob(image,strlen(buffer),buffer);       }      /*5       Convert runlength encoded to PNM raster pixels.      */     switch (format)      {        case '1':        {          register unsigned char           polarity;   
         /*'           Convert image to a PBM image. 
         */?         polarity=Intensity(image->colormap[0]) > (MaxRGB >> 1);          if (image->colors == 2)            polarity= J             Intensity(image->colormap[0]) > Intensity(image->colormap[1]);         i=0;-         for (y=0; y < (int) image->rows; y++) 	         { 9           if (!GetPixelCache(image,0,y,image->columns,1))              break;2           for (x=0; x < (int) image->columns; x++)           { O             (void) sprintf(buffer,"%d ",(int) (image->indexes[x] == polarity)); :             (void) WriteBlob(image,strlen(buffer),buffer);             i++;             if (i == 36)               { -                 (void) WriteByte(image,'\n');                  i=0;               }            } 0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(SaveImageText,y,image->rows); 	         }          break;       }        case '2':        { 
         /*'           Convert image to a PGM image. 
         */.         (void) sprintf(buffer,"%ld\n",MaxRGB);6         (void) WriteBlob(image,strlen(buffer),buffer);         i=0;-         for (y=0; y < (int) image->rows; y++) 	         { 6           p=GetPixelCache(image,0,y,image->columns,1);(           if (p == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           {               index=Intensity(*p);/             (void) sprintf(buffer,"%d ",index); :             (void) WriteBlob(image,strlen(buffer),buffer);             i++;             if (i == 12)               { -                 (void) WriteByte(image,'\n');                  i=0;               }              p++;           } 0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(SaveImageText,y,image->rows); 	         }          break;       }        case '3':        { 
         /*'           Convert image to a PNM image. 
         */.         (void) sprintf(buffer,"%ld\n",MaxRGB);6         (void) WriteBlob(image,strlen(buffer),buffer);         i=0;-         for (y=0; y < (int) image->rows; y++) 	         { 6           p=GetPixelCache(image,0,y,image->columns,1);(           if (p == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           { G             (void) sprintf(buffer,"%d %d %d ",p->red,p->green,p->blue); :             (void) WriteBlob(image,strlen(buffer),buffer);             i++;             if (i == 4)                { -                 (void) WriteByte(image,'\n');                  i=0;               }              p++;           } 0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(SaveImageText,y,image->rows); 	         }          break;       }        case '4':        {          register unsigned char           bit,           byte,            polarity;   
         /*'           Convert image to a PBM image. 
         */?         polarity=Intensity(image->colormap[0]) > (MaxRGB >> 1);          if (image->colors == 2)            polarity= J             Intensity(image->colormap[0]) > Intensity(image->colormap[1]);-         for (y=0; y < (int) image->rows; y++) 	         { 9           if (!GetPixelCache(image,0,y,image->columns,1))              break;           bit=0;           byte=0; 2           for (x=0; x < (int) image->columns; x++)           {              byte<<=1; .             if (image->indexes[x] == polarity)               byte|=0x01;              bit++;             if (bit == 8)                { -                 (void) WriteByte(image,byte);                  bit=0;                 byte=0;                }              p++;           }            if (bit != 0) 4             (void) WriteByte(image,byte << (8-bit));0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(SaveImageText,y,image->rows); 	         }          break;       }        case '5':        { 
         /*'           Convert image to a PGM image. 
         */9         (void) sprintf(buffer,"%lu\n",DownScale(MaxRGB)); 6         (void) WriteBlob(image,strlen(buffer),buffer);-         for (y=0; y < (int) image->rows; y++) 	         { 6           p=GetPixelCache(image,0,y,image->columns,1);(           if (p == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           { +             index=DownScale(Intensity(*p)); *             (void) WriteByte(image,index);             p++;           } 0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(SaveImageText,y,image->rows); 	         }          break;       }        case '6':        {          register unsigned char
           *q;            unsigned char            *pixels;  
         /*%           Allocate memory for pixels. 
         */          pixels=(unsigned char *)=           AllocateMemory(image->columns*sizeof(PixelPacket)); -         if (pixels == (unsigned char *) NULL) L           WriterExit(ResourceLimitWarning,"Memory allocation failed",image);
         /*'           Convert image to a PNM image. 
         */9         (void) sprintf(buffer,"%lu\n",DownScale(MaxRGB)); 6         (void) WriteBlob(image,strlen(buffer),buffer);-         for (y=0; y < (int) image->rows; y++) 	         { 6           p=GetPixelCache(image,0,y,image->columns,1);(           if (p == (PixelPacket *) NULL)             break;           q=pixels; 2           for (x=0; x < (int) image->columns; x++)           { #             *q++=DownScale(p->red); %             *q++=DownScale(p->green); $             *q++=DownScale(p->blue);             p++;           } ;           (void) WriteBlob(image,q-pixels,(char *) pixels); 0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(SaveImageText,y,image->rows); 	         }          FreeMemory(pixels);          break;       }        case '7':        {          static const short int           dither_red[2][16]=           { N             {-16,  4, -1, 11,-14,  6, -3,  9,-15,  5, -2, 10,-13,  7, -4,  8},M             { 15, -5,  0,-12, 13, -7,  2,-10, 14, -6,  1,-11, 12, -8,  3, -9}            },           dither_green[2][16]=           { N             { 11,-15,  7, -3,  8,-14,  4, -2, 10,-16,  6, -4,  9,-13,  5, -1},M             {-12, 14, -8,  2, -9, 13, -5,  1,-11, 15, -7,  3,-10, 12, -6,  0}            },           dither_blue[2][16]=            { N             { -3,  9,-13,  7, -1, 11,-15,  5, -4,  8,-14,  6, -2, 10,-16,  4},M             {  2,-10, 12, -8,  0,-12, 14, -6,  3, -9, 13, -7,  1,-11, 15, -5}            };           int            value;           Quantum            pixel;           unsigned short           *blue_map[2][16],            *green_map[2][16],           *red_map[2][16];  
         /*.           Allocate and initialize dither maps.
         */         for (i=0; i < 2; i++)             for (j=0; j < 16; j++)           { ,             red_map[i][j]=(unsigned short *)9               AllocateMemory(256*sizeof(unsigned short)); .             green_map[i][j]=(unsigned short *)9               AllocateMemory(256*sizeof(unsigned short)); -             blue_map[i][j]=(unsigned short *) 9               AllocateMemory(256*sizeof(unsigned short)); =             if ((red_map[i][j] == (unsigned short *) NULL) || ?                 (green_map[i][j] == (unsigned short *) NULL) || <                 (blue_map[i][j] == (unsigned short *) NULL))P               WriterExit(ResourceLimitWarning,"Memory allocation failed",image);           } 
         /*#           Initialize dither tables. 
         */         for (i=0; i < 2; i++)             for (j=0; j < 16; j++)#             for (x=0; x < 256; x++) 
             {                value=x-16;                if (x < 48)                  value=x/2+8;&               value+=dither_red[i][j];O               red_map[i][j][x]=((value < 0) ? 0 : (value > 255) ? 255 : value);                value=x-16;                if (x < 48)                  value=x/2+8;(               value+=dither_green[i][j];!               green_map[i][j][x]= @                 ((value < 0) ? 0 : (value > 255) ? 255 : value);               value=x-32;                if (x < 112)                 value=x/2+24; )               value+=2*dither_blue[i][j]; P               blue_map[i][j][x]=((value < 0) ? 0 : (value > 255) ? 255 : value);
             } 
         /*&           Convert image to a P7 image.
         */3         (void) strcpy(buffer,"#END_OF_COMMENTS\n"); 6         (void) WriteBlob(image,strlen(buffer),buffer);H         (void) sprintf(buffer,"%u %u 255\n",image->columns,image->rows);6         (void) WriteBlob(image,strlen(buffer),buffer);         i=0;         j=0;-         for (y=0; y < (int) image->rows; y++) 	         { 6           p=GetPixelCache(image,0,y,image->columns,1);(           if (p == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           { $             if (!image_info->dither)1               pixel=((DownScale(p->red) & 0xe0) | 5                 ((DownScale(p->green) & 0xe0) >> 3) | 4                 ((DownScale(p->blue) & 0xc0) >> 6));             else@               pixel=((red_map[i][j][DownScale(p->red)] & 0xe0) |F                 ((green_map[i][j][DownScale(p->green)] & 0xe0) >> 3) |D                 ((blue_map[i][j][DownScale(p->blue)] & 0xc0) >> 6));*             (void) WriteByte(image,pixel);             p++;             j++;             if (j == 16)               j=0;           }            i++;           if (i == 2)              i=0;)           if (QuantumTick(y,image->rows)) 9             ProgressMonitor(SaveImageText,y,image->rows); 	         } 
         /*            Free allocated memory.
         */         for (i=0; i < 2; i++)             for (j=0; j < 16; j++)           { (             FreeMemory(green_map[i][j]);'             FreeMemory(blue_map[i][j]); &             FreeMemory(red_map[i][j]);           }          break;       }      } &     if (image->next == (Image *) NULL)       break;     image=GetNextImage(image);C     ProgressMonitor(SaveImagesText,scene++,GetNumberScenes(image));    } while (image_info->adjoin);    if (image_info->adjoin) -     while (image->previous != (Image *) NULL)        image=image->previous;   CloseBlob(image);    return(True);  } 