 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            PPPP   SSSSS  22222                              % O %                            P   P  SS        22                              % O %                            PPPP    SSS    222                               % O %                            P         SS  22                                 % O %                            P      SSSSS  22222                              % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h" #if defined(HasTIFF) #define CCITTParam  "-1" #else  #define CCITTParam  "0"  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P S 2 I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method WritePS2Image translates an image to encapsulated PostscriptI %  Level II for printing.  If the supplied geometry is null, the image is J %  centered on the Postscript page.  Otherwise, the image is positioned as %  specified by the geometry.  % - %  The format of the WritePS2Image method is:  % K %      unsigned int WritePS2Image(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows:  % H %    o status: Method WritePS2Image return True if the image is printed.I %      False is returned if the image file cannot be opened for printing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */K Export unsigned int WritePS2Image(const ImageInfo *image_info,Image *image)  {    static const char      *PostscriptProlog[]=     {        "%%%%BeginProlog",       "%%", F       "%% Display a color image.  The image is displayed in color on",H       "%% Postscript viewers or printers that support color, otherwise",)       "%% it is displayed as grayscale.",        "%%",        "/buffer 512 string def", <       "/pixel_stream currentfile /ASCII85Decode filter def",	       "",        "/DirectClassImage",
       "{",
       "  %%", *       "  %% Display a DirectClass image.",
       "  %%",        "  colorspace 0 eq",       "  {",%       "    /DeviceRGB setcolorspace",        "    <<",        "      /ImageType 1",        "      /Width columns",        "      /Height rows", "       "      /BitsPerComponent 8",$       "      /Decode [0 1 0 1 0 1]",9       "      /ImageMatrix [columns 0 0 rows neg 0 rows]",        "      compression 0 gt", +       "      { /DataSource pixel_stream }", B       "      { /DataSource pixel_stream /%.1024s filter } ifelse",       "    >> image",        "  }",       "  {",&       "    /DeviceCMYK setcolorspace",       "    <<",        "      /ImageType 1",        "      /Width columns",        "      /Height rows", "       "      /BitsPerComponent 8",(       "      /Decode [0 1 0 1 0 1 0 1]",9       "      /ImageMatrix [columns 0 0 rows neg 0 rows]",        "      compression 0 gt", +       "      { /DataSource pixel_stream }", B       "      { /DataSource pixel_stream /%.1024s filter } ifelse",       "    >> image",        "  } ifelse",        "} bind def", 	       "",        "/PseudoClassImage",
       "{",
       "  %%", *       "  %% Display a PseudoClass image.",
       "  %%",        "  %% Parameters:", 9       "  %%   colors: number of colors in the colormap.", 
       "  %%", *       "  currentfile buffer readline pop",)       "  token pop /colors exch def pop",        "  colors 0 eq",       "  {",       "    %%", #       "    %% Image is grayscale.",        "    %%", &       "    /DeviceGray setcolorspace",       "    <<",        "      /ImageType 1",        "      /Width columns",        "      /Height rows", "       "      /BitsPerComponent 1",       "      /Decode [0 1]",9       "      /ImageMatrix [columns 0 0 rows neg 0 rows]",        "      compression 0 gt", +       "      { /DataSource pixel_stream }",        "      {",)       "        /DataSource pixel_stream",        "        <<", !       "           /K "CCITTParam, $       "           /Columns columns",       "           /Rows rows",*       "        >> /CCITTFaxDecode filter",       "      } ifelse",        "    >> image",        "  }",       "  {",       "    %%",        "    %% Parameters:", ;       "    %%   colormap: red, green, blue color packets.",        "    %%", .       "    /colormap colors 3 mul string def",7       "    currentfile colormap readhexstring pop pop", H       "    [ /Indexed /DeviceRGB colors 1 sub colormap ] setcolorspace",       "    <<",        "      /ImageType 1",        "      /Width columns",        "      /Height rows", "       "      /BitsPerComponent 8",       "      /Decode [0 255]",9       "      /ImageMatrix [columns 0 0 rows neg 0 rows]",        "      compression 0 gt", +       "      { /DataSource pixel_stream }", B       "      { /DataSource pixel_stream /%.1024s filter } ifelse",       "    >> image",        "  } ifelse",        "} bind def", 	       "",        "/DisplayImage",
       "{",
       "  %%", 9       "  %% Display a DirectClass or PseudoClass image.", 
       "  %%",        "  %% Parameters:", "       "  %%   x & y translation.",       "  %%   x & y scale.",        "  %%   label pointsize.",       "  %%   image label.",%       "  %%   image columns & rows.", 6       "  %%   class: 0-DirectClass or 1-PseudoClass.",,       "  %%   colorspace: 0-RGB or 1-CMYK.",N       "  %%   compression: 0-RunlengthEncodedCompression or 1-NoCompression.","       "  %%   hex color packets.",
       "  %%",        "  gsave",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",       "  x y translate",*       "  currentfile buffer readline pop",        "  token pop /x exch def",$       "  token pop /y exch def pop",*       "  currentfile buffer readline pop",,       "  token pop /pointsize exch def pop",:       "  /Helvetica findfont pointsize scalefont setfont",       (char *) NULL      },     *PostscriptEpilog[]=     {        "  x y scale",*       "  currentfile buffer readline pop",&       "  token pop /columns exch def",'       "  token pop /rows exch def pop", *       "  currentfile buffer readline pop",(       "  token pop /class exch def pop",*       "  currentfile buffer readline pop",-       "  token pop /colorspace exch def pop", *       "  currentfile buffer readline pop",.       "  token pop /compression exch def pop",F       "  class 0 gt { PseudoClassImage } { DirectClassImage } ifelse",       "  grestore",        (char *) NULL      };     char     buffer[MaxTextExtent],     date[MaxTextExtent],     density[MaxTextExtent],      geometry[MaxTextExtent],
     **labels;      const char     **q;     CompressionType      compression;     double     dx_resolution,     dy_resolution,     x_resolution,      x_scale,     y_resolution,      y_scale;     int 
     count,     status,      x,     y;     register PixelPacket     *p;      register int     i;  
   SegmentInfo      bounding_box;      time_t
     timer;     unsigned char      *pixels;     unsigned int     height, 	     page, 
     scene,     text_size,
     width;     unsigned long      number_packets;      /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);!   compression=image->compression; 6   if (image_info->compression != UndefinedCompression)(     compression=image_info->compression;	   page=1; 
   scene=0;   do   {      /*-       Scale image to size of Postscript page.      */     text_size=0;&     if (image->label != (char *) NULL)G       text_size=MultilineCensus(image->label)*image_info->pointsize+12;      width=image->columns;      height=image->rows;      x=0;     y=text_size;>     FormatString(geometry,"%ux%u",image->columns,image->rows);*     if (image_info->page != (char *) NULL)/       (void) strcpy(geometry,image_info->page);      elseJ       if ((image->page_info.width != 0) && (image->page_info.height != 0))J         (void) FormatString(geometry,"%ux%u%+d%+d",image->page_info.width,B 	  image->page_info.height,image->page_info.x,image->page_info.y);
       else9         if (Latin1Compare(image_info->magick,"PS2") == 0) 1           (void) strcpy(geometry,PSPageGeometry); =     (void) ParseImageGeometry(geometry,&x,&y,&width,&height);      /*&       Scale relative to dots-per-inch.     */     dx_resolution=72.0;      dy_resolution=72.0;      x_resolution=72.0;-     (void) strcpy(density,PSDensityGeometry); @     count=sscanf(density,"%lfx%lf",&x_resolution,&y_resolution);     if (count != 2)         y_resolution=x_resolution;-     if (image_info->density != (char *) NULL)        { P         count=sscanf(image_info->density,"%lfx%lf",&x_resolution,&y_resolution);         if (count != 2) $           y_resolution=x_resolution;       } /     x_scale=(width*dx_resolution)/x_resolution; '     width=(unsigned int) (x_scale+0.5); 0     y_scale=(height*dy_resolution)/y_resolution;(     height=(unsigned int) (y_scale+0.5);     if (page == 1)       { 
         /*#           Output Postscript header. 
         */9         if (Latin1Compare(image_info->magick,"PS2") == 0) 3           (void) strcpy(buffer,"%!PS-Adobe-3.0\n");          else<           (void) strcpy(buffer,"%!PS-Adobe-3.0 EPSF-3.0\n");6         (void) WriteBlob(image,strlen(buffer),buffer);;         (void) strcpy(buffer,"%%Creator: (ImageMagick)\n"); 6         (void) WriteBlob(image,strlen(buffer),buffer);F         (void) sprintf(buffer,"%%Title: (%.1024s)\n",image->filename);6         (void) WriteBlob(image,strlen(buffer),buffer);$         timer=time((time_t *) NULL);!         (void) localtime(&timer); *         (void) strcpy(date,ctime(&timer));"         date[Extent(date)-1]='\0';D         (void) sprintf(buffer,"%%%%CreationDate: (%.1024s)\n",date);6         (void) WriteBlob(image,strlen(buffer),buffer);         bounding_box.x1=x;         bounding_box.y1=y;"         bounding_box.x2=x+width-1;/         bounding_box.y2=y+(height+text_size)-1; B         if (image_info->adjoin && (image->next != (Image *) NULL));           (void) strcpy(buffer,"%%BoundingBox: (atend)\n");          elseA           (void) sprintf(buffer,"%%%%BoundingBox: %g %g %g %g\n", M             bounding_box.x1,bounding_box.y1,bounding_box.x2,bounding_box.y2); 6         (void) WriteBlob(image,strlen(buffer),buffer);*         if (image->label != (char *) NULL)           { !             (void) strcpy(buffer, ?               "%%%%DocumentNeededResources: font Helvetica\n"); :             (void) WriteBlob(image,strlen(buffer),buffer);           } 5         (void) strcpy(buffer,"%%LanguageLevel: 2\n"); 6         (void) WriteBlob(image,strlen(buffer),buffer);9         if (Latin1Compare(image_info->magick,"PS2") != 0)            { 4             (void) sprintf(buffer,"%%%%Pages: 0\n");:             (void) WriteBlob(image,strlen(buffer),buffer);           }          else           { >             (void) strcpy(buffer,"%%Orientation: Portrait\n");:             (void) WriteBlob(image,strlen(buffer),buffer);:             (void) strcpy(buffer,"%%PageOrder: Ascend\n");:             (void) WriteBlob(image,strlen(buffer),buffer);$             if (!image_info->adjoin)3               (void) strcpy(buffer,"%%Pages: 0\n");              elseN               (void) sprintf(buffer,"%%%%Pages: %u\n",GetNumberScenes(image));:             (void) WriteBlob(image,strlen(buffer),buffer);           } 0         (void) strcpy(buffer,"%%EndComments\n");6         (void) WriteBlob(image,strlen(buffer),buffer);4         (void) strcpy(buffer,"\n%%BeginDefaults\n");6         (void) WriteBlob(image,strlen(buffer),buffer);>         (void) strcpy(buffer,"%%PageOrientation: Portrait\n");6         (void) WriteBlob(image,strlen(buffer),buffer);2         (void) strcpy(buffer,"%%EndDefaults\n\n");6         (void) WriteBlob(image,strlen(buffer),buffer);
         /*%           Output Postscript commands. 
         */)         for (q=PostscriptProlog; *q; q++) 	         {            switch (compression)           { H             case JPEGCompression: sprintf(buffer,*q,"DCTDecode"); break;G             case LZWCompression: sprintf(buffer,*q,"LZWDecode"); break; I             case ZipCompression: sprintf(buffer,*q,"FlateDecode"); break; A             default: sprintf(buffer,*q,"RunLengthDecode"); break;            } 8           (void) WriteBlob(image,strlen(buffer),buffer);'           (void) WriteByte(image,'\n'); 	         } <         for (i=MultilineCensus(image->label)-1; i >= 0; i--)	         { <           (void) strcpy(buffer,"  /label 512 string def\n");8           (void) WriteBlob(image,strlen(buffer),buffer);E           (void) strcpy(buffer,"  currentfile label readline pop\n"); 8           (void) WriteBlob(image,strlen(buffer),buffer);G           (void) sprintf(buffer,"  0 y %f add moveto label show pop\n", (             i*image_info->pointsize+12);8           (void) WriteBlob(image,strlen(buffer),buffer);	         } )         for (q=PostscriptEpilog; *q; q++)            { 1             (void) sprintf(buffer,"%.255s\n",*q); :             (void) WriteBlob(image,strlen(buffer),buffer);           } 9         if (Latin1Compare(image_info->magick,"PS2") == 0)            { 1             (void) strcpy(buffer,"  showpage\n"); :             (void) WriteBlob(image,strlen(buffer),buffer);           } -         (void) strcpy(buffer,"} bind def\n"); 6         (void) WriteBlob(image,strlen(buffer),buffer);.         (void) strcpy(buffer,"%%EndProlog\n");6         (void) WriteBlob(image,strlen(buffer),buffer);       } 6     (void) sprintf(buffer,"%%%%Page:  1 %u\n",page++);2     (void) WriteBlob(image,strlen(buffer),buffer);C     (void) sprintf(buffer,"%%%%PageBoundingBox: %d %d %d %d\n",x,y, 4       x+(int) width-1,y+(int) (height+text_size)-1);2     (void) WriteBlob(image,strlen(buffer),buffer);     if (x < bounding_box.x1)       bounding_box.x1=x;     if (y < bounding_box.y1)       bounding_box.y1=y;,     if ((x+(int) width-1) > bounding_box.x2)        bounding_box.x2=x+width-1;9     if ((y+(int) (height+text_size)-1) > bounding_box.y2) -       bounding_box.y2=y+(height+text_size)-1; &     if (image->label != (char *) NULL)       { B         (void) strcpy(buffer,"%%PageResources: font Helvetica\n");6         (void) WriteBlob(image,strlen(buffer),buffer);       } 5     if (Latin1Compare(image_info->magick,"PS2") != 0)        { 1         (void) strcpy(buffer,"userdict begin\n"); 6         (void) WriteBlob(image,strlen(buffer),buffer);       } +     (void) strcpy(buffer,"%%BeginData:\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);+     (void) strcpy(buffer,"DisplayImage\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);     /*       Output image data.     */&     labels=StringToList(image->label);C     (void) sprintf(buffer,"%d %d\n%g %g\n%f\n",x,y,x_scale,y_scale,        image_info->pointsize); 2     (void) WriteBlob(image,strlen(buffer),buffer);!     if (labels != (char **) NULL)        { 2         for (i=0; labels[i] != (char *) NULL; i++)	         { 8           (void) sprintf(buffer,"%.1024s \n",labels[i]);8           (void) WriteBlob(image,strlen(buffer),buffer);            FreeMemory(labels[i]);	         }          FreeMemory(labels);        } K     (void) sprintf(buffer,"%u %u\n%u\n%d\n%d\n",image->columns,image->rows, G       IsPseudoClass(image),(int) (image->colorspace == CMYKColorspace), ,       (int) (compression == NoCompression));2     (void) WriteBlob(image,strlen(buffer),buffer);5     if (!IsPseudoClass(image) && !IsGrayImage(image))        switch (compression)       {          case JPEGCompression: 	         {            char$             filename[MaxTextExtent];             FILE             *file;             Image              *jpeg_image;  
           int              c;             /*9             Write image to temporary file in JPEG format.            */&           TemporaryFilename(filename);G           jpeg_image=CloneImage(image,image->columns,image->rows,True); +           if (jpeg_image == (Image *) NULL) F             WriterExit(DelegateWarning,"Unable to clone image",image);7           (void) strcpy(jpeg_image->filename,filename); 7           status=WriteJPEGImage(image_info,jpeg_image); #           DestroyImage(jpeg_image);            if (status == False)F             WriterExit(DelegateWarning,"Unable to write image",image);.           file=fopen(filename,ReadBinaryType);$           if (file == (FILE *) NULL)D             WriterExit(FileOpenWarning,"Unable to open file",image);           Ascii85Initialize();6           for (c=fgetc(file); c != EOF; c=fgetc(file))#             Ascii85Encode(image,c);            Ascii85Flush(image);           (void) fclose(file);"           (void) remove(filename);           break;	         } )         case RunlengthEncodedCompression:          default:	         {             register unsigned char             *q;              /*!             Allocate pixel array.            */G           number_packets=(image->colorspace == CMYKColorspace ? 4 : 3)* '             image->columns*image->rows; "           pixels=(unsigned char *)A             AllocateMemory(number_packets*sizeof(unsigned char)); /           if (pixels == (unsigned char *) NULL) N             WriterExit(ResourceLimitWarning,"Memory allocation failed",image);           /*(             Dump Packbit encoded pixels.           */           q=pixels; /           for (y=0; y < (int) image->rows; y++)            { 8             p=GetPixelCache(image,0,y,image->columns,1);*             if (p == (PixelPacket *) NULL)               break;4             for (x=0; x < (int) image->columns; x++)
             { >               if (image->matte && (p->opacity == Transparent))                 { )                   *q++=DownScale(MaxRGB); )                   *q++=DownScale(MaxRGB); )                   *q++=DownScale(MaxRGB);                  }                else8                 if (image->colorspace != CMYKColorspace)                   { +                     *q++=DownScale(p->red); -                     *q++=DownScale(p->green); ,                     *q++=DownScale(p->blue);                   }                  else                   { +                     *q++=DownScale(p->red); -                     *q++=DownScale(p->green); ,                     *q++=DownScale(p->blue);/                     *q++=DownScale(p->opacity);                    }                p++;
             } 2             if (image->previous == (Image *) NULL)-               if (QuantumTick(y,image->rows)) =                 ProgressMonitor(SaveImageText,y,image->rows);            } ,           if (compression == ZipCompression)             status= O               ZLIBEncodeImage(image,number_packets,image_info->quality,pixels);            else.             if (compression == LZWCompression)A               status=LZWEncodeImage(image,number_packets,pixels);              elseF               status=PackbitsEncodeImage(image,number_packets,pixels);           if (!status)
             {                CloseBlob(image);                return(False);
             }            FreeMemory(pixels);            break;	         }          case NoCompression: 	         {            /*2             Dump uncompressed DirectColor packets.           */           Ascii85Initialize();/           for (y=0; y < (int) image->rows; y++)            { 8             p=GetPixelCache(image,0,y,image->columns,1);*             if (p == (PixelPacket *) NULL)               break;4             for (x=0; x < (int) image->columns; x++)
             { >               if (image->matte && (p->opacity == Transparent))                 { 9                   Ascii85Encode(image,DownScale(MaxRGB)); 9                   Ascii85Encode(image,DownScale(MaxRGB)); 9                   Ascii85Encode(image,DownScale(MaxRGB));                  }                else8                 if (image->colorspace != CMYKColorspace)                   { ;                     Ascii85Encode(image,DownScale(p->red)); =                     Ascii85Encode(image,DownScale(p->green)); <                     Ascii85Encode(image,DownScale(p->blue));                   }                  else                   { ;                     Ascii85Encode(image,DownScale(p->red)); =                     Ascii85Encode(image,DownScale(p->green)); <                     Ascii85Encode(image,DownScale(p->blue));?                     Ascii85Encode(image,DownScale(p->opacity));                    }                p++;
             } 2             if (image->previous == (Image *) NULL)-               if (QuantumTick(y,image->rows)) =                 ProgressMonitor(SaveImageText,y,image->rows);            }            Ascii85Flush(image);           break;	         }        }      else?       if (IsFaxImage(image) && (compression != LZWCompression)) 	         {             register unsigned char             bit,             byte,              polarity;   A           polarity=Intensity(image->colormap[0]) > (MaxRGB >> 1); !           if (image->colors == 2)              polarity= L               Intensity(image->colormap[0]) < Intensity(image->colormap[1]);'           (void) WriteByte(image,'\0'); '           (void) WriteByte(image,'\n');            switch (compression)           { -             case RunlengthEncodedCompression:              default:
             { 5               if (Latin1Compare(CCITTParam,"0") == 0) J                 (void) HuffmanEncodeImage((ImageInfo *) image_info,image);               elseL                 (void) Huffman2DEncodeImage((ImageInfo *) image_info,image);               break;
             }              case NoCompression: 
             {                /*6                 Dump uncompressed PseudoColor packets.               */"               Ascii85Initialize();3               for (y=0; y < (int) image->rows; y++)                { ?                 if (!GetPixelCache(image,0,y,image->columns,1))                    break;                 bit=0;                 byte=0; 8                 for (x=0; x < (int) image->columns; x++)                 {                    byte<<=1; 4                   if (image->indexes[x] == polarity)                     byte|=0x01;                    bit++;                   if (bit == 8)                      { 0                       Ascii85Encode(image,byte);                       bit=0;                       byte=0;                      }                    p++;                 }                  if (bit != 0) 7                   Ascii85Encode(image,byte << (8-bit)); 6                 if (image->previous == (Image *) NULL)1                   if (QuantumTick(y,image->rows)) A                     ProgressMonitor(SaveImageText,y,image->rows);                } "               Ascii85Flush(image);               break;
             }            } 	         } 
       else	         {            /*/             Dump number of colors and colormap.            */6           (void) sprintf(buffer,"%u\n",image->colors);8           (void) WriteBlob(image,strlen(buffer),buffer);1           for (i=0; i < (int) image->colors; i++)            { 6             (void) sprintf(buffer,"%02lx%02lx%02lx\n",0               DownScale(image->colormap[i].red),2               DownScale(image->colormap[i].green),2               DownScale(image->colormap[i].blue));:             (void) WriteBlob(image,strlen(buffer),buffer);           }            switch (compression)           { -             case RunlengthEncodedCompression:              default:
             { $               register unsigned char                 *q;                  /*%                 Allocate pixel array.                */8               number_packets=image->columns*image->rows;&               pixels=(unsigned char *)E                 AllocateMemory(number_packets*sizeof(unsigned char)); 3               if (pixels == (unsigned char *) NULL) K                 WriterExit(ResourceLimitWarning,"Memory allocation failed",                    image);                /*.                 Dump Runlength encoded pixels.               */               q=pixels; 3               for (y=0; y < (int) image->rows; y++)                { ?                 if (!GetPixelCache(image,0,y,image->columns,1))                    break;8                 for (x=0; x < (int) image->columns; x++)                 { )                   *q++=image->indexes[x];                    p++;                 } 6                 if (image->previous == (Image *) NULL)1                   if (QuantumTick(y,image->rows)) A                     ProgressMonitor(SaveImageText,y,image->rows);                } 0               if (compression == ZipCompression)P                 status=ZLIBEncodeImage(image,number_packets,image_info->quality,                   pixels);               else2                 if (compression == LZWCompression)E                   status=LZWEncodeImage(image,number_packets,pixels);                  elseJ                   status=PackbitsEncodeImage(image,number_packets,pixels);!               FreeMemory(pixels);                if (!status)                 { #                   CloseBlob(image);                     return(False);                 }                break;
             }              case NoCompression: 
             {                /*6                 Dump uncompressed PseudoColor packets.               */"               Ascii85Initialize();3               for (y=0; y < (int) image->rows; y++)                { ?                 if (!GetPixelCache(image,0,y,image->columns,1))                    break;8                 for (x=0; x < (int) image->columns; x++)9                   Ascii85Encode(image,image->indexes[x]); 6                 if (image->previous == (Image *) NULL)1                   if (QuantumTick(y,image->rows)) A                     ProgressMonitor(SaveImageText,y,image->rows);                } "               Ascii85Flush(image);               break;
             }            } 	         } !     (void) WriteByte(image,'\n'); (     (void) strcpy(buffer,"%%EndData\n");2     (void) WriteBlob(image,strlen(buffer),buffer);5     if (Latin1Compare(image_info->magick,"PS2") != 0)        { &         (void) strcpy(buffer,"end\n");6         (void) WriteBlob(image,strlen(buffer),buffer);       } ,     (void) strcpy(buffer,"%%PageTrailer\n");2     (void) WriteBlob(image,strlen(buffer),buffer);&     if (image->next == (Image *) NULL)       break;     image=GetNextImage(image);C     ProgressMonitor(SaveImagesText,scene++,GetNumberScenes(image));    } while (image_info->adjoin);    if (image_info->adjoin) -     while (image->previous != (Image *) NULL)        image=image->previous;&   (void) strcpy(buffer,"%%Trailer\n");0   (void) WriteBlob(image,strlen(buffer),buffer);   if (page > 1)      { =       (void) sprintf(buffer,"%%%%BoundingBox: %g %g %g %g\n", I         bounding_box.x1,bounding_box.y1,bounding_box.x2,bounding_box.y2); 4       (void) WriteBlob(image,strlen(buffer),buffer);     } "   (void) strcpy(buffer,"%%EOF\n");0   (void) WriteBlob(image,strlen(buffer),buffer);   CloseBlob(image);    return(True);  } 