 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            PPPP   SSSSS  DDDD                               % O %                            P   P  SS     D   D                              % O %                            PPPP    SSS   D   D                              % O %                            P         SS  D   D                              % O %                            P      SSSSS  DDDD                               % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e c o d e I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Method DecodeImage uncompresses an image via Macintosh encoding specific to$ %  the Adobe Photoshop image format. % + %  The format of the DecodeImage method is:  % ? %      unsigned int DecodeImage(Image *image,const int channel)  % + %  A description of each parameter follows:  % = %    o status: Method DecodeImage return True if the image is ? %      decoded.  False is returned if there is an error occurs.  % = %    o image,image: The address of a structure of type Image.  % G %    o channel:  Specifies which channel: red, green, blue, or index to $ %      decode the pixel values into. %  %  */? static unsigned int DecodeImage(Image *image,const int channel)  {    int 
     count,
     pixel;     long     length;      register int     i,     x;     register PixelPacket     *q;      x=0;$   length=image->columns*image->rows;   while (length > 0)   {      count=ReadByte(image);     if (count >= 128)        count-=256;      if (count < 0)       {          if (count == -128)           continue;          pixel=ReadByte(image);2         for (count=(-count+1); count > 0; count--)	         { I           q=SetPixelCache(image,x % image->columns,x/image->columns,1,1); (           if (q == (PixelPacket *) NULL)             break;           switch (channel)           {              case 0: 
             {                q->red=pixel; .               if (image->class == PseudoClass)                 { (                   *image->indexes=pixel;,                   *q=image->colormap[pixel];                 }                break;
             }              case 1: 
             {                q->green=pixel;                break;
             }              case 2: 
             {                q->blue=pixel;               break;
             }              case 3:              default:
             {                q->opacity=pixel;                break;
             }            } %           if (!SyncPixelCache(image))              break;           x++;           length--; 	         }          continue;        }      count++;     for (i=count; i > 0; i--)      {        pixel=ReadByte(image);E       q=SetPixelCache(image,x % image->columns,x/image->columns,1,1); $       if (q == (PixelPacket *) NULL)         break;       switch (channel)       {          case 0: 	         { !           q->red=(Quantum) pixel; *           if (image->class == PseudoClass)
             { $               *image->indexes=pixel;(               *q=image->colormap[pixel];
             }            break;	         }          case 1: 	         { #           q->green=(Quantum) pixel;            break;	         }          case 2: 	         { "           q->blue=(Quantum) pixel;           break;	         }          case 3:          default:	         { %           q->opacity=(Quantum) pixel;            break;	         }        } !       if (!SyncPixelCache(image))          break;
       x++;       length--;      }    }    /*2     Guarentee the correct number of pixel packets.   */   if (length > 0)      { J       MagickWarning(CorruptImageWarning,"insufficient image data in file",         image->filename);        return(False);     }    else     if (length < 0)        { H         MagickWarning(CorruptImageWarning,"too much image data in file",           image->filename);          return(False);       }    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s P S D                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method IsPSD returns True if the image format type, identified by the %  magick string, is PSD.  % , %  The format of the ReadPSDImage method is: % 6 %      unsigned int IsPSD(const unsigned char *magick,# %        const unsigned int length)  % + %  A description of each parameter follows:  % J %    o status:  Method IsPSD returns True if the image format type is PSD. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */P Export unsigned int IsPSD(const unsigned char *magick,const unsigned int length) {    if (length < 4)      return(False);-   if (strncmp((char *) magick,"8BPS",4) == 0)      return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d P S D I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method ReadPSDImage reads an Adobe Photoshop image file and returns it.N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % , %  The format of the ReadPSDImage method is: % % %      image=ReadPSDImage(image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadPSDImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadPSDImage(const ImageInfo *image_info)  {  #define BitmapMode  0  #define GrayscaleMode  1 #define IndexedMode  2 #define CMYKMode  4      typedef struct _ChannelInfo    { 
     short int        type;        unsigned long        size;    } ChannelInfo;     typedef struct _LayerInfo    {      unsigned int       width,
       height;        int        x,       y;       unsigned short       channels;        ChannelInfo        channel_info[24];        char       blendkey[4];       unsigned char        opacity,       clipping,        flags;  	     Image 
       *image;    } LayerInfo;     typedef struct _PSDHeader    {      char       signature[4];        unsigned short       channels,        version;       unsigned char        reserved[6];       unsigned int       rows,        columns;       unsigned short       depth,       mode;    } PSDHeader;     char     type[4];     Image      *image;      int      j,     y;     LayerInfo      *layer_info;     long     length, 	     size;      PSDHeader      psd_header;      register int     i,     x;     register PixelPacket     *q;      short int      number_layers;     unsigned int     status;      unsigned short     compression;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*     Read image header.   */9   status=ReadBlob(image,4,(char *) psd_header.signature); .   psd_header.version=MSBFirstReadShort(image);K   if ((status == False) || (strncmp(psd_header.signature,"8BPS",4) != 0) ||         (psd_header.version != 1))A     ReaderExit(CorruptImageWarning,"Not a PSD image file",image); 8   (void) ReadBlob(image,6,(char *) psd_header.reserved);/   psd_header.channels=MSBFirstReadShort(image); *   psd_header.rows=MSBFirstReadLong(image);-   psd_header.columns=MSBFirstReadLong(image); ,   psd_header.depth=MSBFirstReadShort(image);+   psd_header.mode=MSBFirstReadShort(image);    /*     Initialize image.    */"   if (psd_header.mode == CMYKMode)%     image->colorspace=CMYKColorspace;    else*     image->matte=psd_header.channels >= 4;$   image->columns=psd_header.columns;   image->rows=psd_header.rows;2   image->depth=Max(psd_header.depth,QuantumDepth);!   length=MSBFirstReadLong(image); (   if ((psd_header.mode == BitmapMode) ||+       (psd_header.mode == GrayscaleMode) || 7       (psd_header.mode == IndexedMode) || (length > 0))      {        /*         Create colormap.       */       image->class=PseudoClass;        image->colors=256;%       image->colormap=(PixelPacket *) :         AllocateMemory(image->colors*sizeof(PixelPacket));2       if (image->colormap == (PixelPacket *) NULL)J         ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);-       for (i=0; i < (int) image->colors; i++)        { <         image->colormap[i].red=(MaxRGB*i)/(image->colors-1);>         image->colormap[i].green=(MaxRGB*i)/(image->colors-1);=         image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);        }        if (length > 0) 	         {            /*%             Read PSD raster colormap.            */1           for (i=0; i < (int) image->colors; i++) <             image->colormap[i].red=UpScale(ReadByte(image));1           for (i=0; i < (int) image->colors; i++) >             image->colormap[i].green=UpScale(ReadByte(image));1           for (i=0; i < (int) image->colors; i++) =             image->colormap[i].blue=UpScale(ReadByte(image)); 	         }      } !   length=MSBFirstReadLong(image);    if (length > 0)      {        unsigned char          *data;         data=(unsigned char *)5         AllocateMemory(length*sizeof(unsigned char)); )       if (data == (unsigned char *) NULL) (         ReaderExit(ResourceLimitWarning,:           "8BIM resource memory allocation failed",image);2       status=ReadBlob(image,length,(char *) data);F       if ((status == False) || (strncmp((char *) data,"8BIM",4) != 0))E         ReaderExit(CorruptImageWarning,"Not a PSD image file",image); $       image->iptc_profile.info=data;(       image->iptc_profile.length=length;     }    if (image_info->ping)      {        CloseBlob(image);        return(image);     }     layer_info=(LayerInfo *) NULL;   number_layers=0;!   length=MSBFirstReadLong(image);    if (length > 0)      {        /*"         Read layer and mask block.       */#       size=MSBFirstReadLong(image); -       number_layers=MSBFirstReadShort(image); 1       number_layers=AbsoluteValue(number_layers); O       layer_info=(LayerInfo *) AllocateMemory(number_layers*sizeof(LayerInfo)); +       if (layer_info == (LayerInfo *) NULL) J         ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);'       for (i=0; i < number_layers; i++)        { 0         layer_info[i].y=MSBFirstReadLong(image);0         layer_info[i].x=MSBFirstReadLong(image);E         layer_info[i].height=MSBFirstReadLong(image)-layer_info[i].y; D         layer_info[i].width=MSBFirstReadLong(image)-layer_info[i].x;8         layer_info[i].channels=MSBFirstReadShort(image);(         if (layer_info[i].channels > 24)G           ReaderExit(CorruptImageWarning,"Not a PSD image file",image); 8         for (j=0; j < (int) layer_info[i].channels; j++)	         { F           layer_info[i].channel_info[j].type=MSBFirstReadShort(image);E           layer_info[i].channel_info[j].size=MSBFirstReadLong(image); 	         } /         status=ReadBlob(image,4,(char *) type); ?         if ((status == False) || (strncmp(type,"8BIM",4) != 0)) G           ReaderExit(CorruptImageWarning,"Not a PSD image file",image); A         (void) ReadBlob(image,4,(char *) layer_info[i].blendkey); .         layer_info[i].opacity=ReadByte(image);/         layer_info[i].clipping=ReadByte(image); ,         layer_info[i].flags=ReadByte(image);-         (void) ReadByte(image);  /* filler */ %         size=MSBFirstReadLong(image);           for (j=0; j < size; j++)!           (void) ReadByte(image); 
         /*!           Allocate layered image. 
         */         layer_info[i].image=J           CloneImage(image,layer_info[i].width,layer_info[i].height,True);2         if (layer_info[i].image == (Image *) NULL)           { !             for (j=0; j < i; j++) 0               DestroyImage(layer_info[j].image);N             ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);           } (         if (psd_header.mode == CMYKMode)9           layer_info[i].image->colorspace=CMYKColorspace;          elseA           layer_info[i].image->matte=layer_info[i].channels >= 4;        }        /*'         Read pixel data for each layer.        */'       for (i=0; i < number_layers; i++)        { .         layer_info[i].image->file=image->file;8         layer_info[i].image->blob_info=image->blob_info;8         for (j=0; j < (int) layer_info[i].channels; j++)	         { =           compression=MSBFirstReadShort(layer_info[i].image);            if (compression != 0) 
             { A               for (y=0; y < (int) layer_info[i].image->rows; y++) >                 (void) MSBFirstReadShort(layer_info[i].image);5               (void) DecodeImage(layer_info[i].image, 4                 layer_info[i].channel_info[j].type);
             }            else
             {                /*@                 Read uncompressed pixel data as separate planes.               */A               for (y=0; y < (int) layer_info[i].image->rows; y++)                { 8                 q=SetPixelCache(layer_info[i].image,0,y,2                   layer_info[i].image->columns,1);.                 if (q == (PixelPacket *) NULL)                   break;;                 switch (layer_info[i].channel_info[j].type)                  {                    case 0:                    { B                     if (layer_info[i].image->class == PseudoClass)F                       ReadPixelCache(layer_info[i].image,IndexQuantum,0                         (unsigned char *) NULL);                     elseD                       ReadPixelCache(layer_info[i].image,RedQuantum,0                         (unsigned char *) NULL);                     break;                   }                    case 1:                    { D                     ReadPixelCache(layer_info[i].image,GreenQuantum,.                       (unsigned char *) NULL);                     break;                   }                    case 2:                    { C                     ReadPixelCache(layer_info[i].image,BlueQuantum, .                       (unsigned char *) NULL);                     break;                   }                    case 3:                    default:                   { F                     ReadPixelCache(layer_info[i].image,OpacityQuantum,.                       (unsigned char *) NULL);                     break;                   }                  } 9                 if (!SyncPixelCache(layer_info[i].image))                    break;               } 
             } 	         } .         image->file=layer_info[i].image->file;8         image->blob_info=layer_info[i].image->blob_info;>         if (layer_info[i].image->colorspace == CMYKColorspace)           {              /*"               Correct CMYK levels.             */?             for (y=0; y < (int) layer_info[i].image->rows; y++) 
             { 6               q=SetPixelCache(layer_info[i].image,0,y,0                 layer_info[i].image->columns,1);,               if (q == (PixelPacket *) NULL)                 break;D               for (x=0; x < (int) layer_info[i].image->columns; x++)               { %                 q->red=MaxRGB-q->red; )                 q->green=MaxRGB-q->green; '                 q->blue=MaxRGB-q->blue; -                 q->opacity=MaxRGB-q->opacity;                  q++;               } 7               if (!SyncPixelCache(layer_info[i].image))                  break;
             }            }          else.           if (layer_info[i].opacity != Opaque)
             {                /**                 Correct for opacity level.               */A               for (y=0; y < (int) layer_info[i].image->rows; y++)                { 8                 q=GetPixelCache(layer_info[i].image,0,y,2                   layer_info[i].image->columns,1);.                 if (q == (PixelPacket *) NULL)                   break;F                 for (x=0; x < (int) layer_info[i].image->columns; x++)                 { M                   q->opacity=(int) (q->opacity*layer_info[i].opacity)/Opaque;                    q++;                 } 9                 if (!SyncPixelCache(layer_info[i].image))                    break;               } 
             } 0         layer_info[i].image->file=(FILE *) NULL;       }        for (i=0; i < 4; i++)          (void) ReadByte(image);      }    /*(     Convert pixels to Runlength encoded.   */'   compression=MSBFirstReadShort(image);    SetImage(image);   if (compression != 0)      {        /*;         Read Packbit encoded pixel data as separate planes.        */A       for (i=0; i < (int) (image->rows*psd_header.channels); i++) (         (void) MSBFirstReadShort(image);3       for (i=0; i < (int) psd_header.channels; i++) $         (void) DecodeImage(image,i);     }    else     {        /*8         Read uncompressed pixel data as separate planes.       */3       for (i=0; i < (int) psd_header.channels; i++)        { -         for (y=0; y < (int) image->rows; y++) 	         { 6           q=GetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;           switch (i)           {              case 0: 
             { .               if (image->class == PseudoClass)J                 ReadPixelCache(image,IndexQuantum,(unsigned char *) NULL);               elseH                 ReadPixelCache(image,RedQuantum,(unsigned char *) NULL);               break;
             }              case 1: 
             { H               ReadPixelCache(image,GreenQuantum,(unsigned char *) NULL);               break;
             }              case 2: 
             { G               ReadPixelCache(image,BlueQuantum,(unsigned char *) NULL);                break;
             }              case 3:              default:
             { J               ReadPixelCache(image,OpacityQuantum,(unsigned char *) NULL);               break;
             }            } %           if (!SyncPixelCache(image))              break;	         }        }      } *   if (image->colorspace == CMYKColorspace)     {        /*         Correct CMYK levels.       */+       for (y=0; y < (int) image->rows; y++)        { 4         q=GetPixelCache(image,0,y,image->columns,1);&         if (q == (PixelPacket *) NULL)           break;0         for (x=0; x < (int) image->columns; x++)	         {            q->red=MaxRGB-q->red; #           q->green=MaxRGB-q->green; !           q->blue=MaxRGB-q->blue; '           q->opacity=MaxRGB-q->opacity;            q++;	         } #         if (!SyncPixelCache(image))            break;       }      } #   for (i=0; i < number_layers; i++)    {      /*!       Composite layer onto image.      */B     if ((layer_info[i].width != 0) && (layer_info[i].height != 0))O       CompositeImage(image,OverCompositeOp,layer_info[i].image,layer_info[i].x,          layer_info[i].y); &     DestroyImage(layer_info[i].image);   }    image->matte=False; *   if (image->colorspace != CMYKColorspace)*     image->matte=psd_header.channels >= 4;   CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e P S D I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method WritePSDImage writes an image in the Adobe Photoshop encoded image
 %  format. % - %  The format of the WritePSDImage method is:  % K %      unsigned int WritePSDImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % H %    o status: Method WritePSDImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K Export unsigned int WritePSDImage(const ImageInfo *image_info,Image *image)  {    int      y;     register int     i;     unsigned char      *pixels;     unsigned int     packet_size,     status;      /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);   image->depth=QuantumDepth;'   packet_size=image->depth > 8 ? 6 : 3;    if (image->matte) *     packet_size+=image->depth > 8 ? 2 : 1;   pixels=(unsigned char *)C     AllocateMemory(packet_size*image->columns*sizeof(PixelPacket)); '   if (pixels == (unsigned char *) NULL) F     WriterExit(ResourceLimitWarning,"Memory allocation failed",image);#   (void) WriteBlob(image,4,"8BPS"); -   MSBFirstWriteShort(image,1);  /* version */ 5   (void) WriteBlob(image,6,"      ");  /* reserved */ "   if (image->class == PseudoClass)      MSBFirstWriteShort(image,1);   else3     MSBFirstWriteShort(image,image->matte ? 4 : 3); '   MSBFirstWriteLong(image,image->rows); *   MSBFirstWriteLong(image,image->columns);K   MSBFirstWriteShort(image,image->class == PseudoClass ? 8 : image->depth); 9   if (((image_info->colorspace != UndefinedColorspace) || 0        (image->colorspace != CMYKColorspace)) &&2        (image_info->colorspace != CMYKColorspace))     { -       TransformRGBImage(image,RGBColorspace); D       MSBFirstWriteShort(image,image->class == PseudoClass ? 2 : 3);     }    else     { .       if (image->colorspace != CMYKColorspace)0         RGBTransformImage(image,CMYKColorspace);"       MSBFirstWriteShort(image,4);     } =   if ((image->class == DirectClass) || (image->colors > 256))      MSBFirstWriteLong(image,0);    else     {        /*"         Write PSD raster colormap.       */#       MSBFirstWriteLong(image,768); -       for (i=0; i < (int) image->colors; i++) B         (void) WriteByte(image,DownScale(image->colormap[i].red));       for ( ; i < 256; i++) "         (void) WriteByte(image,0);-       for (i=0; i < (int) image->colors; i++) D         (void) WriteByte(image,DownScale(image->colormap[i].green));       for ( ; i < 256; i++) "         (void) WriteByte(image,0);-       for (i=0; i < (int) image->colors; i++) C         (void) WriteByte(image,DownScale(image->colormap[i].blue));        for ( ; i < 256; i++) "         (void) WriteByte(image,0);     } 9   MSBFirstWriteLong(image,0);  /* image resource block */ 9   MSBFirstWriteLong(image,0);  /* layer and mask block */ 1   MSBFirstWriteShort(image,0);  /* compression */    /*5     Write uncompressed pixel data as separate planes.    */"   if (image->class == PseudoClass))     for (y=0; y < (int) image->rows; y++)      { 5       if (!GetPixelCache(image,0,y,image->columns,1))          break;1       WritePixelCache(image,IndexQuantum,pixels); 4       (void) WriteBlob(image,image->columns,pixels);     }    else     { +       packet_size=image->depth > 8 ? 2 : 1; +       for (y=0; y < (int) image->rows; y++)        { 7         if (!GetPixelCache(image,0,y,image->columns,1))            break;0         if (image->colorspace == CMYKColorspace)4           WritePixelCache(image,CyanQuantum,pixels);         else3           WritePixelCache(image,RedQuantum,pixels); B         (void) WriteBlob(image,packet_size*image->columns,pixels);       } +       for (y=0; y < (int) image->rows; y++)        { 7         if (!GetPixelCache(image,0,y,image->columns,1))            break;0         if (image->colorspace == CMYKColorspace)6           WritePixelCache(image,YellowQuantum,pixels);         else5           WritePixelCache(image,GreenQuantum,pixels); B         (void) WriteBlob(image,packet_size*image->columns,pixels);       } +       for (y=0; y < (int) image->rows; y++)        { 7         if (!GetPixelCache(image,0,y,image->columns,1))            break;0         if (image->colorspace == CMYKColorspace)7           WritePixelCache(image,MagentaQuantum,pixels);          else4           WritePixelCache(image,BlueQuantum,pixels);B         (void) WriteBlob(image,packet_size*image->columns,pixels);       } @       if (image->matte || (image->colorspace == CMYKColorspace))-         for (y=0; y < (int) image->rows; y++) 	         { 9           if (!GetPixelCache(image,0,y,image->columns,1))              break;2           if (image->colorspace == CMYKColorspace)7             WritePixelCache(image,BlackQuantum,pixels);            else9             WritePixelCache(image,OpacityQuantum,pixels); D           (void) WriteBlob(image,packet_size*image->columns,pixels);	         }      }    FreeMemory(pixels);    CloseBlob(image);    return(True);  } 