 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            PPPP   W   W  PPPP                               % O %                            P   P  W   W  P   P                              % O %                            PPPP   W   W  PPPP                               % O %                            P      W W W  P                                  % O %                            P       W W   P                                  % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s P W P                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method IsPWP returns True if the image format type, identified by the %  magick string, is PWP.  % , %  The format of the ReadPWPImage method is: % 6 %      unsigned int IsPWP(const unsigned char *magick,# %        const unsigned int length)  % + %  A description of each parameter follows:  % J %    o status:  Method IsPWP returns True if the image format type is PWP. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */P Export unsigned int IsPWP(const unsigned char *magick,const unsigned int length) {    if (length < 5)      return(False);.   if (strncmp((char *) magick,"SFW95",5) == 0)     return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d P W P I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Method ReadPWPImage reads a Seattle Film Works multi-image file and returnsI %  it.  It allocates the memory necessary for the new Image structure and & %  returns a pointer to the new image. % , %  The format of the ReadPWPImage method is: % 7 %      Image *ReadPWPImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadPWPImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadPWPImage(const ImageInfo *image_info)  {    FILE
     *file;     Image      *image,      *next_image,     *pwp_image;      ImageInfo      *local_info;     int      c;     long
     filesize;      MonitorHandler     handler;     register Image     *p;      register int     i;     unsigned char      magick[MaxTextExtent];     unsigned int     status;      /*     Allocate image structure.    */&   pwp_image=AllocateImage(image_info);"   if (pwp_image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */7   status=OpenBlob(image_info,pwp_image,ReadBinaryType); '   if (pwp_image->file == (FILE *) NULL) @     ReaderExit(FileOpenWarning,"Unable to open file",pwp_image);/   status=ReadBlob(pwp_image,5,(char *) magick); E   if ((status == False) || (strncmp((char *) magick,"SFW95",5) != 0)) E     ReaderExit(CorruptImageWarning,"Not a PWP image file",pwp_image); (   local_info=CloneImageInfo(image_info);*   TemporaryFilename(local_info->filename);   image=(Image *) NULL; 
   for ( ; ; )    { @     for (c=ReadByte(pwp_image); c != EOF; c=ReadByte(pwp_image))     {        for (i=0; i < 17; i++)         magick[i]=magick[i+1];#       magick[17]=(unsigned char) c; 8       if (strncmp((char *) (magick+12),"SFW94A",6) == 0)         break;     }      if (c == EOF)        break;6     if (strncmp((char *) (magick+12),"SFW94A",6) != 0)G       ReaderExit(CorruptImageWarning,"Not a PWP image file",pwp_image);      /*)       Dump SFW image to a temporary file.      */5     file=fopen(local_info->filename,WriteBinaryType);      if (file == (FILE *) NULL)?       ReaderExit(FileOpenWarning,"Unable to write file",image); %     (void) fwrite("SFW94A",1,6,file); 7     filesize=65535L*magick[2]+256L*magick[1]+magick[0];       for (i=0; i < filesize; i++)     {        c=ReadByte(pwp_image);       (void) fputc(c,file);      }      (void) fclose(file);5     handler=SetMonitorHandler((MonitorHandler) NULL); (     next_image=ReadSFWImage(local_info);&     (void) SetMonitorHandler(handler);%     if (next_image == (Image *) NULL)        break;J     FormatString(next_image->filename,"slide_%02d.sfw",next_image->scene);      if (image == (Image *) NULL)       image=next_image;      else       { 
         /*%           Link image into image list. 
         */<         for (p=image; p->next != (Image *) NULL; p=p->next);         next_image->previous=p; %         next_image->scene=p->scene+1;          p->next=next_image;        } "     if (image_info->subrange != 0)M       if (next_image->scene >= (image_info->subimage+image_info->subrange-1))          break;F     ProgressMonitor(LoadImagesText,(unsigned int) TellBlob(pwp_image),*       (unsigned int) pwp_image->filesize);   } &   (void) remove(local_info->filename);   DestroyImageInfo(local_info);    CloseBlob(pwp_image);    DestroyImage(pwp_image);   return(image); } 