 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            RRRR    GGGG  BBBB                               % O %                            R   R  G      B   B                              % O %                            RRRR   G  GG  BBBB                               % O %                            R R    G   G  B   B                              % O %                            R  R    GGG   BBBB                               % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d R G B I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method ReadRGBImage reads an image of raw red, green, and blue bytes and M %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % , %  The format of the ReadRGBImage method is: % 7 %      Image *ReadRGBImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadRGBImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadRGBImage(const ImageInfo *image_info)  {    Image      *image;      int 
     count,     y;     register int     i,     x;     unsigned char      *scanline;     unsigned int     packet_size,     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL); 2   if ((image->columns == 0) || (image->rows == 0))>     ReaderExit(OptionWarning,"Must specify image size",image);2   if (image_info->interlace != PartitionInterlace)     {        /*         Open image file.       */7       status=OpenBlob(image_info,image,ReadBinaryType);        if (status == False)@         ReaderExit(FileOpenWarning,"Unable to open file",image);'       for (i=0; i < image->offset; i++)          (void) ReadByte(image);      }    /*#     Allocate memory for a scanline.    */'   packet_size=image->depth > 8 ? 6 : 3; 4   if (Latin1Compare(image_info->magick,"RGBA") == 0)     {        image->matte=True;+       packet_size=image->depth > 8 ? 8 : 4;      }    scanline=(unsigned char *)M     AllocateMemory(packet_size*image->tile_info.width*sizeof(unsigned char)); )   if (scanline == (unsigned char *) NULL) F     ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);    if (image_info->subrange != 0)/     while (image->scene < image_info->subimage)      {        /*         Skip to next image.        */       image->scene++; +       for (y=0; y < (int) image->rows; y++) K         (void) ReadBlob(image,packet_size*image->tile_info.width,scanline);      } #   x=packet_size*image->tile_info.x;    do   {      /*,       Convert raster image to pixel packets.     */"     switch (image_info->interlace)     {        case NoInterlace:        default:       { 
         /*0           No interlacing:  RGBRGBRGBRGBRGBRGB...
         */.         for (y=0; y < image->tile_info.y; y++)M           (void) ReadBlob(image,packet_size*image->tile_info.width,scanline); -         for (y=0; y < (int) image->rows; y++) 	         { =           if ((y > 0) || (image->previous == (Image *) NULL)) O             (void) ReadBlob(image,packet_size*image->tile_info.width,scanline); 9           if (!SetPixelCache(image,0,y,image->columns,1))              break;           if (!image->matte)8             ReadPixelCache(image,RGBQuantum,scanline+x);           else9             ReadPixelCache(image,RGBAQuantum,scanline+x); %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(LoadImageText,y,image->rows); 	         } E         count=image->tile_info.height-image->rows-image->tile_info.y; !         for (y=0; y < count; y++) M           (void) ReadBlob(image,packet_size*image->tile_info.width,scanline);          break;       }        case LineInterlace:        { 
         /*A           Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB... 
         */-         packet_size=image->depth > 8 ? 2 : 1; .         for (y=0; y < image->tile_info.y; y++)M           (void) ReadBlob(image,packet_size*image->tile_info.width,scanline); -         for (y=0; y < (int) image->rows; y++) 	         { =           if ((y > 0) || (image->previous == (Image *) NULL)) O             (void) ReadBlob(image,packet_size*image->tile_info.width,scanline); 9           if (!SetPixelCache(image,0,y,image->columns,1))              break;6           ReadPixelCache(image,RedQuantum,scanline+x);M           (void) ReadBlob(image,packet_size*image->tile_info.width,scanline); 8           ReadPixelCache(image,GreenQuantum,scanline+x);M           (void) ReadBlob(image,packet_size*image->tile_info.width,scanline); 7           ReadPixelCache(image,BlueQuantum,scanline+x);            if (image->matte) 
             { G               (void) ReadBlob(image,packet_size*image->tile_info.width,                  scanline);>               ReadPixelCache(image,OpacityQuantum,scanline+x);
             } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(LoadImageText,y,image->rows); 	         } E         count=image->tile_info.height-image->rows-image->tile_info.y; !         for (y=0; y < count; y++) M           (void) ReadBlob(image,packet_size*image->tile_info.width,scanline);          break;       }        case PlaneInterlace:       case PartitionInterlace:       {          unsigned int           span;   
         /*9           Plane interlacing:  RRRRRR...GGGGGG...BBBBBB... 
         */8         if (image_info->interlace == PartitionInterlace)           { 3             AppendImageFormat("R",image->filename); =             status=OpenBlob(image_info,image,ReadBinaryType);               if (status == False)F               ReaderExit(FileOpenWarning,"Unable to open file",image);           } -         packet_size=image->depth > 8 ? 2 : 1; .         for (y=0; y < image->tile_info.y; y++)M           (void) ReadBlob(image,packet_size*image->tile_info.width,scanline);          i=0;0         span=image->rows*(image->matte ? 4 : 3);-         for (y=0; y < (int) image->rows; y++) 	         { =           if ((y > 0) || (image->previous == (Image *) NULL)) O             (void) ReadBlob(image,packet_size*image->tile_info.width,scanline); 9           if (!SetPixelCache(image,0,y,image->columns,1))              break;6           ReadPixelCache(image,RedQuantum,scanline+x);%           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)$             if (QuantumTick(i,span))4               ProgressMonitor(LoadImageText,i,span);           i++;	         } E         count=image->tile_info.height-image->rows-image->tile_info.y; !         for (y=0; y < count; y++) M           (void) ReadBlob(image,packet_size*image->tile_info.width,scanline); 8         if (image_info->interlace == PartitionInterlace)           {              CloseBlob(image); 3             AppendImageFormat("G",image->filename); =             status=OpenBlob(image_info,image,ReadBinaryType);               if (status == False)F               ReaderExit(FileOpenWarning,"Unable to open file",image);           } .         for (y=0; y < image->tile_info.y; y++)M           (void) ReadBlob(image,packet_size*image->tile_info.width,scanline); -         for (y=0; y < (int) image->rows; y++) 	         { M           (void) ReadBlob(image,packet_size*image->tile_info.width,scanline); 9           if (!GetPixelCache(image,0,y,image->columns,1))              break;8           ReadPixelCache(image,GreenQuantum,scanline+x);%           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)$             if (QuantumTick(i,span))4               ProgressMonitor(LoadImageText,i,span);           i++;	         } E         count=image->tile_info.height-image->rows-image->tile_info.y; !         for (y=0; y < count; y++) M           (void) ReadBlob(image,packet_size*image->tile_info.width,scanline); 8         if (image_info->interlace == PartitionInterlace)           {              CloseBlob(image); 3             AppendImageFormat("B",image->filename); =             status=OpenBlob(image_info,image,ReadBinaryType);               if (status == False)F               ReaderExit(FileOpenWarning,"Unable to open file",image);           } .         for (y=0; y < image->tile_info.y; y++)M           (void) ReadBlob(image,packet_size*image->tile_info.width,scanline); -         for (y=0; y < (int) image->rows; y++) 	         { M           (void) ReadBlob(image,packet_size*image->tile_info.width,scanline); 9           if (!GetPixelCache(image,0,y,image->columns,1))              break;7           ReadPixelCache(image,BlueQuantum,scanline+x); %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)$             if (QuantumTick(i,span))4               ProgressMonitor(LoadImageText,i,span);           i++;	         } E         count=image->tile_info.height-image->rows-image->tile_info.y; !         for (y=0; y < count; y++) M           (void) ReadBlob(image,packet_size*image->tile_info.width,scanline);          if (image->matte)            {              /*!               Read matte channel.              */<             if (image_info->interlace == PartitionInterlace)               { !                 CloseBlob(image); 7                 AppendImageFormat("A",image->filename); A                 status=OpenBlob(image_info,image,ReadBinaryType); $                 if (status == False)J                   ReaderExit(FileOpenWarning,"Unable to open file",image);               } 2             for (y=0; y < image->tile_info.y; y++)G               (void) ReadBlob(image,packet_size*image->tile_info.width,                  scanline);1             for (y=0; y < (int) image->rows; y++) 
             { G               (void) ReadBlob(image,packet_size*image->tile_info.width,                  scanline);=               if (!GetPixelCache(image,0,y,image->columns,1))                  break;>               ReadPixelCache(image,OpacityQuantum,scanline+x);)               if (!SyncPixelCache(image))                  break;4               if (image->previous == (Image *) NULL)(                 if (QuantumTick(i,span))8                   ProgressMonitor(LoadImageText,i,span);               i++;
             } I             count=image->tile_info.height-image->rows-image->tile_info.y; %             for (y=0; y < count; y++) G               (void) ReadBlob(image,packet_size*image->tile_info.width,                  scanline);           } 8         if (image_info->interlace == PartitionInterlace)>           (void) strcpy(image->filename,image_info->filename);         break;       }      }      /*       Proceed to next image.     */"     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;F     count=ReadBlob(image,packet_size*image->tile_info.width,scanline);     if (count > 0)       { 
         /*(           Allocate next image structure.
         */,         AllocateNextImage(image_info,image);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            }          image=image->next;F         ProgressMonitor(LoadImagesText,(unsigned int) TellBlob(image),*           (unsigned int) image->filesize);       }    } while (count > 0);   FreeMemory(scanline); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e R G B I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method WriteRGBImage writes an image to a file in red, green, and blue  %  rasterfile format.  % - %  The format of the WriteRGBImage method is:  % K %      unsigned int WriteRGBImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % H %    o status: Method WriteRGBImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K Export unsigned int WriteRGBImage(const ImageInfo *image_info,Image *image)  {    int      y;     unsigned char      *pixels;     unsigned int     packet_size,
     scene,     status;      /*     Allocate memory for pixels.    */   image->depth=QuantumDepth;'   packet_size=image->depth > 8 ? 6 : 3; F   if (image->matte || (Latin1Compare(image_info->magick,"RGBA") == 0)))     packet_size=image->depth > 8 ? 8 : 4;    pixels=(unsigned char *)C     AllocateMemory(packet_size*image->columns*sizeof(PixelPacket)); '   if (pixels == (unsigned char *) NULL) F     WriterExit(ResourceLimitWarning,"Memory allocation failed",image);2   if (image_info->interlace != PartitionInterlace)     {        /*         Open output image file.        */8       status=OpenBlob(image_info,image,WriteBinaryType);       if (status == False)@         WriterExit(FileOpenWarning,"Unable to open file",image);     } 
   scene=0;   do   {      /*(       Convert MIFF to RGB raster pixels.     */+     TransformRGBImage(image,RGBColorspace); 6     if (Latin1Compare(image_info->magick,"RGBA") == 0)       if (!image->matte)!         MatteImage(image,Opaque); "     switch (image_info->interlace)     {        case NoInterlace:        default:       { 
         /*0           No interlacing:  RGBRGBRGBRGBRGBRGB...
         */-         for (y=0; y < (int) image->rows; y++) 	         { 9           if (!GetPixelCache(image,0,y,image->columns,1))              break;<           if (Latin1Compare(image_info->magick,"RGBA") != 0)
             { 7               WritePixelCache(image,RGBQuantum,pixels); H               (void) WriteBlob(image,packet_size*image->columns,pixels);
             }            else
             { 8               WritePixelCache(image,RGBAQuantum,pixels);H               (void) WriteBlob(image,packet_size*image->columns,pixels);
             } 0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(SaveImageText,y,image->rows); 	         }          break;       }        case LineInterlace:        { 
         /*A           Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB... 
         */-         for (y=0; y < (int) image->rows; y++) 	         { 9           if (!GetPixelCache(image,0,y,image->columns,1))              break;3           WritePixelCache(image,RedQuantum,pixels); 8           (void) WriteBlob(image,image->columns,pixels);5           WritePixelCache(image,GreenQuantum,pixels); 8           (void) WriteBlob(image,image->columns,pixels);4           WritePixelCache(image,BlueQuantum,pixels);8           (void) WriteBlob(image,image->columns,pixels);           if (image->matte) 
             { ;               WritePixelCache(image,OpacityQuantum,pixels); <               (void) WriteBlob(image,image->columns,pixels);
             } )           if (QuantumTick(y,image->rows)) 9             ProgressMonitor(SaveImageText,y,image->rows); 	         }          break;       }        case PlaneInterlace:       case PartitionInterlace:       { 
         /*9           Plane interlacing:  RRRRRR...GGGGGG...BBBBBB... 
         */8         if (image_info->interlace == PartitionInterlace)           { 3             AppendImageFormat("R",image->filename); >             status=OpenBlob(image_info,image,WriteBinaryType);              if (status == False)F               WriterExit(FileOpenWarning,"Unable to open file",image);           } -         for (y=0; y < (int) image->rows; y++) 	         { 9           if (!GetPixelCache(image,0,y,image->columns,1))              break;3           WritePixelCache(image,RedQuantum,pixels); 8           (void) WriteBlob(image,image->columns,pixels);	         } 8         if (image_info->interlace == PartitionInterlace)           {              CloseBlob(image); 3             AppendImageFormat("G",image->filename); >             status=OpenBlob(image_info,image,WriteBinaryType);              if (status == False)F               WriterExit(FileOpenWarning,"Unable to open file",image);           } /         ProgressMonitor(SaveImageText,100,400); -         for (y=0; y < (int) image->rows; y++) 	         { 9           if (!GetPixelCache(image,0,y,image->columns,1))              break;5           WritePixelCache(image,GreenQuantum,pixels); 8           (void) WriteBlob(image,image->columns,pixels);	         } 8         if (image_info->interlace == PartitionInterlace)           {              CloseBlob(image); 3             AppendImageFormat("B",image->filename); >             status=OpenBlob(image_info,image,WriteBinaryType);              if (status == False)F               WriterExit(FileOpenWarning,"Unable to open file",image);           } /         ProgressMonitor(SaveImageText,200,400); -         for (y=0; y < (int) image->rows; y++) 	         { 9           if (!GetPixelCache(image,0,y,image->columns,1))              break;4           WritePixelCache(image,BlueQuantum,pixels);8           (void) WriteBlob(image,image->columns,pixels);	         }          if (image->matte)            { 3             ProgressMonitor(SaveImageText,300,400); <             if (image_info->interlace == PartitionInterlace)               { !                 CloseBlob(image); 7                 AppendImageFormat("A",image->filename); B                 status=OpenBlob(image_info,image,WriteBinaryType);$                 if (status == False)J                   WriterExit(FileOpenWarning,"Unable to open file",image);               } 1             for (y=0; y < (int) image->rows; y++) 
             { =               if (!GetPixelCache(image,0,y,image->columns,1))                  break;;               WritePixelCache(image,OpacityQuantum,pixels); <               (void) WriteBlob(image,image->columns,pixels);
             }            } 8         if (image_info->interlace == PartitionInterlace)>           (void) strcpy(image->filename,image_info->filename);/         ProgressMonitor(SaveImageText,400,400);          break;       }      } &     if (image->next == (Image *) NULL)       break;     image=GetNextImage(image);C     ProgressMonitor(SaveImagesText,scene++,GetNumberScenes(image));    } while (image_info->adjoin);    FreeMemory(pixels);    if (image_info->adjoin) -     while (image->previous != (Image *) NULL)        image=image->previous;   CloseBlob(image);    return(True);  } 