 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            SSSSS   GGGG  IIIII                              % O %                            SS     G        I                                % O %                             SSS   G  GG    I                                % O %                               SS  G   G    I                                % O %                            SSSSS   GGG   IIIII                              % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s S G I                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method IsSGI returns True if the image format type, identified by the %  magick string, is SGI.  % , %  The format of the ReadSGIImage method is: % 6 %      unsigned int IsSGI(const unsigned char *magick,# %        const unsigned int length)  % + %  A description of each parameter follows:  % J %    o status:  Method IsSGI returns True if the image format type is SGI. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */P Export unsigned int IsSGI(const unsigned char *magick,const unsigned int length) {    if (length < 2)      return(False);1   if (strncmp((char *) magick,"\001\332",2) == 0)      return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d S G I I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method ReadSGIImage reads a SGI RGB image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % , %  The format of the ReadSGIImage method is: % 7 %      Image *ReadSGIImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadSGIImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */  G static void SGIDecode(unsigned char *max_packets,unsigned char *pixels)  {    unsigned char 
     count,
     pixel;     for ( ; ;)   {      pixel=(*max_packets++);      count=pixel & 0x7f;      if (count == 0)        break;     if (pixel & 0x80) "       for ( ; count != 0; count--)       { !         *pixels=(*max_packets++);          pixels+=4;       }      else       {          pixel=(*max_packets++); $         for ( ; count != 0; count--)	         {            *pixels=pixel;           pixels+=4;	         }        }    }  }   7 Export Image *ReadSGIImage(const ImageInfo *image_info)  {    typedef struct _SGIHeader    {      unsigned short       magic;       unsigned char        storage,       bytes_per_pixel;       unsigned short       dimension,       columns,       rows,        depth;       unsigned long        minimum_value,       maximum_value;       unsigned char        filler[492];   } SGIHeader;     Image      *image;      SGIHeader      iris_header;     register int     i,     x,     y,     z;     register PixelPacket     *q;      register unsigned char     *p;      unsigned char      *iris_pixels;      unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*     Read SGI raster header.    */-   iris_header.magic=MSBFirstReadShort(image);    do   {      /*       Verify SGI identifier.     */$     if (iris_header.magic != 0x01DA)B       ReaderExit(CorruptImageWarning,"Not a SGI RGB image",image);(     iris_header.storage=ReadByte(image);0     iris_header.bytes_per_pixel=ReadByte(image);)     if (iris_header.bytes_per_pixel != 1) %       ReaderExit(CorruptImageWarning, :         "Image must have 1 byte per pixel channel",image);3     iris_header.dimension=MSBFirstReadShort(image); 1     iris_header.columns=MSBFirstReadShort(image); .     iris_header.rows=MSBFirstReadShort(image);/     iris_header.depth=MSBFirstReadShort(image); '     image->columns=iris_header.columns; !     image->rows=iris_header.rows;      if (iris_header.depth < 3)       { !         image->class=PseudoClass;          image->colors=256;       }      if (image_info->ping)        {          CloseBlob(image);          return(image);       } 6     iris_header.minimum_value=MSBFirstReadLong(image);6     iris_header.maximum_value=MSBFirstReadLong(image);D     (void) ReadBlob(image,(unsigned int) sizeof(iris_header.filler),#       (char *) iris_header.filler);      /*       Allocate SGI pixels.     */G     iris_pixels=(unsigned char *) AllocateMemory(4*iris_header.columns* .       iris_header.rows*sizeof(unsigned char));.     if (iris_pixels == (unsigned char *) NULL)H       ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);$     if (iris_header.storage != 0x01)       {          unsigned char            *scanline;  
         /*%           Read standard image format. 
         */"         scanline=(unsigned char *)D           AllocateMemory(iris_header.columns*sizeof(unsigned char));/         if (scanline == (unsigned char *) NULL) L           ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);3         for (z=0; z < (int) iris_header.depth; z++) 	         {            p=iris_pixels+z;4           for (y=0; y < (int) iris_header.rows; y++)           { I             (void) ReadBlob(image,iris_header.columns,(char *) scanline); 9             for (x=0; x < (int) iris_header.columns; x++) 
             {                *p=scanline[x];                p+=4; 
             }            } 	         }          FreeMemory(scanline);        }      else       {          unsigned char            *max_packets;            unsigned int           data_order;            unsigned long            offset,            *offsets,            *runlength;   
         /*.           Read runlength-encoded image format.
         */B         offsets=(unsigned long *) AllocateMemory(iris_header.rows*3           iris_header.depth*sizeof(unsigned long)); %         max_packets=(unsigned char *) P           AllocateMemory(((iris_header.columns << 1)+10)*sizeof(unsigned char));D         runlength=(unsigned long *) AllocateMemory(iris_header.rows*3           iris_header.depth*sizeof(unsigned long)); 2         if ((offsets == (unsigned long *) NULL) ||6             (max_packets == (unsigned char *) NULL) ||2             (runlength == (unsigned long *) NULL))L           ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)-           offsets[i]=MSBFirstReadLong(image); F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)/           runlength[i]=MSBFirstReadLong(image); 
         /*           Check data order. 
         */         offset=0;          data_order=0; E         for (y=0; ((y < (int) iris_header.rows) && !data_order); y++) H           for (z=0; ((z < (int) iris_header.depth) && !data_order); z++)           { 7             if (offsets[y+z*iris_header.rows] < offset)                data_order=1; 1             offset=offsets[y+z*iris_header.rows];            } A         offset=512+4*((iris_header.rows*iris_header.depth) << 1);          if (data_order == 1)           { 7             for (z=0; z < (int) iris_header.depth; z++) 
             {                p=iris_pixels;8               for (y=0; y < (int) iris_header.rows; y++)               { <                 if (offset != offsets[y+z*iris_header.rows])                   { 9                     offset=offsets[y+z*iris_header.rows]; B                     (void) SeekBlob(image,(long) offset,SEEK_SET);                   } 4                 (void) ReadBlob(image,(unsigned int)H                   runlength[y+z*iris_header.rows],(char *) max_packets);8                 offset+=runlength[y+z*iris_header.rows];+                 SGIDecode(max_packets,p+z); +                 p+=(iris_header.columns*4);                } 
             }            }          else           {              p=iris_pixels;6             for (y=0; y < (int) iris_header.rows; y++)
             { 9               for (z=0; z < (int) iris_header.depth; z++)                { <                 if (offset != offsets[y+z*iris_header.rows])                   { 9                     offset=offsets[y+z*iris_header.rows]; B                     (void) SeekBlob(image,(long) offset,SEEK_SET);                   } 4                 (void) ReadBlob(image,(unsigned int)H                   runlength[y+z*iris_header.rows],(char *) max_packets);8                 offset+=runlength[y+z*iris_header.rows];+                 SGIDecode(max_packets,p+z);                } )               p+=(iris_header.columns*4); 
             }            }          FreeMemory(runlength);          FreeMemory(max_packets);         FreeMemory(offsets);       }      /*!       Initialize image structure.      */(     image->matte=iris_header.depth == 4;'     image->columns=iris_header.columns; !     image->rows=iris_header.rows;      /*0       Convert SGI raster image to pixel packets.     */$     if (image->class == DirectClass)       { 
         /*9           Convert SGI image to DirectClass pixel packets. 
         */-         for (y=0; y < (int) image->rows; y++) 	         { ?           p=iris_pixels+((image->rows-1)-y)*(image->columns*4); 6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           {              q->red=UpScale(*p); %             q->green=UpScale(*(p+1)); $             q->blue=UpScale(*(p+2));'             q->opacity=UpScale(*(p+3));              p+=4;              q++;           } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(LoadImageText,y,image->rows); 	         }        }      else       {          unsigned short           index;  
         /*           Create grayscale map. 
         */'         image->colormap=(PixelPacket *) <           AllocateMemory(image->colors*sizeof(PixelPacket));4         if (image->colormap == (PixelPacket *) NULL)L           ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);/         for (i=0; i < (int) image->colors; i++) 	         { 6           image->colormap[i].red=(Quantum) UpScale(i);8           image->colormap[i].green=(Quantum) UpScale(i);7           image->colormap[i].blue=(Quantum) UpScale(i); 	         } 
         /*9           Convert SGI image to PseudoClass pixel packets. 
         */-         for (y=0; y < (int) image->rows; y++) 	         { 9           if (!SetPixelCache(image,0,y,image->columns,1))              break;?           p=iris_pixels+((image->rows-1)-y)*(image->columns*4); 2           for (x=0; x < (int) image->columns; x++)           { (             index=(unsigned short) (*p);$             image->indexes[x]=index;             p+=4;              q++;           } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(LoadImageText,y,image->rows); 	         }          SyncImage(image);        }      FreeMemory(iris_pixels);     /*       Proceed to next image.     */"     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;/     iris_header.magic=MSBFirstReadShort(image); $     if (iris_header.magic == 0x01DA)       { 
         /*(           Allocate next image structure.
         */,         AllocateNextImage(image_info,image);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            }          image=image->next;F         ProgressMonitor(LoadImagesText,(unsigned int) TellBlob(image),*           (unsigned int) image->filesize);       } (   } while (iris_header.magic == 0x01DA);+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e S G I I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method WriteSGIImage writes an image in SGI RGB encoded image format. % - %  The format of the WriteSGIImage method is:  % K %      unsigned int WriteSGIImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % H %    o status: Method WriteSGIImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */  5 static int SGIEncode(unsigned char *pixels,int count,    unsigned char *packets)  {    short      runlength;     unsigned char      *limit, 
     *mark,     *p,      *q;      p=pixels;    limit=p+count*4;   q=packets;   while (p < limit)    {      mark=p; 	     p+=8; A     while ((p < limit) && ((*(p-8) != *(p-4)) || (*(p-4) != *p)))        p+=4; 	     p-=8;       count=(int) ((p-mark) >> 2);     while (count)      { 4       runlength=(short) (count > 126 ? 126 : count);       count-=runlength;        *q++=0x80 | runlength;)       for ( ; runlength > 0; runlength--)        {          *q++=(*mark);          mark+=4;       }      }      mark=p; 	     p+=4; (     while ((p < limit) && (*p == *mark))       p+=4;       count=(int) ((p-mark) >> 2);     while (count)      { 4       runlength=(short) (count > 126 ? 126 : count);       count-=runlength; %       *q++=(unsigned char) runlength;        *q++=(*mark);      }    } 	   *q++=0;    return((int) (q-packets)); }   K Export unsigned int WriteSGIImage(const ImageInfo *image_info,Image *image)  {    typedef struct _SGIHeader    {      unsigned short       magic;       unsigned char        storage,       bytes_per_pixel;       unsigned short       dimension,       columns,       rows,        depth;       unsigned long        minimum_value,       maximum_value;       unsigned char        filler[492];   } SGIHeader;     int      y,     z;     SGIHeader      iris_header;     register int     i,     x;     register PixelPacket     *p;      register unsigned char     *q;      unsigned char      *iris_pixels, 
     *packets;      unsigned int
     scene,     status;      /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);
   scene=0;   do   {      /*(       Initialize SGI raster file header.     */+     TransformRGBImage(image,RGBColorspace);      iris_header.magic=0x01DA; 1     if (image_info->compression == NoCompression)        iris_header.storage=0x00;      else       iris_header.storage=0x01; <     iris_header.bytes_per_pixel=1;  /* one byte per pixel */     iris_header.dimension=3;'     iris_header.columns=image->columns; !     iris_header.rows=image->rows; +     iris_header.depth=image->matte ? 4 : 3;      if (IsGrayImage(image))        {           iris_header.dimension=2;         iris_header.depth=1;       }       iris_header.minimum_value=0;%     iris_header.maximum_value=MaxRGB; 8     for (i=0; i < (int) sizeof(iris_header.filler); i++)       iris_header.filler[i]=0;     /*       Write SGI header.      */0     MSBFirstWriteShort(image,iris_header.magic);0     (void) WriteByte(image,iris_header.storage);8     (void) WriteByte(image,iris_header.bytes_per_pixel);4     MSBFirstWriteShort(image,iris_header.dimension);2     MSBFirstWriteShort(image,iris_header.columns);/     MSBFirstWriteShort(image,iris_header.rows); 0     MSBFirstWriteShort(image,iris_header.depth);7     MSBFirstWriteLong(image,iris_header.minimum_value); 7     MSBFirstWriteLong(image,iris_header.maximum_value); 6     (void) WriteBlob(image,sizeof(iris_header.filler),#       (char *) iris_header.filler);      /*       Allocate SGI pixels.     */!     iris_pixels=(unsigned char *) I       AllocateMemory(4*image->columns*image->rows*sizeof(unsigned char)); .     if (iris_pixels == (unsigned char *) NULL)H       WriterExit(ResourceLimitWarning,"Memory allocation failed",image);     /*7       Convert pixel packets to uncompressed SGI pixels.      */)     for (y=0; y < (int) image->rows; y++)      { 2       p=GetPixelCache(image,0,y,image->columns,1);$       if (p == (PixelPacket *) NULL)         break;E       q=iris_pixels+((iris_header.rows-1)-y)*(iris_header.columns*4); .       for (x=0; x < (int) image->columns; x++)       {          *q++=DownScale(p->red); !         *q++=DownScale(p->green);           *q++=DownScale(p->blue);(         *q++=(unsigned char) p->opacity;         p++;       } ,       if (image->previous == (Image *) NULL)'         if (QuantumTick(y,image->rows)) 7           ProgressMonitor(SaveImageText,y,image->rows);      } 1     if (image_info->compression == NoCompression)        {          unsigned char            *scanline;  
         /*(           Write uncompressed SGI pixels.
         */"         scanline=(unsigned char *)D           AllocateMemory(iris_header.columns*sizeof(unsigned char));/         if (scanline == (unsigned char *) NULL) L           WriterExit(ResourceLimitWarning,"Memory allocation failed",image);3         for (z=0; z < (int) iris_header.depth; z++) 	         {            q=iris_pixels+z;4           for (y=0; y < (int) iris_header.rows; y++)           { 9             for (x=0; x < (int) iris_header.columns; x++) 
             {                scanline[x]=(*q);                q+=4; 
             } J             (void) WriteBlob(image,iris_header.columns,(char *) scanline);           } 	         }          FreeMemory(scanline);        }      else       {          unsigned long            length,            number_packets,            offset,            *offsets,            *runlength;   
         /*F           Convert SGI uncompressed pixels to runlength-encoded pixels.
         */B         offsets=(unsigned long *) AllocateMemory(iris_header.rows*3           iris_header.depth*sizeof(unsigned long)); O         packets=(unsigned char *) AllocateMemory(4*((iris_header.columns << 1)+ 1           10)*image->rows*sizeof(unsigned char)); D         runlength=(unsigned long *) AllocateMemory(iris_header.rows*3           iris_header.depth*sizeof(unsigned long)); 2         if ((offsets == (unsigned long *) NULL) ||2             (packets == (unsigned char *) NULL) ||2             (runlength == (unsigned long *) NULL))L           WriterExit(ResourceLimitWarning,"Memory allocation failed",image);A         offset=512+4*((iris_header.rows*iris_header.depth) << 1);          number_packets=0;          q=iris_pixels;2         for (y=0; y < (int) iris_header.rows; y++)	         { 5           for (z=0; z < (int) iris_header.depth; z++)            {              length= N               SGIEncode(q+z,(int) iris_header.columns,packets+number_packets);#             number_packets+=length; 1             offsets[y+z*iris_header.rows]=offset; 3             runlength[y+z*iris_header.rows]=length;              offset+=length;            } %           q+=(iris_header.columns*4); 	         } 
         /*N           Write out line start and length tables and runlength-encoded pixels.
         */F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++).           MSBFirstWriteLong(image,offsets[i]);F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)0           MSBFirstWriteLong(image,runlength[i]);@         (void) WriteBlob(image,number_packets,(char *) packets);
         /*           Free memory.
         */         FreeMemory(runlength);         FreeMemory(packets);         FreeMemory(offsets);       }      FreeMemory(iris_pixels);&     if (image->next == (Image *) NULL)       break;     image=GetNextImage(image);C     ProgressMonitor(SaveImagesText,scene++,GetNumberScenes(image));    } while (image_info->adjoin);    if (image_info->adjoin) -     while (image->previous != (Image *) NULL)        image=image->previous;   CloseBlob(image);    return(True);  } 