 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            TTTTT   GGGG   AAA                               % O %                              T    G      A   A                              % O %                              T    G  GG  AAAAA                              % O %                              T    G   G  A   A                              % O %                              T     GGG   A   A                              % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d T G A I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method ReadTGAImage reads a Truevision TGA image file and returns it.L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. % , %  The format of the ReadTGAImage method is: % 7 %      Image *ReadTGAImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadTGAImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadTGAImage(const ImageInfo *image_info)  {  #define TGAColormap 1  #define TGARGB 2 #define TGAMonochrome 3  #define TGARLEColormap  9  #define TGARLERGB  10  #define TGARLEMonochrome  11     typedef struct _TGAHeader    {      unsigned char        id_length,       colormap_type,       image_type;        unsigned short       colormap_index,        colormap_length;       unsigned char        colormap_size;       unsigned short       x_origin,        y_origin,        width,
       height;        unsigned char        bits_per_pixel,        attributes;    } TGAHeader;     Image      *image;   
   IndexPacket 
     index;     int      y;  
   PixelPacket 
     pixel;     register int     i,     x;     register PixelPacket     *q;      TGAHeader      tga_header;      unsigned char      j,     k,     runlength;     unsigned int	     base, 	     flag,      offset, 	     real, 	     skip,      status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*      Read TGA header information.   */:   status=ReadBlob(image,1,(char *) &tga_header.id_length);+   tga_header.colormap_type=ReadByte(image); (   tga_header.image_type=ReadByte(image);   do   { <     if ((status == False) || (tga_header.image_type == 0) ||%         (tga_header.image_type > 11)) C       ReaderExit(CorruptImageWarning,"Not a TGA image file",image); 7     tga_header.colormap_index=LSBFirstReadShort(image); 8     tga_header.colormap_length=LSBFirstReadShort(image);-     tga_header.colormap_size=ReadByte(image); 1     tga_header.x_origin=LSBFirstReadShort(image); 1     tga_header.y_origin=LSBFirstReadShort(image); .     tga_header.width=LSBFirstReadShort(image);/     tga_header.height=LSBFirstReadShort(image); .     tga_header.bits_per_pixel=ReadByte(image);*     tga_header.attributes=ReadByte(image);     /*!       Initialize image structure.      */1     image->matte=tga_header.bits_per_pixel == 32; $     image->columns=tga_header.width;"     image->rows=tga_header.height;&     if (tga_header.colormap_type != 0)       { 8         if ((tga_header.image_type == TGARLEColormap) ||1             (tga_header.image_type == TGARLERGB)) #           image->class=PseudoClass; 1         image->colors=tga_header.colormap_length;        }      if (image_info->ping)        {          CloseBlob(image);          return(image);       } "     if (tga_header.id_length != 0)       { 
         /*           TGA image comment.
         */          image->comments=(char *)@           AllocateMemory((tga_header.id_length+1)*sizeof(char));-         if (image->comments == (char *) NULL) L           ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);D         (void) ReadBlob(image,tga_header.id_length,image->comments);3         image->comments[tga_header.id_length]='\0';        }      GetPixelPacket(&pixel); &     if (tga_header.colormap_type != 0)       { 
         /*#           Read TGA raster colormap. 
         */'         image->colormap=(PixelPacket *) <           AllocateMemory(image->colors*sizeof(PixelPacket));4         if (image->colormap == (PixelPacket *) NULL)L           ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);/         for (i=0; i < (int) image->colors; i++) 	         { +           switch (tga_header.colormap_size)            {              case 8:              default:
             {                /*                 Gray scale.                */1               pixel.red=UpScale(ReadByte(image)); $               pixel.green=pixel.red;#               pixel.blue=pixel.red;                break;
             }              case 15:             case 16:
             {                /*2                 5 bits each of red green and blue.               */                j=ReadByte(image);                k=ReadByte(image);H               pixel.red=(Quantum) ((MaxRGB*((int) (k & 0x7c) >> 2))/31);#               pixel.green=(Quantum) P                 ((MaxRGB*(((int) (k & 0x03) << 3)+((int) (j & 0xe0) >> 5)))/31);D               pixel.blue=(Quantum) ((MaxRGB*((int) (j & 0x1f)))/31);               break;
             }              case 24:             case 32:
             {                /*3                 8 bits each of blue, green and red.                */2               pixel.blue=UpScale(ReadByte(image));3               pixel.green=UpScale(ReadByte(image)); 1               pixel.red=UpScale(ReadByte(image));                break;
             }            } #           image->colormap[i]=pixel; 	         }        }      /**       Convert TGA pixels to pixel packets.     */     base=0;      flag=0;      skip=False;      real=0;      index=0;     runlength=0;
     offset=0; )     for (y=0; y < (int) image->rows; y++)      {        real=offset;E       if (((unsigned char) (tga_header.attributes & 0x20) >> 5) == 0)           real=image->rows-real-1;5       q=SetPixelCache(image,0,real,image->columns,1); $       if (q == (PixelPacket *) NULL)         break;.       for (x=0; x < (int) image->columns; x++)       { 8         if ((tga_header.image_type == TGARLEColormap) ||3             (tga_header.image_type == TGARLERGB) || 8             (tga_header.image_type == TGARLEMonochrome))           {              if (runlength != 0)                {                  runlength--;                 skip=flag != 0;                }              else               { =                 status=ReadBlob(image,1,(char *) &runlength); $                 if (status == False)M                   ReaderExit(CorruptImageWarning,"Unable to read image data",                      image); &                 flag=runlength & 0x80;                 if (flag != 0)!                   runlength-=128;                  skip=False;                }            }          if (!skip),           switch (tga_header.bits_per_pixel)           {              case 8:              default:
             {                /*                 Gray scale.                */$               index=ReadByte(image);0               if (tga_header.colormap_type != 0)-                 pixel=image->colormap[index];                else                 { 5                   pixel.red=(Quantum) UpScale(index); 7                   pixel.green=(Quantum) UpScale(index); 6                   pixel.blue=(Quantum) UpScale(index);                 }                break;
             }              case 15:             case 16:
             {                /*2                 5 bits each of red green and blue.               */                j=ReadByte(image);                k=ReadByte(image);H               pixel.red=(Quantum) ((MaxRGB*((int) (k & 0x7c) >> 2))/31);#               pixel.green=(Quantum) P                 ((MaxRGB*(((int) (k & 0x03) << 3)+((int) (j & 0xe0) >> 5)))/31);D               pixel.blue=(Quantum) ((MaxRGB*((int) (j & 0x1f)))/31);0               index=((unsigned short) k << 8)+j;               break;
             }              case 24:             case 32:
             {                /*2                 8 bits each of blue green and red.               */2               pixel.blue=UpScale(ReadByte(image));3               pixel.green=UpScale(ReadByte(image)); 1               pixel.red=UpScale(ReadByte(image)); 2               if (tga_header.bits_per_pixel == 32)7                 pixel.opacity=UpScale(ReadByte(image));                break;
             }            }          if (status == False)L           ReaderExit(CorruptImageWarning,"Unable to read image data",image);(         if (image->class == PseudoClass)"           image->indexes[x]=index;         *q++=pixel;        } E       if (((unsigned char) (tga_header.attributes & 0xc0) >> 6) == 4)          offset+=4;
       elseG         if (((unsigned char) (tga_header.attributes & 0xc0) >> 6) == 2)            offset+=2;         else           offset++;         if (offset >= image->rows)	         {            base++;            offset=base;	         } !       if (!SyncPixelCache(image))          break;       if (EOFBlob(image))          break;,       if (image->previous == (Image *) NULL)'         if (QuantumTick(y,image->rows)) 7           ProgressMonitor(LoadImageText,y,image->rows);      }      (void) IsGrayImage(image);     /*       Proceed to next image.     */"     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;<     status=ReadBlob(image,1,(char *) &tga_header.id_length);-     tga_header.colormap_type=ReadByte(image); *     tga_header.image_type=ReadByte(image);L     status&=((tga_header.image_type != 0) && (tga_header.image_type <= 11));     if (status == True)        { 
         /*(           Allocate next image structure.
         */,         AllocateNextImage(image_info,image);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            }          image=image->next;F         ProgressMonitor(LoadImagesText,(unsigned int) TellBlob(image),*           (unsigned int) image->filesize);       }    } while (status == True); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e T G A I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method WriteTGAImage writes a image in the Truevision Targa rasterfile 
 %  format. % - %  The format of the WriteTGAImage method is:  % K %      unsigned int WriteTGAImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % H %    o status: Method WriteTGAImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K Export unsigned int WriteTGAImage(const ImageInfo *image_info,Image *image)  {  #define TargaColormap 1  #define TargaRGB 2 #define TargaMonochrome 3  #define TargaRLEColormap  9  #define TargaRLERGB  10  #define TargaRLEMonochrome  11     typedef struct _TargaHeader    {      unsigned char        id_length,       colormap_type,       image_type;        unsigned short       colormap_index,        colormap_length;       unsigned char        colormap_size;       unsigned short       x_origin,        y_origin,        width,
       height;        unsigned char        bits_per_pixel,        attributes;    } TargaHeader;     int 
     count,     y;     register int     i,     x;     register PixelPacket     *p;      register unsigned char     *q;   
   TargaHeader      targa_header;      unsigned char      *targa_pixels;     unsigned int
     scene,     status;      /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);
   scene=0;   do   {      /*(       Initialize TGA raster file header.     */+     TransformRGBImage(image,RGBColorspace);      targa_header.id_length=0; )     if (image->comments != (char *) NULL) >       targa_header.id_length=Min(Extent(image->comments),255);!     targa_header.colormap_type=0; "     targa_header.colormap_index=0;#     targa_header.colormap_length=0; !     targa_header.colormap_size=0;      targa_header.x_origin=0;     targa_header.y_origin=0;&     targa_header.width=image->columns;$     targa_header.height=image->rows;"     targa_header.bits_per_pixel=8;     targa_header.attributes=0;     if (!IsPseudoClass(image))       { 
         /*            Full color TGA raster.
         */)         targa_header.image_type=TargaRGB; ;         targa_header.bits_per_pixel=image->matte ? 32 : 24;        }      else       { 
         /*!           Colormapped TGA raster. 
         */.         targa_header.image_type=TargaColormap;%         targa_header.colormap_type=1; &         targa_header.colormap_index=0;3         targa_header.colormap_length=image->colors; &         targa_header.colormap_size=24;       }      /*       Write TGA header.      */:     (void) WriteByte(image,(char) targa_header.id_length);>     (void) WriteByte(image,(char) targa_header.colormap_type);;     (void) WriteByte(image,(char) targa_header.image_type); :     LSBFirstWriteShort(image,targa_header.colormap_index);;     LSBFirstWriteShort(image,targa_header.colormap_length); >     (void) WriteByte(image,(char) targa_header.colormap_size);4     LSBFirstWriteShort(image,targa_header.x_origin);4     LSBFirstWriteShort(image,targa_header.y_origin);1     LSBFirstWriteShort(image,targa_header.width); 2     LSBFirstWriteShort(image,targa_header.height);?     (void) WriteByte(image,(char) targa_header.bits_per_pixel); ;     (void) WriteByte(image,(char) targa_header.attributes); $     if (targa_header.id_length != 0)N       (void) WriteBlob(image,targa_header.id_length,(char *) image->comments);     if (IsPseudoClass(image))        {          unsigned char            *targa_colormap;  
         /*>           Dump colormap to file (blue, green, red byte order).
         */:         targa_colormap=(unsigned char *) AllocateMemory(3*>           targa_header.colormap_length*sizeof(unsigned char));5         if (targa_colormap == (unsigned char *) NULL) L           WriterExit(ResourceLimitWarning,"Memory allocation failed",image);         q=targa_colormap; /         for (i=0; i < (int) image->colors; i++) 	         { 2           *q++=DownScale(image->colormap[i].blue);3           *q++=DownScale(image->colormap[i].green); 1           *q++=DownScale(image->colormap[i].red); 	         } D         (void) WriteBlob(image,(int) 3*targa_header.colormap_length,#           (char *) targa_colormap); #         FreeMemory(targa_colormap);        }      /*(       Convert MIFF to TGA raster pixels.     */O     count=(unsigned int) (targa_header.bits_per_pixel*targa_header.width) >> 3; O     targa_pixels=(unsigned char *) AllocateMemory(count*sizeof(unsigned char)); /     if (targa_pixels == (unsigned char *) NULL) H       WriterExit(ResourceLimitWarning,"Memory allocation failed",image);.     for (y=(int) (image->rows-1); y >= 0; y--)     { 2       p=GetPixelCache(image,0,y,image->columns,1);$       if (p == (PixelPacket *) NULL)         break;       q=targa_pixels; .       for (x=0; x < (int) image->columns; x++)       { (         if (image->class == PseudoClass)!           *q++=image->indexes[x];          else           { $             *q++=DownScale(p->blue);%             *q++=DownScale(p->green); #             *q++=DownScale(p->red); F             if (image->matte || (image->colorspace == CMYKColorspace))               *q++=p->opacity;           }          p++;       } C       status=WriteBlob(image,q-targa_pixels,(char *) targa_pixels); ,       if (image->previous == (Image *) NULL)'         if (QuantumTick(y,image->rows)) 7           ProgressMonitor(SaveImageText,y,image->rows);      }      FreeMemory(targa_pixels); &     if (image->next == (Image *) NULL)       break;     image=GetNextImage(image);C     ProgressMonitor(SaveImagesText,scene++,GetNumberScenes(image));    } while (image_info->adjoin);    if (image_info->adjoin) -     while (image->previous != (Image *) NULL)        image=image->previous;   CloseBlob(image);    return(True);  } 