 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                        TTTTT  IIIII  FFFFF  FFFFF                           % O %                          T      I    F      F                               % O %                          T      I    FFF    FFF                             % O %                          T      I    F      F                               % O %                          T    IIIII  F      F                               % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   #if defined(HasTIFF) #include "tiffio.h"    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s T I F F                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method IsTIFF returns True if the image format type, identified by the  %  magick string, is TIFF. % - %  The format of the ReadTIFFImage method is:  % 7 %      unsigned int IsTIFF(const unsigned char *magick, # %        const unsigned int length)  % + %  A description of each parameter follows:  % L %    o status:  Method IsTIFF returns True if the image format type is TIFF. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */7 Export unsigned int IsTIFF(const unsigned char *magick,    const unsigned int length) {    if (length < 4)      return(False);1   if ((magick[0] == 0x4D) && (magick[1] == 0x4D)) 3     if ((magick[2] == 0x00) && (magick[3] == 0x2A))        return(True); 9   if (strncmp((char *) magick,"\111\111\052\000",4) == 0)      return(True);    return(False); }  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d T I F F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method ReadTIFFImage reads a Tagged image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadTIFFImage method is:  % 8 %      Image *ReadTIFFImage(const ImageInfo *image_info) % + %  A description of each parameter follows:  % H %    o image:  Method ReadTIFFImage returns a pointer to the image afterJ %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */  / #if defined(__cplusplus) || defined(c_plusplus)  extern "C" { #endif   #if defined(ICCPROFILE) M static unsigned int ReadColorProfile(char *text,long int length,Image *image)  {    register unsigned char     *p;      if (length <= 0)     return(False);   p=(unsigned char *) text; '   if (image->color_profile.length != 0)      { ,       FreeMemory(image->color_profile.info);$       image->color_profile.length=0;     } -   image->color_profile.info=(unsigned char *) @     AllocateMemory((unsigned int) length*sizeof(unsigned char));:   if (image->color_profile.info == (unsigned char *) NULL)     { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL);        return(False);     } %   image->color_profile.length=length; 4   (void) memcpy(image->color_profile.info,p,length);   return(True);  }  #endif  ! #if defined(TIFFTAG_RICHTIFFIPTC) L static unsigned int ReadNewsProfile(char *text,long int length,Image *image,   int type)  {    register unsigned char     *p;      if (length <= 0)     return(False);   p=(unsigned char *) text; &   if (image->iptc_profile.length != 0)     { +       FreeMemory(image->iptc_profile.info); #       image->iptc_profile.length=0; 6       image->iptc_profile.info=(unsigned char *) NULL;     } #   if (type == TIFFTAG_RICHTIFFIPTC)      {        /*         Handle IPTC tag.       */       length*=4;0       image->iptc_profile.info=(unsigned char *)D         AllocateMemory((unsigned int) length*sizeof(unsigned char));=       if (image->iptc_profile.info == (unsigned char *) NULL) 	         { H           MagickWarning(ResourceLimitWarning,"Memory allocation failed",             (char *) NULL);            return(False);	         } (       image->iptc_profile.length=length;7       (void) memcpy(image->iptc_profile.info,p,length);        return(True);      }    /*     Handle PHOTOSHOP tag.    */   while (length > 0)   {  #if defined(GET_ONLY_IPTC_DATA) ,     if (strncmp((char *) p,"8BIM44",6) == 0) #else *     if (strncmp((char *) p,"8BIM",4) == 0) #endif       break;     length-=2;	     p+=2;    }    if (length <= 0)     return(False);&   if (image->iptc_profile.length != 0)     { +       FreeMemory(image->iptc_profile.info); #       image->iptc_profile.length=0;      }  #if defined(GET_ONLY_IPTC_DATA)    /*=     Eat OSType, IPTC ID code, and Pascal string length bytes.    */   p+=6;    length=(*p++);
   if (length)      p+=length;   if ((length & 0x01) == 0) .     p++;  /* align to an even byte boundary */:   length=(p[0] << 24) | (p[1] << 16) | (p[2] << 8) | p[3];   p+=4;  #endif,   image->iptc_profile.info=(unsigned char *)@     AllocateMemory((unsigned int) length*sizeof(unsigned char));9   if (image->iptc_profile.info == (unsigned char *) NULL)      { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL);        return(False);     } $   image->iptc_profile.length=length;3   (void) memcpy(image->iptc_profile.info,p,length);    return(True);  }  #endif  E static void TIFFWarningHandler(const char *module,const char *format,    va_list warning) {    char     message[MaxTextExtent];      register char      *p;      p=message;   if (module != (char *) NULL)     { )       FormatString(p,"%.1024s: ",module);        p+=Extent(message);      } $   (void) vsprintf(p,format,warning);   (void) strcat(p,"."); 7   MagickWarning(DelegateWarning,message,(char *) NULL);  }   / #if defined(__cplusplus) || defined(c_plusplus)  }  #endif  8 Export Image *ReadTIFFImage(const ImageInfo *image_info) {    char
     *text;     float      *chromaticity,     x_resolution,      y_resolution;      Image      *image;      int 
     range,     y;     register int     i,     x;     register PixelPacket     *q;      register unsigned char     *p;      TIFF
     *tiff;     uint16     compress_tag,      extra_samples,     *sample_info;      uint32     length;      unsigned char      *scanline;     unsigned int     height,      method,      status, 
     width;     unsigned short     bits_per_sample,     interlace,     max_sample_value,      min_sample_value, 
     pages,     photometric,     samples_per_pixel,
     units,
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image.    */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);,   if ((image->file == stdin) || image->pipe)     { 
       FILE         *file;  	       int 
         c;         /*6         Copy standard input or pipe to temporary file.       */7       TemporaryFilename((char *) image_info->filename); 7       file=fopen(image_info->filename,WriteBinaryType);         if (file == (FILE *) NULL)A         ReaderExit(FileOpenWarning,"Unable to write file",image);        c=ReadByte(image);       while (c != EOF)       {          (void) putc(c,file);         c=ReadByte(image);       }        (void) fclose(file);:       (void) strcpy(image->filename,image_info->filename);       image->temporary=True;     }    CloseBlob(image); *   TIFFSetErrorHandler(TIFFWarningHandler);,   TIFFSetWarningHandler(TIFFWarningHandler);:   tiff=TIFFOpen(image->filename,ReadBinaryUnbufferedType);   if (tiff == (TIFF *) NULL)<     ReaderExit(FileOpenWarning,"Unable to open file",image);    if (image_info->subrange != 0)/     while (image->scene < image_info->subimage)      {        /*         Skip to next image.        */       image->scene++; %       status=TIFFReadDirectory(tiff);        if (status == False)H         ReaderExit(CorruptImageWarning,"Unable to read subimage",image);     }    do   {      if (image_info->verbose),       TIFFPrintDirectory(tiff,stderr,False);B     TIFFGetFieldDefaulted(tiff,TIFFTAG_COMPRESSION,&compress_tag);1     TIFFGetField(tiff,TIFFTAG_IMAGEWIDTH,&width); 3     TIFFGetField(tiff,TIFFTAG_IMAGELENGTH,&height); @     TIFFGetFieldDefaulted(tiff,TIFFTAG_PLANARCONFIG,&interlace);G     TIFFGetFieldDefaulted(tiff,TIFFTAG_BITSPERSAMPLE,&bits_per_sample); I     TIFFGetFieldDefaulted(tiff,TIFFTAG_MINSAMPLEVALUE,&min_sample_value); I     TIFFGetFieldDefaulted(tiff,TIFFTAG_MAXSAMPLEVALUE,&max_sample_value); A     TIFFGetFieldDefaulted(tiff,TIFFTAG_PHOTOMETRIC,&photometric); -     if (photometric == PHOTOMETRIC_SEPARATED) '       image->colorspace=CMYKColorspace; K     TIFFGetFieldDefaulted(tiff,TIFFTAG_SAMPLESPERPIXEL,&samples_per_pixel); >     TIFFGetFieldDefaulted(tiff,TIFFTAG_RESOLUTIONUNIT,&units);%     x_resolution=image->x_resolution; %     y_resolution=image->y_resolution; B     TIFFGetFieldDefaulted(tiff,TIFFTAG_XRESOLUTION,&x_resolution);B     TIFFGetFieldDefaulted(tiff,TIFFTAG_YRESOLUTION,&y_resolution);%     image->x_resolution=x_resolution; %     image->y_resolution=y_resolution;       chromaticity=(float *) NULL;8     TIFFGetField(tiff,TIFFTAG_WHITEPOINT,&chromaticity);'     if (chromaticity != (float *) NULL)        { :         image->chromaticity.white_point.x=chromaticity[0];:         image->chromaticity.white_point.y=chromaticity[1];       }       chromaticity=(float *) NULL;C     TIFFGetField(tiff,TIFFTAG_PRIMARYCHROMATICITIES,&chromaticity); '     if (chromaticity != (float *) NULL)        { :         image->chromaticity.red_primary.x=chromaticity[0];:         image->chromaticity.red_primary.y=chromaticity[1];<         image->chromaticity.green_primary.x=chromaticity[2];<         image->chromaticity.green_primary.y=chromaticity[3];;         image->chromaticity.blue_primary.x=chromaticity[4]; ;         image->chromaticity.blue_primary.y=chromaticity[5];        } 
     length=0;      text=(char *) NULL;  #if defined(ICCPROFILE) 8     TIFFGetField(tiff,TIFFTAG_ICCPROFILE,&length,&text);(     ReadColorProfile(text,length,image); #endif! #if defined(TIFFTAG_RICHTIFFIPTC) 
     length=0;      text=(char *) NULL;  #if defined(TIFFTAG_PHOTOSHOP)7     TIFFGetField(tiff,TIFFTAG_PHOTOSHOP,&length,&text);      if (length > 0) ;       ReadNewsProfile(text,length,image,TIFFTAG_PHOTOSHOP);  #else :     TIFFGetField(tiff,TIFFTAG_RICHTIFFIPTC,&length,&text);     if (length > 0)        { $         if (TIFFIsByteSwapped(tiff))6           TIFFSwabArrayOfLong((uint32 *) text,length);@         ReadNewsProfile(text,length,image,TIFFTAG_RICHTIFFIPTC);       }  #endif #endif     /*5       Allocate memory for the image and pixel buffer.      */     switch (compress_tag)      { E       case COMPRESSION_NONE: image->compression=NoCompression; break; K       case COMPRESSION_CCITTFAX3: image->compression=FaxCompression; break; N       case COMPRESSION_CCITTFAX4: image->compression=Group4Compression; break;G       case COMPRESSION_JPEG: image->compression=JPEGCompression; break; H       case COMPRESSION_OJPEG: image->compression=JPEGCompression; break;E       case COMPRESSION_LZW: image->compression=LZWCompression; break; I       case COMPRESSION_DEFLATE: image->compression=ZipCompression; break; E       default: image->compression=RunlengthEncodedCompression; break;      }      image->columns=width;      image->rows=height; ,     range=max_sample_value-min_sample_value;7     if ((samples_per_pixel == 1) && !TIFFIsTiled(tiff))        { !         image->class=PseudoClass; +         image->colors=1 << bits_per_sample; )         if (range <= (int) image->colors)             image->colors=range+1;+         if (bits_per_sample > QuantumDepth) !           image->colors=MaxRGB+1; '         image->colormap=(PixelPacket *) <           AllocateMemory(image->colors*sizeof(PixelPacket));4         if (image->colormap == (PixelPacket *) NULL)           {              TIFFClose(tiff);N             ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);           }        }      if (image_info->ping)        {          TIFFClose(tiff);         CloseBlob(image);          return(image);       }      if (units == RESUNIT_INCH)+       image->units=PixelsPerInchResolution; $     if (units == RESUNIT_CENTIMETER)1       image->units=PixelsPerCentimeterResolution; !     image->depth=bits_per_sample;      if (bits_per_sample < 8)       image->depth=8;      value=0;A     TIFFGetFieldDefaulted(tiff,TIFFTAG_PAGENUMBER,&value,&pages);      image->scene=value;      text=(char *) NULL; .     TIFFGetField(tiff,TIFFTAG_PAGENAME,&text);     if (text != (char *) NULL)-       (void) CloneString(&image->label,text);      text=(char *) NULL; 6     TIFFGetField(tiff,TIFFTAG_IMAGEDESCRIPTION,&text);     if (text != (char *) NULL)0       (void) CloneString(&image->comments,text);     if (range < 0)       range=max_sample_value; 
     method=0;      if (samples_per_pixel > 1)       {          method=2; K         if ((samples_per_pixel == 3) && (photometric == PHOTOMETRIC_RGB) && /             (interlace == PLANARCONFIG_CONTIG))            method=1; 0         if (image->colorspace == CMYKColorspace)           method=1;        }      if (TIFFIsTiled(tiff))       method=2;      switch (method)      { 
       case 0:        {          IndexPacket            index;           Quantum            *quantum_scanline;           register Quantum
           *r;   
         /*7           Convert TIFF image to PseudoClass MIFF image. 
         */K         quantum_scanline=(Quantum *) AllocateMemory(width*sizeof(Quantum)); N         scanline=(unsigned char *) AllocateMemory(2*TIFFScanlineSize(tiff)+4);5         if ((quantum_scanline == (Quantum *) NULL) || 1             (scanline == (unsigned char *) NULL))            {              TIFFClose(tiff);N             ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);           } 
         /*           Create colormap.
         */         switch (photometric)	         { &           case PHOTOMETRIC_MINISBLACK:           { 3             for (i=0; i < (int) image->colors; i++) 
             { B               image->colormap[i].red=(MaxRGB*i)/(image->colors-1);D               image->colormap[i].green=(MaxRGB*i)/(image->colors-1);C               image->colormap[i].blue=(MaxRGB*i)/(image->colors-1); 
             }              break;           } &           case PHOTOMETRIC_MINISWHITE:           default:           {              unsigned int               colors;   !             colors=image->colors; 3             for (i=0; i < (int) image->colors; i++) 
             { K               image->colormap[colors-i-1].red=(MaxRGB*i)/(image->colors-1); M               image->colormap[colors-i-1].green=(MaxRGB*i)/(image->colors-1); L               image->colormap[colors-i-1].blue=(MaxRGB*i)/(image->colors-1);
             }              break;           } #           case PHOTOMETRIC_PALETTE:            {              long               range;               unsigned short               *blue_colormap,                *green_colormap,               *red_colormap;  M             TIFFGetField(tiff,TIFFTAG_COLORMAP,&red_colormap,&green_colormap,                &blue_colormap);@             range=256L;  /* might be old style 8-bit colormap */3             for (i=0; i < (int) image->colors; i++) K               if ((red_colormap[i] >= 256) || (green_colormap[i] >= 256) || ,                   (blue_colormap[i] >= 256))                 {                    range=65535L;                    break;                 } 3             for (i=0; i < (int) image->colors; i++) 
             { %               image->colormap[i].red= A                 ((unsigned long) (MaxRGB*red_colormap[i])/range); '               image->colormap[i].green= C                 ((unsigned long) (MaxRGB*green_colormap[i])/range); &               image->colormap[i].blue=B                 ((unsigned long) (MaxRGB*blue_colormap[i])/range);
             }              break;           } 	         } 
         /*5           Convert image to PseudoClass pixel packets. 
         */-         for (y=0; y < (int) image->rows; y++) 	         { 6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;7           TIFFReadScanline(tiff,(char *) scanline,y,0); $           if (bits_per_sample == 16)
             {                unsigned long                  lsb_first;                 /*L                 Ensure the header byte-order is most-significant byte first.               */               lsb_first=1;'               if (*(char *) &lsb_first) 5                 MSBFirstOrderShort((char *) scanline, 3                   (TIFFScanlineSize(tiff) << 1)+4); 
             }            p=scanline;            r=quantum_scanline; "           switch (bits_per_sample)           {              case 1: 
             {                register int                 bit;  2               for (x=0; x < ((int) width-7); x+=8)               { ,                 for (bit=7; bit >= 0; bit--)<                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               } #               if ((width % 8) != 0)                  { B                   for (bit=7; bit >= (int) (8-(width % 8)); bit--)>                     *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                   p++;                 }                break;
             }              case 2: 
             { 2               for (x=0; x < ((int) width-3); x+=4)               { %                 *r++=(*p >> 6) & 0x3; %                 *r++=(*p >> 4) & 0x3; %                 *r++=(*p >> 2) & 0x3;                   *r++=(*p) & 0x3;                 p++;               } #               if ((width % 4) != 0)                  { <                   for (i=3; i >= (int) (4-(width % 4)); i--).                     *r++=(*p >> (i*2)) & 0x03;                   p++;                 }                break;
             }              case 4: 
             { 2               for (x=0; x < ((int) width-1); x+=2)               { %                 *r++=(*p >> 4) & 0xf;                   *r++=(*p) & 0xf;                 p++;               } #               if ((width % 2) != 0) '                 *r++=(*p++ >> 4) & 0xf;                break;
             }              case 8: 
             { -               for (x=0; x < (int) width; x++)                  *r++=(*p++);               break;
             }              case 16:
             { 6               for (x=0; x < (int) image->columns; x++)               {                  *r=(*p++ << 8);                  *r|=(*p++);                  r++;               }                break;
             }              default:               break;           }            /*$             Transfer image scanline.           */           r=quantum_scanline; 2           for (x=0; x < (int) image->columns; x++)           {              index=(*r++); '             if (index >= image->colors) M               ReaderExit(CorruptImageWarning,"invalid colormap index",image); $             image->indexes[x]=index;(             *q++=image->colormap[index];           } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(LoadImageText,y,image->rows); 	         }          FreeMemory(scanline); %         FreeMemory(quantum_scanline);          break;       } 
       case 1:        { 
         /*7           Convert TIFF image to DirectClass MIFF image. 
         */N         scanline=(unsigned char *) AllocateMemory(2*TIFFScanlineSize(tiff)+4);/         if (scanline == (unsigned char *) NULL)            {              TIFFClose(tiff);N             ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);           } G         TIFFGetFieldDefaulted(tiff,TIFFTAG_EXTRASAMPLES,&extra_samples,            &sample_info);0         if (image->colorspace != CMYKColorspace)*           image->matte=extra_samples == 1;-         for (y=0; y < (int) image->rows; y++) 	         { 6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;7           TIFFReadScanline(tiff,(char *) scanline,y,0); $           if (bits_per_sample == 16)
             {                unsigned long                  lsb_first;                 /*L                 Ensure the header byte-order is most-significant byte first.               */               lsb_first=1;'               if (*(char *) &lsb_first) 5                 MSBFirstOrderShort((char *) scanline, 3                   (TIFFScanlineSize(tiff) << 1)+4); 
             } #           if (bits_per_sample == 4) 
             { $               register unsigned char                 *r;   +               width=TIFFScanlineSize(tiff); !               p=scanline+width-1; (               r=scanline+(width << 1)-1;-               for (x=0; x < (int) width; x++)                { '                 *r--=((*p) & 0xf) << 4; ,                 *r--=((*p >> 4) & 0xf) << 4;                 p--;               } 
             }            if (!image->matte)6             ReadPixelCache(image,RGBQuantum,scanline);           else7             ReadPixelCache(image,RGBAQuantum,scanline); %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(LoadImageText,y,image->rows); 	         }          FreeMemory(scanline);          break;       } 
       case 2:        default:       {          register uint32 
           *p,            *pixels;  
         /*7           Convert TIFF image to DirectClass MIFF image. 
         */G         TIFFGetFieldDefaulted(tiff,TIFFTAG_EXTRASAMPLES,&extra_samples,            &sample_info);         image->matte= O           ((extra_samples == 1) && (sample_info[0] == EXTRASAMPLE_ASSOCALPHA)); E         pixels=(uint32 *) AllocateMemory((image->columns*image->rows+ *           image->columns)*sizeof(uint32));&         if (pixels == (uint32 *) NULL)           {              TIFFClose(tiff);N             ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);           } K         status=TIFFReadRGBAImage(tiff,image->columns,image->rows,pixels,0);          if (status == False)           {              FreeMemory(pixels);              TIFFClose(tiff);I             ReaderExit(CorruptImageWarning,"Unable to read image",image);            } 
         /*5           Convert image to DirectClass pixel packets. 
         */*         for (y=image->rows-1; y >= 0; y--)	         { $           p=pixels+y*image->columns;6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           { )             q->red=UpScale(TIFFGetR(*p)); +             q->green=UpScale(TIFFGetG(*p)); *             q->blue=UpScale(TIFFGetB(*p));             if (image->matte) /               q->opacity=UpScale(TIFFGetA(*p));              p++;             q++;           } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) I               ProgressMonitor(LoadImageText,image->rows-y-1,image->rows); 	         }          FreeMemory(pixels);          break;       }      }      /*       Proceed to next image.     */"     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;#     status=TIFFReadDirectory(tiff);      if (status == True)        { 
         /*(           Allocate next image structure.
         */,         AllocateNextImage(image_info,image);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            }          image=image->next;C         ProgressMonitor(LoadImageText,image->scene-1,image->scene);        }    } while (status == True);    TIFFClose(tiff);   if (image->temporary)      { %       (void) remove(image->filename);        image->temporary=False;      } +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseBlob(image);    return(image); }  #else 8 Export Image *ReadTIFFImage(const ImageInfo *image_info) { G   MagickWarning(MissingDelegateWarning,"TIFF library is not available",      image_info->filename);   return((Image *) NULL);  }  #endif   #if defined(HasTIFF) /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e T I F F I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method WriteTIFFImage writes an image in the Tagged image file format.  % . %  The format of the WriteTIFFImage method is: % L %      unsigned int WriteTIFFImage(const ImageInfo *image_info,Image *image) % + %  A description of each parameter follows:  % J %    o status:  Method WriteTIFFImage return True if the image is written.I %      False is returned is there is of a memory shortage or if the image ) %      file cannot be opened for writing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */  ! #if defined(TIFFTAG_RICHTIFFIPTC) > static void WriteNewsProfile(TIFF *tiff,int type,Image *image) {    register int     i;     unsigned char 
     *profile;      unsigned int     length,      roundup;  #   if (type == TIFFTAG_RICHTIFFIPTC)      {        /*(         Handle TIFFTAG_RICHTIFFIPTC tag.       */(       length=image->iptc_profile.length;G       roundup=4-(length & 0x03); /* round up for long word alignment */        profile=(unsigned char *) ?         AllocateMemory((length+roundup)*sizeof(unsigned char)); ?       if ((length == 0) || (profile == (unsigned char *) NULL))          return; F       (void) memcpy((char *) profile,image->iptc_profile.info,length);!       for (i=0; i < roundup; i++)           profile[length + i] = 0;4       length=(image->iptc_profile.length+roundup)/4;"       if (TIFFIsByteSwapped(tiff))7         TIFFSwabArrayOfLong((uint32 *) profile,length); I       TIFFSetField(tiff,type,(uint32) (length+roundup),(void *) profile);        FreeMemory(profile);
       return;      }    /*!     Handle TIFFTAG_PHOTOSHOP tag.    */ #if defined(GET_ONLY_IPTC_DATA) $   length=image->iptc_profile.length;7   roundup=(length & 0x01); /* round up for Photoshop */    profile=(unsigned char *) >     AllocateMemory((length+roundup+12)*sizeof(unsigned char));;   if ((length == 0) || (profile == (unsigned char *) NULL)) 7     (void) memcpy((char *) profile,"8BIM\04\04\0\0",8); #   profile[8]=(length >> 24) & 0xff; #   profile[9]=(length >> 16) & 0xff; #   profile[10]=(length >> 8) & 0xff;    profile[11]=length & 0xff;   for (i=0; i < length; i++).     profile[i+12]=image->iptc_profile.info[i];   if (roundup)!     profile[length+roundup+11]=0; F   TIFFSetField(tiff,type,(uint32) length+roundup+12,(void *) profile); #else $   length=image->iptc_profile.length;   if (length == 0)     return; 7   roundup=(length & 0x01); /* round up for Photoshop */    profile=(unsigned char *) ;     AllocateMemory((length+roundup)*sizeof(unsigned char)); (   if (profile == (unsigned char *) NULL)     return; B   (void) memcpy((char *) profile,image->iptc_profile.info,length);   if (roundup)     profile[length+roundup]=0;C   TIFFSetField(tiff,type,(uint32) length+roundup,(void *) profile);  #endif   FreeMemory(profile); }  #endif  B static int TIFFWritePixels(TIFF *tiff,tdata_t scanline,uint32 row,    tsample_t sample,Image *image) {    int      bytes_per_pixel,     number_tiles,      status,      tile_width;      register int     i,     j,     k;     static unsigned char(     *scanlines = (unsigned char *) NULL,*     *tile_pixels = (unsigned char *) NULL;     if (!TIFFIsTiled(tiff)) 8     return(TIFFWriteScanline(tiff,scanline,row,sample));*   if (scanlines == (unsigned char *) NULL)     scanlines=(unsigned char *) E       AllocateMemory(image->tile_info.height*TIFFScanlineSize(tiff)); *   if (scanlines == (unsigned char *) NULL)     return(-1); ,   if (tile_pixels == (unsigned char *) NULL)D     tile_pixels=(unsigned char *)AllocateMemory(TIFFTileSize(tiff));,   if (tile_pixels == (unsigned char *) NULL)     return(-1);    /*"     Fill scanlines to tile height.   */;   i=(row % image->tile_info.height)*TIFFScanlineSize(tiff); O   (void) memcpy((char *) scanlines+i,(char *) scanline,TIFFScanlineSize(tiff)); I   if (((row % image->tile_info.height) != (image->tile_info.height-1)) &&        (row != image->rows-1))      return(0);   /*     Write tile to TIFF image.    */   status=0;    bytes_per_pixel=H     TIFFTileSize(tiff)/(image->tile_info.height*image->tile_info.width);   number_tiles= F     (image->columns+image->tile_info.width-1)/image->tile_info.height;"   for (i=0; i < number_tiles; i++)   { ,     tile_width=(i == (int) number_tiles-1) ?I       image->columns-(i*image->tile_info.width) : image->tile_info.width; A     for (j=0; j < (int) ((row % image->tile_info.height)+1); j++) $       for (k=0; k < tile_width; k++)       {          register unsigned char
           *p, 
           *q;   K         p=scanlines+(j*TIFFScanlineSize(tiff)+(i*image->tile_info.width+k)*            bytes_per_pixel);          q=tile_pixels+M           (j*(TIFFTileSize(tiff)/image->tile_info.height)+k*bytes_per_pixel); +         (void) memcpy(q,p,bytes_per_pixel);        } J       status=TIFFWriteTile(tiff,tile_pixels,i*image->tile_info.width,(row/C         image->tile_info.height)*image->tile_info.height,0,sample);        if (status < 0)          break;   }    if (row == (image->rows-1))      {        /*         Free memory resources.       */       FreeMemory(scanlines);'       scanlines=(unsigned char *) NULL;        FreeMemory(tile_pixels);)       tile_pixels=(unsigned char *) NULL;      }    return(status);  }   L Export unsigned int WriteTIFFImage(const ImageInfo *image_info,Image *image) { " #if !defined(TIFFDefaultStripSize)M #define TIFFDefaultStripSize(tiff,request)  ((8*1024)/TIFFScanlineSize(tiff))  #endif     Image      encode_image;      int      y;     register int     i,     x;     register unsigned char     *q;      TIFF
     *tiff;     uint16     compress_tag,      photometric;     unsigned char      *scanline;     unsigned int
     scene,     status;      unsigned long      strip_size;   4   if (Latin1Compare(image_info->magick,"PTIF") == 0)     {        Image          *next_image,         *pyramid_image;          unsigned int         height,          width;         /*"         Pyramid encode TIFF image.       */#       pyramid_image=(Image *) NULL; &       if (image->tile_info.width == 0)"         image->tile_info.width=64;'       if (image->tile_info.height == 0) #         image->tile_info.height=64;        width=image->columns;        height=image->rows;        do       { 1         next_image=ZoomImage(image,width,height); )         if (next_image == (Image *) NULL) M           WriterExit(FileOpenWarning,"Unable to pyramid encode image",image); ,         if (pyramid_image == (Image *) NULL)#           pyramid_image=next_image;          else           {              register Image               *p;                /*1               Link image into pyramid image list.              */H             for (p=pyramid_image; p->next != (Image *) NULL; p=p->next);#             next_image->previous=p;              p->next=next_image;            }          width=(width+1)/2;         height=(height+1)/2;*         if ((width == 0) || (height == 0))           break;7       } while (((2*width) >= image->tile_info.width) || 8                ((2*height) >= image->tile_info.height));       image=pyramid_image;     }    /*     Open TIFF file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);.   if ((image->file != stdout) && !image->pipe)#     (void) remove(image->filename);    else     {        /*8         Write standard output or pipe to temporary file.       */       encode_image=(*image);)       TemporaryFilename(image->filename);        image->temporary=True;     }    CloseBlob(image); 1   tiff=TIFFOpen(image->filename,WriteBinaryType);    if (tiff == (TIFF *) NULL)     return(False);   image->status=0;
   scene=0;   do   {      /*       Initialize TIFF fields.      */6     if (Latin1Compare(image_info->magick,"PTIF") == 0),       if (image->previous != (Image *) NULL)E         TIFFSetField(tiff,TIFFTAG_SUBFILETYPE,FILETYPE_REDUCEDIMAGE); @     TIFFSetField(tiff,TIFFTAG_IMAGELENGTH,(uint32) image->rows);B     TIFFSetField(tiff,TIFFTAG_IMAGEWIDTH,(uint32) image->columns);/     TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,8); "     compress_tag=COMPRESSION_NONE;6     if ((image_info->compression == FaxCompression) ||7         (image_info->compression == Group4Compression)) $       if (!IsMonochromeImage(image))	         {            QuantizeInfo             quantize_info;  *           GetQuantizeInfo(&quantize_info);(           quantize_info.number_colors=2;2           quantize_info.dither=image_info->dither;2           quantize_info.colorspace=GRAYColorspace;5           (void) QuantizeImage(&quantize_info,image); 	         }      switch (image->compression)      {        case FaxCompression:       { %         if (IsMonochromeImage(image)) -           compress_tag=COMPRESSION_CCITTFAX3;          break;       }        case Group4Compression:        { %         if (IsMonochromeImage(image)) -           compress_tag=COMPRESSION_CCITTFAX4;          break;       } A       case JPEGCompression: compress_tag=COMPRESSION_JPEG; break; ?       case LZWCompression: compress_tag=COMPRESSION_LZW; break; '       case RunlengthEncodedCompression: 1         compress_tag=COMPRESSION_PACKBITS; break; C       case ZipCompression: compress_tag=COMPRESSION_DEFLATE; break; 4       default: compress_tag=COMPRESSION_NONE; break;     } ;     if (((image_info->colorspace == UndefinedColorspace) && 2          (image->colorspace == CMYKColorspace)) ||4          (image_info->colorspace == CMYKColorspace))       { *         photometric=PHOTOMETRIC_SEPARATED;         if (image->depth > 8) 6           TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,16);5         TIFFSetField(tiff,TIFFTAG_SAMPLESPERPIXEL,4); 6         TIFFSetField(tiff,TIFFTAG_INKSET,INKSET_CMYK);       }      else>       if ((Latin1Compare(image_info->magick,"TIFF24") == 0) ||/           (compress_tag == COMPRESSION_JPEG) || 9           (!IsPseudoClass(image) && !IsGrayImage(image))) 	         {            /*#             Full color TIFF raster.            */1           TransformRGBImage(image,RGBColorspace); &           photometric=PHOTOMETRIC_RGB;           if (image->depth > 8) 8             TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,16);L           TIFFSetField(tiff,TIFFTAG_SAMPLESPERPIXEL,(image->matte ? 4 : 3));           if (image->matte) 
             {                uint16                 extra_samples,                 sample_info[1];                  /*)                 TIFF has a matte channel.                */               extra_samples=1;4               sample_info[0]=EXTRASAMPLE_ASSOCALPHA;C               TIFFSetField(tiff,TIFFTAG_EXTRASAMPLES,extra_samples,                  &sample_info);
             } 	         } 
       else	         {            /*$             Colormapped TIFF raster.           */1           TransformRGBImage(image,RGBColorspace); "           if (image->colors > 256)8             TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,16);7           TIFFSetField(tiff,TIFFTAG_SAMPLESPERPIXEL,1); *           photometric=PHOTOMETRIC_PALETTE;!           if (image->colors <= 2) 
             { +               if (IsMonochromeImage(image)) 3                 photometric=PHOTOMETRIC_MINISWHITE; 9               TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,1); 1               compress_tag=COMPRESSION_CCITTFAX4; 
             }            else#             if (IsGrayImage(image))                { %                 if (image->depth > 8) >                   TIFFSetField(tiff,TIFFTAG_BITSPERSAMPLE,16);3                 photometric=PHOTOMETRIC_MINISBLACK;                } 	         } $     switch (image_info->compression)     { ?       case NoCompression: compress_tag=COMPRESSION_NONE; break; E       case FaxCompression: compress_tag=COMPRESSION_CCITTFAX3; break; H       case Group4Compression: compress_tag=COMPRESSION_CCITTFAX4; break;A       case JPEGCompression: compress_tag=COMPRESSION_JPEG; break; ?       case LZWCompression: compress_tag=COMPRESSION_LZW; break; '       case RunlengthEncodedCompression: 1         compress_tag=COMPRESSION_PACKBITS; break; C       case ZipCompression: compress_tag=COMPRESSION_DEFLATE; break;        default: break;      } 7     TIFFSetField(tiff,TIFFTAG_PHOTOMETRIC,photometric); 8     TIFFSetField(tiff,TIFFTAG_COMPRESSION,compress_tag);;     TIFFSetField(tiff,TIFFTAG_FILLORDER,FILLORDER_MSB2LSB); ?     TIFFSetField(tiff,TIFFTAG_ORIENTATION,ORIENTATION_TOPLEFT); @     TIFFSetField(tiff,TIFFTAG_PLANARCONFIG,PLANARCONFIG_CONTIG);'     if (photometric == PHOTOMETRIC_RGB) 6       if ((image_info->interlace == PlaneInterlace) ||8           (image_info->interlace == PartitionInterlace))F         TIFFSetField(tiff,TIFFTAG_PLANARCONFIG,PLANARCONFIG_SEPARATE);4     strip_size=Max(TIFFDefaultStripSize(tiff,-1),1);)     if (compress_tag == COMPRESSION_JPEG) N       TIFFSetField(tiff,TIFFTAG_ROWSPERSTRIP,strip_size+(8-(strip_size % 8)));     else0       if (compress_tag == COMPRESSION_CCITTFAX4)<         TIFFSetField(tiff,TIFFTAG_ROWSPERSTRIP,image->rows);
       else;         TIFFSetField(tiff,TIFFTAG_ROWSPERSTRIP,strip_size); A     if ((image->x_resolution != 0) && (image->y_resolution != 0))        {          unsigned short           units;  
         /*           Set image resolution. 
         */         units=RESUNIT_NONE; 4         if (image->units == PixelsPerInchResolution)           units=RESUNIT_INCH; :         if (image->units == PixelsPerCentimeterResolution)#           units=RESUNIT_CENTIMETER; A         TIFFSetField(tiff,TIFFTAG_RESOLUTIONUNIT,(uint16) units); C         TIFFSetField(tiff,TIFFTAG_XRESOLUTION,image->x_resolution); C         TIFFSetField(tiff,TIFFTAG_YRESOLUTION,image->y_resolution);        } 1     if (image->chromaticity.white_point.x != 0.0)        { 
         float            chromaticity[6];  
         /*!           Set image chromaticity. 
         */:         chromaticity[0]=image->chromaticity.red_primary.x;:         chromaticity[1]=image->chromaticity.red_primary.y;<         chromaticity[2]=image->chromaticity.green_primary.x;<         chromaticity[3]=image->chromaticity.green_primary.y;;         chromaticity[4]=image->chromaticity.blue_primary.x; ;         chromaticity[5]=image->chromaticity.blue_primary.y; F         TIFFSetField(tiff,TIFFTAG_PRIMARYCHROMATICITIES,chromaticity);:         chromaticity[0]=image->chromaticity.white_point.x;:         chromaticity[1]=image->chromaticity.white_point.y;;         TIFFSetField(tiff,TIFFTAG_WHITEPOINT,chromaticity);        }  #if defined(ICCPROFILE) (     if (image->color_profile.length > 0)P       TIFFSetField(tiff,TIFFTAG_ICCPROFILE,(uint32) image->color_profile.length,,         (void *) image->color_profile.info); #endif! #if defined(TIFFTAG_RICHTIFFIPTC)  #if defined(TIFFTAG_PHOTOSHOP)'     if (image->iptc_profile.length > 0) 5       WriteNewsProfile(tiff,TIFFTAG_PHOTOSHOP,image);  #else '     if (image->iptc_profile.length > 0) 8       WriteNewsProfile(tiff,TIFFTAG_RICHTIFFIPTC,image); #endif #endif<     TIFFSetField(tiff,TIFFTAG_DOCUMENTNAME,image->filename);6     TIFFSetField(tiff,TIFFTAG_SOFTWARE,MagickVersion);#     if (GetNumberScenes(image) > 1)        { =         TIFFSetField(tiff,TIFFTAG_SUBFILETYPE,FILETYPE_PAGE); K         TIFFSetField(tiff,TIFFTAG_PAGENUMBER,(unsigned short) image->scene, "           GetNumberScenes(image));       } &     if (image->label != (char *) NULL)7       TIFFSetField(tiff,TIFFTAG_PAGENAME,image->label); )     if (image->comments != (char *) NULL) B       TIFFSetField(tiff,TIFFTAG_IMAGEDESCRIPTION,image->comments);     /*       Write image scanlines.     */J     scanline=(unsigned char *) AllocateMemory(2*TIFFScanlineSize(tiff)+4);+     if (scanline == (unsigned char *) NULL) H       WriterExit(ResourceLimitWarning,"Memory allocation failed",image);     switch (photometric)     {        case PHOTOMETRIC_RGB:        { 
         /*           RGB TIFF image. 
         */&         switch (image_info->interlace)	         {            case NoInterlace:            default:           { 1             for (y=0; y < (int) image->rows; y++) 
             { =               if (!GetPixelCache(image,0,y,image->columns,1))                  break;                if (!image->matte);                 WritePixelCache(image,RGBQuantum,scanline);                else<                 WritePixelCache(image,RGBAQuantum,scanline);H               if (TIFFWritePixels(tiff,(char *) scanline,y,0,image) < 0)                 break;4               if (image->previous == (Image *) NULL)/                 if (QuantumTick(y,image->rows)) ?                   ProgressMonitor(SaveImageText,y,image->rows); 
             }              break;           }            case PlaneInterlace:"           case PartitionInterlace:           {              /*=               Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...              */1             for (y=0; y < (int) image->rows; y++) 
             { =               if (!GetPixelCache(image,0,y,image->columns,1))                  break;9               WritePixelCache(image,RedQuantum,scanline); H               if (TIFFWritePixels(tiff,(char *) scanline,y,0,image) < 0)                 break;
             } 3             ProgressMonitor(SaveImageText,100,400); 1             for (y=0; y < (int) image->rows; y++) 
             { =               if (!GetPixelCache(image,0,y,image->columns,1))                  break;;               WritePixelCache(image,GreenQuantum,scanline); H               if (TIFFWritePixels(tiff,(char *) scanline,y,1,image) < 0)                 break;
             } 3             ProgressMonitor(SaveImageText,200,400); 1             for (y=0; y < (int) image->rows; y++) 
             { =               if (!GetPixelCache(image,0,y,image->columns,1))                  break;:               WritePixelCache(image,BlueQuantum,scanline);H               if (TIFFWritePixels(tiff,(char *) scanline,y,2,image) < 0)                 break;
             } 3             ProgressMonitor(SaveImageText,300,400);              if (image->matte) 3               for (y=0; y < (int) image->rows; y++)                { ?                 if (!GetPixelCache(image,0,y,image->columns,1))                    break;?                 WritePixelCache(image,OpacityQuantum,scanline); J                 if (TIFFWritePixels(tiff,(char *) scanline,y,3,image) < 0)                   break;               } 3             ProgressMonitor(SaveImageText,400,400);              break;           } 	         }          break;       } !       case PHOTOMETRIC_SEPARATED:        { 
         /*           CMYK TIFF image.
         */0         if (image->colorspace != CMYKColorspace)2           RGBTransformImage(image,CMYKColorspace);-         for (y=0; y < (int) image->rows; y++) 	         { 9           if (!GetPixelCache(image,0,y,image->columns,1))              break;6           WritePixelCache(image,RGBAQuantum,scanline);D           if (TIFFWritePixels(tiff,(char *) scanline,y,0,image) < 0)             break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(SaveImageText,y,image->rows); 	         }          break;       }        case PHOTOMETRIC_PALETTE:        {          unsigned short           *blue,           *green,            *red;   
         /*!           Colormapped TIFF image. 
         */         blue=(unsigned short *) E           AllocateMemory((1 << image->depth)*sizeof(unsigned short));           green=(unsigned short *)E           AllocateMemory((1 << image->depth)*sizeof(unsigned short));          red=(unsigned short *)E           AllocateMemory((1 << image->depth)*sizeof(unsigned short)); 0         if ((blue == (unsigned short *) NULL) ||1             (green == (unsigned short *) NULL) || -             (red == (unsigned short *) NULL)) L           WriterExit(ResourceLimitWarning,"Memory allocation failed",image);
         /*#           Initialize TIFF colormap. 
         *//         for (i=0; i < (int) image->colors; i++) 	         { J           red[i]=((unsigned long) (65535L*image->colormap[i].red)/MaxRGB);N           green[i]=((unsigned long) (65535L*image->colormap[i].green)/MaxRGB);L           blue[i]=((unsigned long) (65535L*image->colormap[i].blue)/MaxRGB);	         } -         for ( ; i < (1 << image->depth); i++) 	         {            red[i]=0;            green[i]=0;            blue[i]=0;	         } ;         TIFFSetField(tiff,TIFFTAG_COLORMAP,red,green,blue);          FreeMemory(red);         FreeMemory(green);         FreeMemory(blue);        }        default:       {          register unsigned char           bit,           byte,            polarity;            if (image->colors > 2)           {              /*L               Convert PseudoClass packets to contiguous grayscale scanlines.             */1             for (y=0; y < (int) image->rows; y++) 
             { =               if (!GetPixelCache(image,0,y,image->columns,1))                  break;5               if (photometric == PHOTOMETRIC_PALETTE) =                 WritePixelCache(image,IndexQuantum,scanline);                else<                 WritePixelCache(image,GrayQuantum,scanline);H               if (TIFFWritePixels(tiff,(char *) scanline,y,0,image) < 0)                 break;4               if (image->previous == (Image *) NULL)/                 if (QuantumTick(y,image->rows)) ?                   ProgressMonitor(SaveImageText,y,image->rows); 
             }              break;           } 
         /*I           Convert PseudoClass packets to contiguous monochrome scanlines. 
         */?         polarity=Intensity(image->colormap[0]) > (MaxRGB >> 1); /         if (photometric == PHOTOMETRIC_PALETTE)            polarity=1;          else!           if (image->colors == 2) 
             {                polarity= N                 Intensity(image->colormap[0]) > Intensity(image->colormap[1]);8               if (photometric == PHOTOMETRIC_MINISBLACK)#                 polarity=!polarity; 
             } -         for (y=0; y < (int) image->rows; y++) 	         { 9           if (!GetPixelCache(image,0,y,image->columns,1))              break;           bit=0;           byte=0;            q=scanline; 2           for (x=0; x < (int) image->columns; x++)           {              byte<<=1; .             if (image->indexes[x] == polarity)               byte|=0x01;              bit++;             if (bit == 8)                {                  *q++=byte;                 bit=0;                 byte=0;                }            }            if (bit != 0) !             *q++=byte << (8-bit); D           if (TIFFWritePixels(tiff,(char *) scanline,y,0,image) < 0)             break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(SaveImageText,y,image->rows); 	         }          break;       }      }      FreeMemory(scanline); $     if (image_info->verbose == True),       TIFFPrintDirectory(tiff,stderr,False);     TIFFWriteDirectory(tiff); &     if (image->next == (Image *) NULL)       break;     image=GetNextImage(image);C     ProgressMonitor(SaveImagesText,scene++,GetNumberScenes(image));    } while (image_info->adjoin); +   while (image->previous != (Image *) NULL)      image=image->previous;   TIFFClose(tiff);   if (image->temporary)      { 
       FILE         *file;  	       int 
         c;         /*7         Copy temporary file to standard output or pipe.        */1       file=fopen(image->filename,ReadBinaryType);         if (file == (FILE *) NULL)@         WriterExit(FileOpenWarning,"Unable to open file",image);2       for (c=fgetc(file); c != EOF; c=fgetc(file)))         (void) putc(c,encode_image.file);        (void) fclose(file);%       (void) remove(image->filename);        image->temporary=False;        CloseBlob(&encode_image);      } 4   if (Latin1Compare(image_info->magick,"PTIF") == 0)     DestroyImages(image);    return(True);  }  #else L Export unsigned int WriteTIFFImage(const ImageInfo *image_info,Image *image) { G   MagickWarning(MissingDelegateWarning,"TIFF library is not available",      image->filename);    return(False); }  #endif