 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                        TTTTT  IIIII  L      EEEEE                           % O %                          T      I    L      E                               % O %                          T      I    L      EEE                             % O %                          T      I    L      E                               % O %                          T    IIIII  LLLLL  EEEEE                           % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d T I L E I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method ReadTILEImage tiles a texture on an image.  It allocates theL %  memory necessary for the new Image structure and returns a pointer to the
 %  new image.  % - %  The format of the ReadTILEImage method is:  % 8 %      Image *ReadTILEImage(const ImageInfo *image_info) % + %  A description of each parameter follows:  % H %    o image:  Method ReadTILEImage returns a pointer to the image afterJ %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 Export Image *ReadTILEImage(const ImageInfo *image_info) {    Image      *cloned_image,     *image,      *tiled_image;      ImageInfo      *local_info;     int      y;     register int     x;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL); 2   if ((image->columns == 0) || (image->rows == 0))>     ReaderExit(OptionWarning,"Must specify image size",image);$   if (*image_info->filename == '\0')A     ReaderExit(OptionWarning,"must specify an image name",image);    /*     Initialize Image structure.    */(   local_info=CloneImageInfo(image_info);'   if (local_info == (ImageInfo *) NULL) F     ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);   *local_info->magick='\0'; $   tiled_image=ReadImage(local_info);   DestroyImageInfo(local_info); $   if (tiled_image == (Image *) NULL)     return((Image *) NULL); G   cloned_image=CloneImage(tiled_image,image->columns,image->rows,True);    DestroyImage(image);%   if (cloned_image == (Image *) NULL) L     ReaderExit(ResourceLimitWarning,"Memory allocation failed",tiled_image);   image=cloned_image; 6   (void) strcpy(image->filename,image_info->filename);   /*     Tile texture onto image.   */8   for (y=0; y < (int) image->rows; y+=tiled_image->rows)   { @     for (x=0; x < (int) image->columns; x+=tiled_image->columns)?       CompositeImage(image,ReplaceCompositeOp,tiled_image,x,y); 1     ProgressMonitor(LoadImageText,y,image->rows);    }    DestroyImage(tiled_image);   return(image); } 