 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            U   U  IIIII  L                                  % O %                            U   U    I    L                                  % O %                            U   U    I    L                                  % O %                            U   U    I    L                                  % O %                             UUU   IIIII  LLLLL                              % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d U I L I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Method ReadUILImage reads a X-Motif UIL table and returns it.  ItK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % , %  The format of the ReadUILImage method is: % 7 %      Image *ReadUILImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadUILImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadUILImage(const ImageInfo *image_info)  { @   MagickWarning(MissingDelegateWarning,"Cannot read UIL images",     image_info->filename);   return((Image *) NULL);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e U I L I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Procedure WriteUILImage writes an image to a file in the X-Motif UIL table 
 %  format. % - %  The format of the WriteUILImage method is:  % K %      unsigned int WriteUILImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % H %    o status: Method WriteUILImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K Export unsigned int WriteUILImage(const ImageInfo *image_info,Image *image)  {  #define MaxCixels  92      static const char I     Cixel[MaxCixels+1] = " .XoO+@#$%&*=-;:>,<1234567890qwertyuipasdfghjk" J                          "lzxcvbnmMNBVCZASDFGHJKLPIUYTREWQ!~^/()_`'][{}|";     char     buffer[MaxTextExtent],     name[MaxTextExtent],     symbol[MaxTextExtent];     double     min_distance;      int 
     distance,      j,     k,     y;     long	     mean;      register double      distance_squared;      register int     i,     x;     register PixelPacket     *p;      register const ColorlistInfo     *q;      unsigned int     characters_per_pixel,      colors,      status,      transparent;     /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);)   TransformRGBImage(image,RGBColorspace);    transparent=False;   i=0;"   if (image->class == PseudoClass)     colors=image->colors;    else     {        QuantizeInfo         quantize_info;         unsigned char          *matte_image;          /*1         Convert DirectClass to PseudoClass image.        */)       matte_image=(unsigned char *) NULL;        if (image->matte) 	         {            /*+             Map all the transparent pixels.            */'           matte_image=(unsigned char *) M             AllocateMemory(image->columns*image->rows*sizeof(unsigned char)); 4           if (matte_image == (unsigned char *) NULL)N             WriterExit(ResourceLimitWarning,"Memory allocation failed",image);/           for (y=0; y < (int) image->rows; y++)            { 8             p=GetPixelCache(image,0,y,image->columns,1);*             if (p == (PixelPacket *) NULL)               break;4             for (x=0; x < (int) image->columns; x++)
             { 7               matte_image[i]=p->opacity == Transparent; !               if (matte_image[i]) !                 transparent=True;                i++;               p++;
             }            } 	         } &       GetQuantizeInfo(&quantize_info);.       quantize_info.dither=image_info->dither;1       (void) QuantizeImage(&quantize_info,image);        colors=image->colors;        if (transparent)	         {            colors++; /           for (y=0; y < (int) image->rows; y++)            { ;             if (!GetPixelCache(image,0,y,image->columns,1))                break;4             for (x=0; x < (int) image->columns; x++)
             { !               if (matte_image[i]) 0                 image->indexes[x]=image->colors;               p++;
             }            } 	         } 0       if (matte_image != (unsigned char *) NULL)          FreeMemory(matte_image);     }    /*$     Compute the character per pixel.   */   characters_per_pixel=1; 3   for (k=MaxCixels; (int) colors > k; k*=MaxCixels)      characters_per_pixel++;    /*     UIL header.    */&   (void) strcpy(buffer,"/* UIL */\n");0   (void) WriteBlob(image,strlen(buffer),buffer);?   (void) sprintf(buffer,"value\n  %.1024s_ct : color_table(\n", #     BaseFilename(image->filename)); 0   (void) WriteBlob(image,strlen(buffer),buffer);"   for (i=0; i < (int) colors; i++)   {      PixelPacket 	       *p;        /*       Define UIL color.      */     min_distance=0;      p=image->colormap+i;7     for (q=XPMColorlist; q->name != (char *) NULL; q++)      { (       mean=(DownScale(p->red)+q->red)/2;.       distance=DownScale(p->red)-(int) q->red;@       distance_squared=(2.0*256.0+mean)*distance*distance/256.0;2       distance=DownScale(p->green)-(int) q->green;.       distance_squared+=4.0*distance*distance;0       distance=DownScale(p->blue)-(int) q->blue;E       distance_squared+=(3.0*256.0-1.0-mean)*distance*distance/256.0; D       if ((q == XPMColorlist) || (distance_squared <= min_distance))	         { (           min_distance=distance_squared;&           (void) strcpy(name,q->name);	         }      }      if (transparent)        if (i == (int) (colors-1))#         (void) strcpy(name,"None");      /*       Write UIL color.     */     k=i % MaxCixels;     symbol[0]=Cixel[k]; 2     for (j=1; j < (int) characters_per_pixel; j++)     { &       k=((i-k)/MaxCixels) % MaxCixels;       symbol[j]=Cixel[k];      }      symbol[j]='\0'; (     if (Latin1Compare(name,"None") == 0)G       (void) sprintf(buffer,"    background color = '%.1024s'",symbol);      elseG       (void) sprintf(buffer,"    color('%.1024s',%.1024s) = '%.1024s'", J         name,Intensity(*p) < ((MaxRGB+1)/2) ? "background" : "foreground",         symbol);2     (void) WriteBlob(image,strlen(buffer),buffer);N     (void) sprintf(buffer,"%.1024s",(i == (int) (colors-1) ? ");\n" : ",\n"));2     (void) WriteBlob(image,strlen(buffer),buffer);   }    /*     Define UIL pixels.   */   (void) sprintf(buffer,8     "  %.1024s_icon : icon(color_table = %.1024s_ct,\n",A     BaseFilename(image->filename),BaseFilename(image->filename)); 0   (void) WriteBlob(image,strlen(buffer),buffer);'   for (y=0; y < (int) image->rows; y++)    { 0     p=GetPixelCache(image,0,y,image->columns,1);"     if (p == (PixelPacket *) NULL)       break;#     (void) strcpy(buffer,"    \""); 2     (void) WriteBlob(image,strlen(buffer),buffer);,     for (x=0; x < (int) image->columns; x++)     { &       k=image->indexes[x] % MaxCixels;       symbol[0]=Cixel[k]; 4       for (j=1; j < (int) characters_per_pixel; j++)       { >         k=(((int) image->indexes[x]-k)/MaxCixels) % MaxCixels;         symbol[j]=Cixel[k];        }        symbol[j]='\0'; .       (void) sprintf(buffer,"%.1024s",symbol);4       (void) WriteBlob(image,strlen(buffer),buffer);
       p++;     } (     (void) sprintf(buffer,"\"%.1024s\n",1       (y == (int) (image->rows-1) ? ");" : ",")); 2     (void) WriteBlob(image,strlen(buffer),buffer);#     if (QuantumTick(y,image->rows)) 3       ProgressMonitor(SaveImageText,y,image->rows);    }    CloseBlob(image);    return(True);  } 