 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                        U   U  Y   Y  V   V  Y   Y                           % O %                        U   U   Y Y   V   V   Y Y                            % O %                        U   U    Y    V   V    Y                             % O %                        U   U    Y     V V     Y                             % O %                         UUU     Y      V      Y                             % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d U Y V Y I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method ReadUYVYImage reads an image in the UYVY format and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadUYVYImage method is:  % 8 %      Image *ReadUYVYImage(const ImageInfo *image_info) % + %  A description of each parameter follows:  % H %    o image:  Method ReadUYVYImage returns a pointer to the image afterJ %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 Export Image *ReadUYVYImage(const ImageInfo *image_info) {    Image      *image;      int      y;     register int     i,     x;     register PixelPacket     *q;      unsigned char      u,     v,     y1,      y2;      unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL); 2   if ((image->columns == 0) || (image->rows == 0))>     ReaderExit(OptionWarning,"Must specify image size",image);   /*     Open image file.   */6   (void) strcpy(image->filename,image_info->filename);3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False);     ReaderExit(FileOpenWarning,"Unable to open file",image) #   for (i=0; i < image->offset; i++)      (void) ReadByte(image);    /*1     Accumulate UYVY, then unpack into two pixels.    */'   for (y=0; y < (int) image->rows; y++)    { 0     q=SetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;3     for (x=0; x < (int) (image->columns >> 1); x++)      {        u=ReadByte(image);       y1=ReadByte(image);        v=ReadByte(image);       y2=ReadByte(image);        q->red=UpScale(y1);        q->green=UpScale(u);       q->blue=UpScale(v); 
       q++;       q->red=UpScale(y2);        q->green=UpScale(u);       q->blue=UpScale(v); 
       q++;     }      if (!SyncPixelCache(image))        break;#     if (QuantumTick(y,image->rows)) 3       ProgressMonitor(LoadImageText,y,image->rows);    } +   TransformRGBImage(image,YCbCrColorspace);    CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e U Y V Y I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method WriteUYVYImage writes an image to a file in the digital UYVYM %  format.  This format, used by AccomWSD, is not dramatically higher quality < %  than the 12bit/pixel YUV format, but has better locality. % . %  The format of the WriteUYVYImage method is: % L %      unsigned int WriteUYVYImage(const ImageInfo *image_info,Image *image) % + %  A description of each parameter follows.  % I %    o status: Method WriteUYVYImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure.6 %      Implicit assumption: number of columns is even. %  */L Export unsigned int WriteUYVYImage(const ImageInfo *image_info,Image *image) {    int      y;     register int     x;     register PixelPacket     *p;      unsigned int	     full,      status,      u,     v,     y1;      /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);)   TransformRGBImage(image,RGBColorspace);    /*'     Convert to YUV, at full resolution.    */+   RGBTransformImage(image,YCbCrColorspace);    /*'     Accumulate two pixels, then output.    */
   full=False;    u=0;   v=0;   y1=0; 
   full=False; '   for (y=0; y < (int) image->rows; y++)    { 0     p=GetPixelCache(image,0,y,image->columns,1);"     if (p == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     {        if (full) 	         { ?           (void) WriteByte(image,DownScale((u+p->green) >> 1)); 0           (void) WriteByte(image,DownScale(y1));>           (void) WriteByte(image,DownScale((v+p->blue) >> 1));4           (void) WriteByte(image,DownScale(p->red));           full=False; 	         } 
       else	         {            y1=p->red;           u=p->green;            v=p->blue;           full=True;	         } 
       p++;     } #     if (QuantumTick(y,image->rows)) 3       ProgressMonitor(SaveImageText,y,image->rows);    } +   TransformRGBImage(image,YCbCrColorspace);    CloseBlob(image);    return(True);  } 