 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            Y   Y  U   U  V   V                              % O %                             Y Y   U   U  V   V                              % O %                              Y    U   U  V   V                              % O %                              Y    U   U   V V                               % O %                              Y     UUU     V                                % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d Y U V I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method ReadYUVImage reads an image with digital YUV (CCIR 601 4:1:1) bytes G %  and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % , %  The format of the ReadYUVImage method is: % 7 %      Image *ReadYUVImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadYUVImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadYUVImage(const ImageInfo *image_info)  {    Image      *chroma_image,     *image,      *zoom_image;     int 
     count,     y;     register int     i,     x;     register PixelPacket     *q,      *r;      register unsigned char     *p;      unsigned char      *scanline;     unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL); 2   if ((image->columns == 0) || (image->rows == 0))>     ReaderExit(OptionWarning,"Must specify image size",image);2   if (image_info->interlace != PartitionInterlace)     {        /*         Open image file.       */7       status=OpenBlob(image_info,image,ReadBinaryType);        if (status == False)@         ReaderExit(FileOpenWarning,"Unable to open file",image);'       for (i=0; i < image->offset; i++)          (void) ReadByte(image);      }    /*#     Allocate memory for a scanline.    */   scanline=(unsigned char *)9     AllocateMemory(image->columns*sizeof(unsigned char)); )   if (scanline == (unsigned char *) NULL) F     ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);   do   {      /*,       Convert raster image to pixel packets.     */4     if (image_info->interlace == PartitionInterlace)       { /         AppendImageFormat("Y",image->filename); 9         status=OpenBlob(image_info,image,ReadBinaryType);          if (status == False)B           ReaderExit(FileOpenWarning,"Unable to open file",image);       } )     for (y=0; y < (int) image->rows; y++)      { 9       if ((y > 0) || (image->previous == (Image *) NULL)) 7         (void) ReadBlob(image,image->columns,scanline);        p=scanline; 2       q=SetPixelCache(image,0,y,image->columns,1);$       if (q == (PixelPacket *) NULL)         break;.       for (x=0; x < (int) image->columns; x++)       {          q->red=UpScale(*p++);          q->green=0;          q->blue=0;         q++;       } !       if (!SyncPixelCache(image))          break;,       if (image->previous == (Image *) NULL)5         ProgressMonitor(LoadImageText,y,image->rows);      } 4     if (image_info->interlace == PartitionInterlace)       {          CloseBlob(image); /         AppendImageFormat("U",image->filename); 9         status=OpenBlob(image_info,image,ReadBinaryType);          if (status == False)B           ReaderExit(FileOpenWarning,"Unable to open file",image);       } G     chroma_image=CloneImage(image,image->columns/2,image->rows/2,True); '     if (chroma_image == (Image *) NULL) H       ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);0     for (y=0; y < (int) chroma_image->rows; y++)     { <       (void) ReadBlob(image,chroma_image->columns,scanline);       p=scanline; @       q=SetPixelCache(chroma_image,0,y,chroma_image->columns,1);$       if (q == (PixelPacket *) NULL)         break;5       for (x=0; x < (int) chroma_image->columns; x++)        {          q->red=0;          q->green=UpScale(*p++);          q->blue=0;         q++;       } (       if (!SyncPixelCache(chroma_image))         break;     } 4     if (image_info->interlace == PartitionInterlace)       {          CloseBlob(image); /         AppendImageFormat("V",image->filename); 9         status=OpenBlob(image_info,image,ReadBinaryType);          if (status == False)B           ReaderExit(FileOpenWarning,"Unable to open file",image);       } 0     for (y=0; y < (int) chroma_image->rows; y++)     { <       (void) ReadBlob(image,chroma_image->columns,scanline);       p=scanline; @       q=GetPixelCache(chroma_image,0,y,chroma_image->columns,1);$       if (q == (PixelPacket *) NULL)         break;5       for (x=0; x < (int) chroma_image->columns; x++)        {          q->blue=UpScale(*p++);         q++;       } (       if (!SyncPixelCache(chroma_image))         break;     }      /*       Scale image.     */D     zoom_image=SampleImage(chroma_image,image->columns,image->rows);     DestroyImage(chroma_image); %     if (zoom_image == (Image *) NULL) H       ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);)     for (y=0; y < (int) image->rows; y++)      { 2       q=GetPixelCache(image,0,y,image->columns,1);<       r=GetPixelCache(zoom_image,0,y,zoom_image->columns,1);E       if ((q == (PixelPacket *) NULL) || (r == (PixelPacket *) NULL))          break;.       for (x=0; x < (int) image->columns; x++)       {          q->green=r->green;         q->blue=r->blue;         r++;         q++;       } !       if (!SyncPixelCache(image))          break;     }      DestroyImage(zoom_image); -     TransformRGBImage(image,YCbCrColorspace); 4     if (image_info->interlace == PartitionInterlace):       (void) strcpy(image->filename,image_info->filename);     /*       Proceed to next image.     */"     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;;     count=ReadBlob(image,image->columns,(char *) scanline);      if (count > 0)       { 
         /*(           Allocate next image structure.
         */,         AllocateNextImage(image_info,image);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            }          image=image->next;F         ProgressMonitor(LoadImagesText,(unsigned int) TellBlob(image),*           (unsigned int) image->filesize);       }    } while (count > 0);   FreeMemory(scanline); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e Y U V I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Method WriteYUVImage writes an image to a file in the digital YUV %  (CCIR 601 4:1:1) format.  % - %  The format of the WriteYUVImage method is:  % K %      unsigned int WriteYUVImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % H %    o status: Method WriteYUVImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K Export unsigned int WriteYUVImage(const ImageInfo *image_info,Image *image)  {    Image      *chroma_image,     *yuv_image;      int      y;     register int     x;     register PixelPacket     *p;      unsigned int     height, 
     scene,     status, 
     width;  2   if (image_info->interlace != PartitionInterlace)     {        /*         Open output image file.        */8       status=OpenBlob(image_info,image,WriteBinaryType);       if (status == False)@         WriterExit(FileOpenWarning,"Unable to open file",image);     } 2   if (image_info->interlace == PartitionInterlace)     { -       AppendImageFormat("Y",image->filename); 8       status=OpenBlob(image_info,image,WriteBinaryType);       if (status == False)@         WriterExit(FileOpenWarning,"Unable to open file",image);     } 
   scene=0;   do   {      /*/       Sample image to an even width and height.      */+     TransformRGBImage(image,RGBColorspace); 1     width=image->columns+(image->columns & 0x01); ,     height=image->rows+(image->rows & 0x01);.     yuv_image=SampleImage(image,width,height);$     if (yuv_image == (Image *) NULL)D       WriterExit(ResourceLimitWarning,"Unable to zoom image",image);1     RGBTransformImage(yuv_image,YCbCrColorspace);      /*       Initialize Y channel.      */-     for (y=0; y < (int) yuv_image->rows; y++)      { :       p=GetPixelCache(yuv_image,0,y,yuv_image->columns,1);$       if (p == (PixelPacket *) NULL)         break;2       for (x=0; x < (int) yuv_image->columns; x++)       { 2         (void) WriteByte(image,DownScale(p->red));         p++;       } ,       if (image->previous == (Image *) NULL)'         if (QuantumTick(y,image->rows)) 7           ProgressMonitor(SaveImageText,y,image->rows);      }      DestroyImage(yuv_image);     /*       Downsample image.      */5     chroma_image=SampleImage(image,width/2,height/2); '     if (chroma_image == (Image *) NULL) D       WriterExit(ResourceLimitWarning,"Unable to zoom image",image);4     RGBTransformImage(chroma_image,YCbCrColorspace);     /*       Initialize U channel.      */4     if (image_info->interlace == PartitionInterlace)       {          CloseBlob(image); /         AppendImageFormat("U",image->filename); :         status=OpenBlob(image_info,image,WriteBinaryType);         if (status == False)B           WriterExit(FileOpenWarning,"Unable to open file",image);       } 0     for (y=0; y < (int) chroma_image->rows; y++)     { @       p=GetPixelCache(chroma_image,0,y,chroma_image->columns,1);$       if (p == (PixelPacket *) NULL)         break;5       for (x=0; x < (int) chroma_image->columns; x++)        { 4         (void) WriteByte(image,DownScale(p->green));         p++;       }      }      /*       Initialize V channel.      */4     if (image_info->interlace == PartitionInterlace)       {          CloseBlob(image); /         AppendImageFormat("V",image->filename); :         status=OpenBlob(image_info,image,WriteBinaryType);         if (status == False)B           WriterExit(FileOpenWarning,"Unable to open file",image);       } 0     for (y=0; y < (int) chroma_image->rows; y++)     { @       p=GetPixelCache(chroma_image,0,y,chroma_image->columns,1);$       if (p == (PixelPacket *) NULL)         break;5       for (x=0; x < (int) chroma_image->columns; x++)        { , 	(void) WriteByte(image,DownScale(p->blue));         p++;       }      }      DestroyImage(chroma_image); 4     if (image_info->interlace == PartitionInterlace):       (void) strcpy(image->filename,image_info->filename);&     if (image->next == (Image *) NULL)       break;     image=GetNextImage(image);C     ProgressMonitor(SaveImagesText,scene++,GetNumberScenes(image));    } while (image_info->adjoin);    if (image_info->adjoin) -     while (image->previous != (Image *) NULL)        image=image->previous;   CloseBlob(image);    return(True);  } 