/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.asn1;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Constructed;
import com.dstc.security.asn1.Primitive;
import java.io.IOException;

public abstract class Asn1 {
    public static final byte TAG_CLASS_UNIVERSAL = 0;
    public static final byte TAG_CLASS_APPLICATION = 64;
    public static final byte TAG_CLASS_CONTEXT = -128;
    public static final byte TAG_CLASS_PRIVATE = -64;
    public static final byte MASK_CLASS = -64;
    protected static final byte TAG_PRIMITIVE = 0;
    protected static final byte TAG_CONSTRUCTED = 32;
    protected static final byte MASK_CONSTRUCTED = 32;
    protected static final byte TAG_BOOLEAN = 1;
    protected static final byte TAG_INTEGER = 2;
    protected static final byte TAG_BITSTRING = 3;
    protected static final byte TAG_OCTETSTRING = 4;
    protected static final byte TAG_NULL = 5;
    protected static final byte TAG_OID = 6;
    protected static final byte TAG_ENUMERATED = 10;
    protected static final byte TAG_SEQUENCE = 16;
    protected static final byte TAG_SETOF = 17;
    protected static final byte TAG_UTF8STRING = 18;
    protected static final byte TAG_PRINTABLESTRING = 19;
    protected static final byte TAG_T61STRING = 20;
    protected static final byte TAG_IA5STRING = 22;
    protected static final byte TAG_UTCTIME = 23;
    protected static final byte TAG_GENERALIZEDTIME = 24;
    protected static final byte TAG_VISIBLESTRING = 26;
    protected static final byte TAG_GENERALSTRING = 27;
    protected static final byte TAG_BMPSTRING = 30;
    protected static final byte MASK_NUMBER = 31;
    protected int depth = 0;
    protected int tagNum;
    protected byte classType = 0;
    protected byte[] encoded = null;

    protected static final int bytesToInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = n3 << 8 | byArray[n4 + n] & 0xFF;
            ++n4;
        }
        return n3;
    }

    public static Asn1 decode(byte[] byArray) throws Asn1Exception {
        int[] nArray = new int[2];
        Asn1 asn1 = Asn1.decode(byArray, nArray);
        asn1.encoded = new byte[nArray[1]];
        System.arraycopy(byArray, 0, asn1.encoded, 0, asn1.encoded.length);
        return asn1;
    }

    public static Asn1 decode(byte[] byArray, int[] nArray) throws Asn1Exception {
        if ((byArray[nArray[0]] & 0x20) == 32) {
            return Constructed.decode(byArray, nArray);
        }
        return Primitive.decode(byArray, nArray);
    }

    protected static int decodeLengthOctets(byte[] byArray, int[] nArray) {
        int n;
        byte by = byArray[nArray[0] + 1];
        if (by == -128) {
            nArray[1] = byArray.length;
            return nArray[0] + 2;
        }
        if ((by & 0x80) == 0) {
            if (by == 0) {
                nArray[1] = nArray[0] + 2;
                return -1;
            }
            n = nArray[0] + 2;
            nArray[1] = n + by;
        } else {
            int n2 = by & 0x7F;
            n = nArray[0] + 2 + n2;
            nArray[1] = n + Asn1.bytesToInt(byArray, 2 + nArray[0], n2);
        }
        return n;
    }

    protected abstract byte[] doContents() throws IOException;

    protected void doDecode(byte[] byArray) throws Asn1Exception {
        int[] nArray = new int[2];
        this.doDecode(byArray, nArray);
    }

    protected abstract void doDecode(byte[] var1, int[] var2) throws Asn1Exception;

    private static final byte[] doLength(int n) {
        byte[] byArray = new byte[]{};
        if (n < 128) {
            byArray = new byte[]{(byte)n};
        } else {
            byte[] byArray2 = Asn1.intToBytes(n);
            byArray = new byte[1 + byArray2.length];
            System.arraycopy(byArray2, 0, byArray, 1, byArray2.length);
            byArray[0] = (byte)(byArray2.length | 0x80);
        }
        return byArray;
    }

    protected abstract void doTag(byte[] var1);

    public byte[] encode() {
        if (this.encoded != null) {
            return this.encoded;
        }
        try {
            byte[] byArray;
            byte[] byArray2 = this.doContents();
            if (byArray2 == null) {
                byArray = new byte[]{0};
                this.encoded = new byte[1 + byArray.length];
            } else {
                byArray = Asn1.doLength(byArray2.length);
                this.encoded = new byte[1 + byArray.length + byArray2.length];
                System.arraycopy(byArray2, 0, this.encoded, 1 + byArray.length, byArray2.length);
            }
            System.arraycopy(byArray, 0, this.encoded, 1, byArray.length);
            this.doTag(this.encoded);
            return this.encoded;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public byte getTagClass() {
        return this.classType;
    }

    public int getTagNumber() {
        return this.tagNum;
    }

    public void info() {
        this.info(0);
    }

    public abstract void info(int var1);

    private static final byte[] intToBytes(int n) {
        int n2 = (Integer.toHexString(n).length() + 1) / 2;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = (byte)(n >>> 8 * (n2 - 1 - n3) & 0xFF);
            ++n3;
        }
        return byArray;
    }

    public void setTagClass(byte by) {
        this.classType = by;
        this.encoded = null;
    }

    public void setTagNumber(int n) {
        this.tagNum = n;
        this.encoded = null;
    }

    protected final void spit() {
        int n = 0;
        while (n < this.depth) {
            System.out.print("  ");
            ++n;
        }
    }
}

