/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.asn1;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.SetOf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;

public class Constructed
extends Asn1 {
    protected Vector components = new Vector();
    protected String typeName = "";

    public void addComponent(Asn1 asn1) {
        this.components.addElement(asn1);
    }

    public static Asn1 decode(byte[] byArray, int[] nArray) throws Asn1Exception {
        byte by = (byte)(byArray[nArray[0]] & 0xFFFFFFC0);
        byte by2 = (byte)(byArray[nArray[0]] & 0x1F);
        if (by == 0) {
            if (by2 == 16) {
                return Sequence.decode(byArray, nArray);
            }
            if (by2 == 17) {
                return SetOf.decode(byArray, nArray);
            }
            Constructed constructed = new Constructed();
            constructed.doDecode(byArray, nArray);
            return constructed;
        }
        return Explicit.decode(byArray, nArray);
    }

    protected byte[] doContents() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < this.components.size()) {
            byteArrayOutputStream.write(((Asn1)this.components.elementAt(n)).encode());
            ++n;
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected void doDecode(byte[] byArray, int[] nArray) throws Asn1Exception {
        block2: {
            int[] nArray2 = new int[2];
            nArray2[0] = Asn1.decodeLengthOctets(byArray, nArray);
            if (nArray2[0] < 0) {
                return;
            }
            do {
                this.components.addElement(Asn1.decode(byArray, nArray2));
                nArray2[0] = nArray2[1];
                if (nArray2[0] >= nArray[1]) break block2;
            } while (!(byArray[nArray2[0]] == 0 & byArray[nArray2[0] + 1] == 0));
            nArray[1] = nArray2[0] + 2;
        }
    }

    protected void doTag(byte[] byArray) {
        byArray[0] = (byte)(this.tagNum | 0x20 | this.classType);
    }

    public Vector getComponents() {
        return this.components;
    }

    public void info(int n) {
        this.depth = n + 1;
        this.spit();
        System.out.println(String.valueOf(this.typeName) + " {");
        int n2 = 0;
        while (n2 < this.components.size()) {
            ((Asn1)this.components.elementAt(n2)).info(this.depth);
            ++n2;
        }
        this.spit();
        System.out.println("}");
    }
}

