/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.asn1;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Primitive;
import java.math.BigInteger;

public class Enumerated
extends Primitive {
    public Enumerated() {
        this.tagNum = 10;
    }

    public Enumerated(int n) {
        this.tagNum = 10;
        this.contents = BigInteger.valueOf(n).toByteArray();
    }

    public Enumerated(BigInteger bigInteger) {
        this.tagNum = 10;
        this.contents = bigInteger.toByteArray();
    }

    public static Asn1 decode(byte[] byArray, int[] nArray) throws Asn1Exception {
        Enumerated enumerated = new Enumerated();
        enumerated.doDecode(byArray, nArray);
        return enumerated;
    }

    public BigInteger getBigInteger() {
        return new BigInteger(this.contents);
    }

    public int getInt() {
        return new BigInteger(this.contents).intValue();
    }

    public void info(int n) {
        this.depth = n + 1;
        this.spit();
        System.out.print("ENUMERATED ");
        System.out.println(new BigInteger(this.contents).toString(16));
    }
}

