/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.asn1;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Constructed;

public class Explicit
extends Constructed {
    public Explicit() {
    }

    public Explicit(byte by, int n) {
        this.tagNum = n;
        this.classType = by;
    }

    public static Asn1 decode(byte[] byArray, int[] nArray) throws Asn1Exception {
        Explicit explicit = new Explicit();
        explicit.doDecode(byArray, nArray);
        explicit.tagNum = byArray[nArray[0]] & 0x1F;
        explicit.classType = (byte)(byArray[nArray[0]] & 0xFFFFFFC0);
        return explicit;
    }

    protected void doDecode(byte[] byArray, int[] nArray) throws Asn1Exception {
        super.doDecode(byArray, nArray);
        this.classType = (byte)(byArray[nArray[0]] & 0xFFFFFFC0);
        this.tagNum = byArray[nArray[0]] & 0x1F;
    }

    public Asn1 getComponent() {
        return (Asn1)this.getComponents().elementAt(0);
    }

    public void info(int n) {
        this.depth = n + 1;
        this.spit();
        if (this.classType == 64) {
            System.out.println("[APPLICATION " + this.tagNum + "] {");
        } else if (this.classType == -128) {
            System.out.println("[CONTEXT-SPECIFIC " + this.tagNum + "] {");
        } else if (this.classType == 0) {
            System.out.println("[" + this.tagNum + "] {");
        }
        int n2 = 0;
        while (n2 < this.components.size()) {
            ((Asn1)this.components.elementAt(n2)).info(this.depth);
            ++n2;
        }
        this.spit();
        System.out.println("}");
    }
}

