/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.asn1;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BMPString;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.Boolean;
import com.dstc.security.asn1.Enumerated;
import com.dstc.security.asn1.GeneralString;
import com.dstc.security.asn1.GeneralizedTime;
import com.dstc.security.asn1.IA5String;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Null;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.PrintableString;
import com.dstc.security.asn1.T61String;
import com.dstc.security.asn1.UTCTime;
import com.dstc.security.asn1.UTF8String;
import java.io.IOException;

public class Primitive
extends Asn1 {
    protected byte[] contents;

    public Primitive() {
    }

    protected Primitive(byte by, Asn1 asn1) {
        this.encoded = (byte[])asn1.encode().clone();
        this.encoded[0] = by;
    }

    public static Asn1 decode(byte[] byArray, int[] nArray) throws Asn1Exception {
        byte by = (byte)(byArray[nArray[0]] & 0xFFFFFFC0);
        byte by2 = (byte)(byArray[nArray[0]] & 0x1F);
        if (by == 0) {
            switch (by2) {
                case 1: {
                    return Boolean.decode(byArray, nArray);
                }
                case 2: {
                    return Integer.decode(byArray, nArray);
                }
                case 3: {
                    return BitString.decode(byArray, nArray);
                }
                case 5: {
                    return Null.decode(byArray, nArray);
                }
                case 6: {
                    return Oid.decode(byArray, nArray);
                }
                case 18: {
                    return UTF8String.decode(byArray, nArray);
                }
                case 4: {
                    return OctetString.decode(byArray, nArray);
                }
                case 19: {
                    return PrintableString.decode(byArray, nArray);
                }
                case 20: {
                    return T61String.decode(byArray, nArray);
                }
                case 27: {
                    return GeneralString.decode(byArray, nArray);
                }
                case 22: {
                    return IA5String.decode(byArray, nArray);
                }
                case 23: {
                    return UTCTime.decode(byArray, nArray);
                }
                case 10: {
                    return Enumerated.decode(byArray, nArray);
                }
                case 24: {
                    return GeneralizedTime.decode(byArray, nArray);
                }
                case 30: {
                    return BMPString.decode(byArray, nArray);
                }
            }
            throw new Asn1Exception("Unknown universal tag " + by2);
        }
        if (by == -128) {
            Primitive primitive = new Primitive();
            primitive.doDecode(byArray, nArray);
            primitive.classType = (byte)-128;
            primitive.tagNum = by2;
            return primitive;
        }
        throw new Asn1Exception("unknown tag " + by2);
    }

    protected byte[] doContents() throws IOException {
        return this.contents;
    }

    protected void doDecode(byte[] byArray, int[] nArray) {
        int n = Asn1.decodeLengthOctets(byArray, nArray);
        if (n < 0) {
            return;
        }
        this.contents = new byte[nArray[1] - n];
        System.arraycopy(byArray, n, this.contents, 0, this.contents.length);
    }

    protected void doTag(byte[] byArray) {
        byArray[0] = (byte)(this.tagNum | this.classType);
    }

    public byte[] getBytes() {
        return this.contents;
    }

    private static final String hexDigit(byte by) {
        char[] cArray = new char[2];
        char c = (char)(by >> 4 & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        cArray[0] = c;
        c = (char)(by & 0xF);
        c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
        cArray[1] = c;
        return new String(cArray);
    }

    public void info(int n) {
        this.depth = n + 1;
        this.spit();
        System.out.print("IMPLICIT ");
        this.printHex(this.contents);
    }

    protected void printHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (byArray != null) {
            int n = 0;
            while (n < byArray.length) {
                if (n % 16 == 0) {
                    stringBuffer.append("\n ");
                    int n2 = 0;
                    while (n2 < this.depth) {
                        stringBuffer.append("  ");
                        ++n2;
                    }
                }
                stringBuffer.append(String.valueOf(Primitive.hexDigit(byArray[n])) + " ");
                ++n;
            }
        }
        System.out.println(stringBuffer.toString());
    }
}

