/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.asn1;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Primitive;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class UTCTime
extends Primitive {
    public UTCTime() {
        this.tagNum = 23;
    }

    public UTCTime(int n) {
        this.tagNum = 23;
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("AEST"));
        calendar.add(11, n);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(calendar.get(1)).substring(2, 4));
        this.append(stringBuffer, calendar.get(2) + 1);
        this.append(stringBuffer, calendar.get(5));
        this.append(stringBuffer, calendar.get(10));
        this.append(stringBuffer, calendar.get(12));
        stringBuffer.append("Z");
        this.contents = stringBuffer.toString().getBytes();
    }

    public UTCTime(String string) {
        this.tagNum = 23;
        this.contents = string.getBytes();
    }

    private void append(StringBuffer stringBuffer, int n) {
        if (n < 10) {
            stringBuffer.append("0" + n);
        } else {
            stringBuffer.append(n);
        }
    }

    public static Asn1 decode(byte[] byArray, int[] nArray) throws Asn1Exception {
        UTCTime uTCTime = new UTCTime();
        uTCTime.doDecode(byArray, nArray);
        return uTCTime;
    }

    public Date getDate() {
        String string = new String(this.contents);
        Date date = null;
        if (string.endsWith("Z")) {
            Calendar calendar = Calendar.getInstance();
            switch (string.length()) {
                case 11: {
                    int n = 1900 + Integer.parseInt(string.substring(0, 2));
                    int n2 = Integer.parseInt(string.substring(2, 4)) - 1;
                    int n3 = Integer.parseInt(string.substring(4, 6));
                    int n4 = Integer.parseInt(string.substring(6, 8));
                    int n5 = Integer.parseInt(string.substring(8, 10));
                    calendar.set(n, n2, n3, n4, n5);
                    break;
                }
                case 13: {
                    int n = 1900 + Integer.parseInt(string.substring(0, 2));
                    int n6 = Integer.parseInt(string.substring(2, 4)) - 1;
                    int n7 = Integer.parseInt(string.substring(4, 6));
                    int n8 = Integer.parseInt(string.substring(6, 8));
                    int n9 = Integer.parseInt(string.substring(8, 10));
                    int n10 = Integer.parseInt(string.substring(10, 12));
                    calendar.set(n, n6, n7, n8, n9, n10);
                    break;
                }
            }
            date = calendar.getTime();
        }
        return date;
    }

    public String getTime() {
        return new String(this.contents);
    }

    public void info(int n) {
        this.depth = n + 1;
        this.spit();
        System.out.print("UTC TIME ");
        System.out.println(new String(this.contents));
    }
}

