/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.v1.IssuerAndSerialNumber;
import java.security.Principal;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class CertPath {
    private Vector path;
    private X509Certificate signerCert;

    public CertPath(Collection collection, IssuerAndSerialNumber issuerAndSerialNumber) throws CMSException {
        X509Certificate x509Certificate;
        Iterator iterator;
        Vector vector;
        block3: {
            this.path = new Vector();
            this.signerCert = null;
            vector = new Vector(collection);
            iterator = ((AbstractList)vector).iterator();
            do {
                if (!issuerAndSerialNumber.equals(new IssuerAndSerialNumber(x509Certificate = (X509Certificate)iterator.next()))) continue;
                this.signerCert = x509Certificate;
                this.path.addElement(x509Certificate);
                vector.removeElement(x509Certificate);
                break block3;
            } while (iterator.hasNext());
            throw new CMSException("Signer cert not found");
        }
        while (!vector.isEmpty()) {
            iterator = ((AbstractList)vector).iterator();
            Principal principal = x509Certificate.getIssuerDN();
            if (x509Certificate.getSubjectDN().equals(principal)) break;
            do {
                if (iterator.hasNext()) continue;
                return;
            } while (!(x509Certificate = (X509Certificate)iterator.next()).getSubjectDN().equals(principal));
            this.path.addElement(x509Certificate);
            vector.removeElement(x509Certificate);
        }
    }

    public X509Certificate getSignerCert() {
        return this.signerCert;
    }

    public void verify(Collection collection) throws CMSException {
        try {
            Iterator iterator = ((AbstractList)this.path).iterator();
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            while (iterator.hasNext()) {
                x509Certificate.checkValidity();
                X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
                x509Certificate.verify(x509Certificate2.getPublicKey());
                x509Certificate = x509Certificate2;
            }
            Principal principal = x509Certificate.getIssuerDN();
            boolean bl = principal.equals(x509Certificate.getSubjectDN());
            iterator = collection.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate3 = (X509Certificate)iterator.next();
                if (!principal.getName().equals(x509Certificate3.getSubjectDN().getName())) continue;
                if (bl) {
                    x509Certificate.checkValidity();
                    boolean bl2 = Arrays.equals(x509Certificate.getEncoded(), x509Certificate3.getEncoded());
                    x509Certificate.verify(x509Certificate3.getPublicKey());
                    return;
                }
                x509Certificate.checkValidity();
                x509Certificate.verify(x509Certificate3.getPublicKey());
                return;
            }
            throw new CMSException("Cannot find trusted CA");
        }
        catch (SignatureException signatureException) {
            throw new CMSException("Bad signature");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CMSException(exception.getMessage());
        }
    }
}

