/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.Originator;
import com.dstc.security.cms.Recipient;
import com.dstc.security.cms.v1.ContentInfo;
import com.dstc.security.cms.v1.EncryptedContentInfo;
import com.dstc.security.cms.v1.EnvelopedData;
import com.dstc.security.cms.v1.IssuerAndSerialNumber;
import com.dstc.security.cms.v1.OriginatorInfo;
import com.dstc.security.cms.v1.RecipientInfo;
import com.dstc.security.x509.AlgorithmId;
import java.security.AlgorithmParameters;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EnvelopedMessage {
    private Set recipients;
    private Set recipientInfos;
    private String encryptionAlg;
    private String encryptionAlgMode;
    private String encryptionAlgModePad;
    private String encryptionAlgOid;
    private String paramSpecClassName;
    private Originator originator = null;
    private byte[] message = null;
    private SecretKey sessionKey = null;
    private SecureRandom rand = new SecureRandom(new byte[8]);
    private Cipher cipher;
    private AlgorithmParameters params;
    private byte[] encryptedContent;
    private ContentInfo contentInfo;

    public EnvelopedMessage(Originator originator, byte[] byArray, SecureRandom secureRandom) {
        this.recipients = new HashSet();
        this.originator = originator;
        this.message = byArray;
        this.rand = secureRandom;
    }

    public EnvelopedMessage(SecureRandom secureRandom) {
        this.recipients = new HashSet();
        this.recipientInfos = new HashSet();
        this.rand = secureRandom;
    }

    public EnvelopedMessage(byte[] byArray) throws Asn1Exception, CMSException {
        this.contentInfo = new ContentInfo(byArray);
        EnvelopedData envelopedData = new EnvelopedData(this.contentInfo.getContent().encode());
        OriginatorInfo originatorInfo = envelopedData.getOriginatorInfo();
        if (originatorInfo != null) {
            this.originator = new Originator(originatorInfo);
        }
        this.recipientInfos = envelopedData.getRecipientInfos();
        this.recipients = new HashSet();
        Iterator iterator = this.recipientInfos.iterator();
        while (iterator.hasNext()) {
            this.recipients.add(new Recipient((RecipientInfo)iterator.next()));
        }
        EncryptedContentInfo encryptedContentInfo = envelopedData.getEncryptedContentInfo();
        this.encryptedContent = encryptedContentInfo.getEncryptedContent();
        String string = encryptedContentInfo.getContentEncryptionAlgorithm().getOid();
        this.params = encryptedContentInfo.getContentEncryptionAlgorithm().getParams();
        if (string.equals("1.2.840.113549.3.2")) {
            this.encryptionAlgModePad = "RC2/CBC/PKCS5Padding";
            this.encryptionAlgMode = "RC2/CBC";
            this.encryptionAlg = "RC2";
            this.paramSpecClassName = "javax.crypto.spec.RC2ParameterSpec";
        } else if (string.equals("1.2.840.113549.3.7")) {
            this.encryptionAlgModePad = "DESede/CBC/PKCS5Padding";
            this.encryptionAlgMode = "DESede/CBC";
            this.encryptionAlg = "DESede";
            this.paramSpecClassName = "javax.crypto.spec.IvParameterSpec";
        }
    }

    public void addRecipient(Recipient recipient) throws CMSException {
        if (this.sessionKey == null) {
            throw new CMSException("Encryption algorithm not yet set");
        }
        this.recipients.add(recipient);
        this.recipientInfos.add(recipient.encryptKey(this.sessionKey.getEncoded()));
    }

    public void decrypt(X509Certificate x509Certificate, PrivateKey privateKey) throws CMSException {
        Recipient recipient = this.getRecipient(x509Certificate);
        SecretKeySpec secretKeySpec = new SecretKeySpec(recipient.decryptKey(privateKey), this.encryptionAlg);
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(this.encryptionAlg);
            this.sessionKey = secretKeyFactory.translateKey(secretKeySpec);
            this.cipher = Cipher.getInstance(this.getCipherAlgorithm());
            this.cipher.init(2, this.sessionKey, (AlgorithmParameterSpec)this.params.getParameterSpec(Class.forName(this.paramSpecClassName)), null);
            this.message = this.cipher.doFinal(this.encryptedContent);
        }
        catch (Exception exception) {
            throw new CMSException(exception.toString());
        }
    }

    public void encrypt() throws CMSException {
        EnvelopedData envelopedData = new EnvelopedData(0, null, this.recipientInfos, this.encryptContent());
        this.contentInfo = new ContentInfo("1.2.840.113549.1.7.3", envelopedData);
    }

    private byte[] encrypt(byte[] byArray) throws CMSException {
        if (this.sessionKey == null) {
            throw new CMSException("Encryption algorithm not yet set");
        }
        try {
            this.cipher = Cipher.getInstance(this.getCipherAlgorithm());
            byte[] byArray2 = new byte[8];
            this.rand.nextBytes(byArray2);
            this.params = AlgorithmParameters.getInstance(this.encryptionAlgMode);
            AlgorithmParameterSpec algorithmParameterSpec = null;
            if (this.encryptionAlg.equals("RC2")) {
                algorithmParameterSpec = new RC2ParameterSpec(128, byArray2);
            } else if (this.encryptionAlg.equals("DESede")) {
                algorithmParameterSpec = new IvParameterSpec(byArray2);
            }
            this.params.init(algorithmParameterSpec);
            this.cipher.init(1, this.sessionKey, algorithmParameterSpec, this.rand);
            return this.cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new CMSException(exception.toString());
        }
    }

    private EncryptedContentInfo encryptContent() throws CMSException {
        if (this.sessionKey == null) {
            throw new CMSException("Encryption algorithm not yet set");
        }
        if (this.message == null) {
            throw new CMSException("Message not yet set");
        }
        this.encryptedContent = this.encrypt(this.message);
        try {
            return new EncryptedContentInfo("1.2.840.113549.1.7.1", new AlgorithmId(this.encryptionAlgOid, this.params), this.encryptedContent);
        }
        catch (Exception exception) {
            throw new CMSException(exception.toString());
        }
    }

    private SecretKey generateSessionKey(int n) throws CMSException {
        if (this.encryptionAlg == null) {
            throw new CMSException("Encryption algorithm not yet set");
        }
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(this.encryptionAlg);
            keyGenerator.init(n, this.rand);
            return keyGenerator.generateKey();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CMSException(exception.toString());
        }
    }

    public String getCipherAlgorithm() {
        return this.encryptionAlgModePad;
    }

    public byte[] getEncoded() {
        return this.contentInfo.encode();
    }

    public byte[] getMessage() throws CMSException {
        if (this.message == null) {
            throw new CMSException("Message not yet decrypted");
        }
        return this.message;
    }

    public Set getOriginatorCerts() {
        if (this.originator == null) {
            return null;
        }
        return this.originator.getCerts();
    }

    private Recipient getRecipient(X509Certificate x509Certificate) throws CMSException {
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(x509Certificate);
        Iterator iterator = this.getRecipients().iterator();
        while (iterator.hasNext()) {
            Recipient recipient = (Recipient)iterator.next();
            if (!issuerAndSerialNumber.equals(recipient.getIssuerAndSerialNumber())) continue;
            return recipient;
        }
        throw new CMSException("Wrong certificate for this Enveloped message");
    }

    public Set getRecipients() {
        return this.recipients;
    }

    public void setEncryptionAlgorithm(String string) throws CMSException {
        if (string.equals("RC2/40")) {
            this.encryptionAlgModePad = "RC2/CBC/PKCS5Padding";
            this.encryptionAlgMode = "RC2/CBC";
            this.encryptionAlg = "RC2";
            this.encryptionAlgOid = "1.2.840.113549.3.2";
            this.paramSpecClassName = "javax.crypto.spec.RC2ParameterSpec";
            this.sessionKey = this.generateSessionKey(40);
        } else if (string.equals("DESede")) {
            this.encryptionAlgModePad = "DESede/CBC/PKCS5Padding";
            this.encryptionAlgMode = "DESede/CBC";
            this.encryptionAlg = "DESede";
            this.encryptionAlgOid = "1.2.840.113549.3.7";
            this.paramSpecClassName = "javax.crypto.spec.IvParameterSpec";
            this.sessionKey = this.generateSessionKey(192);
        }
    }

    public void setMessage(byte[] byArray) {
        this.message = byArray;
    }
}

