/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.v1.IssuerAndSerialNumber;
import com.dstc.security.cms.v1.RecipientInfo;
import com.dstc.security.provider.OID;
import com.dstc.security.x509.AlgorithmId;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;

public class Recipient {
    private String keyEncryptionAlg;
    private PublicKey keyEncryptingKey;
    private IssuerAndSerialNumber issuerAndSerialNumber;
    private byte[] encKey;

    Recipient(RecipientInfo recipientInfo) {
        this.issuerAndSerialNumber = recipientInfo.getRecipientIdentifier();
        this.encKey = recipientInfo.getEncryptedKey();
        this.keyEncryptionAlg = "RSA";
    }

    public Recipient(X509Certificate x509Certificate) {
        this.keyEncryptingKey = x509Certificate.getPublicKey();
        this.issuerAndSerialNumber = new IssuerAndSerialNumber(x509Certificate);
        this.keyEncryptionAlg = this.keyEncryptingKey.getAlgorithm();
    }

    byte[] decryptKey(PrivateKey privateKey) throws CMSException {
        try {
            Cipher cipher = Cipher.getInstance(this.keyEncryptionAlg);
            cipher.init(2, privateKey, null, null);
            return cipher.doFinal(this.encKey);
        }
        catch (Exception exception) {
            throw new CMSException(exception.toString());
        }
    }

    private byte[] encrypt(byte[] byArray) throws CMSException {
        try {
            Cipher cipher = Cipher.getInstance(this.keyEncryptionAlg);
            cipher.init(1, this.keyEncryptingKey, null, null);
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new CMSException(exception.toString());
        }
    }

    RecipientInfo encryptKey(byte[] byArray) throws CMSException {
        this.encKey = this.encrypt(byArray);
        return new RecipientInfo(this.issuerAndSerialNumber, new AlgorithmId(OID.getAlgOid(this.keyEncryptionAlg)), this.encKey);
    }

    IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    String getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlg;
    }
}

