/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.Signer;
import com.dstc.security.cms.v1.ContentInfo;
import com.dstc.security.cms.v1.EncapContentInfo;
import com.dstc.security.cms.v1.SignedData;
import com.dstc.security.cms.v1.SignerInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SignedMessage {
    private Set signers = null;
    private Set signerInfos = null;
    private Set trustedCerts = null;
    private Set digestAlgorithms = null;
    private Set certs = null;
    private byte[] toBeSigned = null;
    private EncapContentInfo eContentInfo = null;
    private boolean includeMessage = false;
    private ContentInfo contentInfo = null;
    private SignedData signedData = null;

    public SignedMessage(Signer signer, byte[] byArray) throws CMSException {
        this.toBeSigned = byArray;
        this.signers = new HashSet();
        this.signers.add(signer);
        this.digestAlgorithms = new HashSet();
        this.digestAlgorithms.add(signer.getDigestAlgorithm());
        this.signerInfos = new HashSet();
        this.signerInfos.add(signer.sign(byArray));
        this.certs = new HashSet();
        this.certs.addAll(signer.getCertificates());
        this.eContentInfo = this.includeMessage ? new EncapContentInfo("1.2.840.113549.1.7.1", null) : new EncapContentInfo("1.2.840.113549.1.7.1", this.toBeSigned);
    }

    public SignedMessage(byte[] byArray) throws Asn1Exception, CMSException {
        this.contentInfo = new ContentInfo(byArray);
        this.signedData = new SignedData(this.contentInfo.getContent().encode());
        this.certs = this.signedData.getCertificates();
        this.signerInfos = this.signedData.getSignerInfos();
        this.signers = new HashSet();
        Iterator iterator = this.signerInfos.iterator();
        while (iterator.hasNext()) {
            this.signers.add(new Signer((SignerInfo)iterator.next(), this.certs));
        }
        this.eContentInfo = this.signedData.getContentInfo();
        this.toBeSigned = this.eContentInfo.getContent();
    }

    public void addSignature(Signer signer) throws CMSException {
        this.signers.add(signer);
        this.digestAlgorithms.add(signer.getDigestAlgorithm());
        this.signerInfos.add(signer.sign(this.toBeSigned));
        this.certs.addAll(signer.getCertificates());
    }

    public Set getCertificates() {
        return this.certs;
    }

    public Set getDigestAlgorithms() {
        return this.digestAlgorithms;
    }

    public byte[] getEncoded() {
        if (this.contentInfo == null) {
            return this.sign();
        }
        return this.contentInfo.encode();
    }

    public byte[] getMessage() {
        return this.toBeSigned;
    }

    public Set getSigners() {
        return this.signers;
    }

    public void setIncludeMessage(boolean bl) {
        this.includeMessage = bl;
    }

    public void setTrustedCAs(Set set) {
        this.trustedCerts = set;
    }

    public byte[] sign() {
        this.signedData = new SignedData(this.digestAlgorithms, this.eContentInfo, this.certs, null, this.signerInfos);
        this.contentInfo = new ContentInfo("1.2.840.113549.1.7.2", this.signedData);
        return this.contentInfo.encode();
    }

    public void verify() throws CMSException {
        this.verify(this.toBeSigned);
    }

    public void verify(byte[] byArray) throws CMSException {
        if (this.trustedCerts == null) {
            throw new CMSException("No trusted CAs set");
        }
        Iterator iterator = this.getSigners().iterator();
        while (iterator.hasNext()) {
            Signer signer = (Signer)iterator.next();
            signer.verify(byArray);
            signer.getCertPath().verify(this.trustedCerts);
        }
    }
}

