/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms;

import com.dstc.security.asn1.OctetString;
import com.dstc.security.cms.CMSException;
import com.dstc.security.cms.CertPath;
import com.dstc.security.cms.atts.MessageDigest;
import com.dstc.security.cms.v1.IssuerAndSerialNumber;
import com.dstc.security.cms.v1.SignedAttributes;
import com.dstc.security.cms.v1.SignerInfo;
import com.dstc.security.provider.OID;
import com.dstc.security.x509.AlgorithmId;
import com.dstc.security.x509.Attribute;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Signer {
    private Set certs;
    private X509Certificate signerCert;
    private CertPath cpc = null;
    private PrivateKey privKey;
    private Set signedAttributes = null;
    private Set unsignedAttributes = null;
    private String digestAlg = "SHA";
    private String sigAlg = null;
    private byte[] toBeSigned = null;
    private byte[] signature = null;
    private String provider = null;

    Signer(SignerInfo signerInfo, Set set) throws CMSException {
        this.signedAttributes = signerInfo.getSignedAttributes();
        this.signature = signerInfo.getSignature();
        this.sigAlg = signerInfo.getSignatureAlgorithm();
        if (this.sigAlg.equals("RSA")) {
            this.sigAlg = String.valueOf(signerInfo.getDigestAlgorithm()) + "/RSA";
        }
        this.certs = set;
        IssuerAndSerialNumber issuerAndSerialNumber = signerInfo.getIssuerAndSerialNumber();
        this.cpc = new CertPath(this.certs, issuerAndSerialNumber);
        this.signerCert = this.cpc.getSignerCert();
        this.toBeSigned = signerInfo.getToBeSigned();
    }

    public Signer(X509Certificate x509Certificate, Set set, PrivateKey privateKey) {
        this.signerCert = x509Certificate;
        this.certs = this.certs == null ? new HashSet() : set;
        this.certs.add(x509Certificate);
        this.privKey = privateKey;
        this.signedAttributes = new HashSet();
        try {
            this.cpc = new CertPath(this.certs, new IssuerAndSerialNumber(x509Certificate));
        }
        catch (CMSException cMSException) {
            cMSException.printStackTrace();
        }
    }

    private byte[] digest(byte[] byArray) throws CMSException {
        try {
            java.security.MessageDigest messageDigest = java.security.MessageDigest.getInstance(this.digestAlg);
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (Exception exception) {
            throw new CMSException(exception.toString());
        }
    }

    public CertPath getCertPath() {
        return this.cpc;
    }

    Set getCertificates() {
        return this.certs;
    }

    private byte[] getDigest() {
        Iterator iterator = this.signedAttributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!attribute.getType().equals("1.2.840.113549.1.9.4")) continue;
            return ((OctetString)attribute.getValues().elementAt(0)).getBytes();
        }
        return null;
    }

    String getDigestAlgorithm() {
        return this.digestAlg;
    }

    String getSignatureAlgorithm() {
        return this.sigAlg;
    }

    public void setDigestAlgorithm(String string) {
        this.digestAlg = string;
    }

    public void setProvider(String string) {
        this.provider = string;
    }

    public void setSignatureAlgorithm(String string) {
        this.sigAlg = string;
    }

    public void setSignedAttributes(Set set) {
        this.signedAttributes = set;
    }

    public void setUnsignedAttributes(Set set) {
        this.unsignedAttributes = set;
    }

    private byte[] sign() throws CMSException {
        try {
            Signature signature = this.provider == null ? Signature.getInstance(this.sigAlg) : Signature.getInstance(this.sigAlg, this.provider);
            signature.initSign(this.privKey);
            this.toBeSigned = new SignedAttributes(this.signedAttributes).encode();
            signature.update(this.toBeSigned);
            return signature.sign();
        }
        catch (Exception exception) {
            throw new CMSException(exception.toString());
        }
    }

    SignerInfo sign(byte[] byArray) throws CMSException {
        if (this.sigAlg == null) {
            throw new CMSException("Signature algorithm not set");
        }
        if (this.signedAttributes == null) {
            this.signedAttributes = new HashSet();
        }
        this.signedAttributes.add(new MessageDigest(this.digest(byArray)));
        this.signature = this.sign();
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(this.signerCert);
        String string = this.sigAlg;
        if (this.sigAlg.endsWith("RSA")) {
            string = "RSA";
        }
        return new SignerInfo(issuerAndSerialNumber, new AlgorithmId(OID.getAlgOid(this.digestAlg)), this.signedAttributes, string, this.signature);
    }

    void verify(byte[] byArray) throws CMSException {
        if (!Arrays.equals(this.getDigest(), this.digest(byArray))) {
            throw new CMSException("Bad digest");
        }
        this.verifySignature();
    }

    private void verifySignature() throws CMSException {
        try {
            Signature signature = Signature.getInstance(this.sigAlg);
            signature.initVerify(this.signerCert.getPublicKey());
            signature.update(this.toBeSigned);
            boolean bl = signature.verify(this.signature);
            if (!bl) {
                throw new CMSException("Bad signature");
            }
        }
        catch (Exception exception) {
            throw new CMSException(exception.getMessage());
        }
    }
}

