/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms.v1;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.SetOf;
import com.dstc.security.x509.X509CRLImpl;
import java.security.cert.CRLException;
import java.security.cert.X509CRL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class CRLSet
extends SetOf {
    private Set crls;

    public CRLSet(Set set) throws Asn1Exception, CRLException {
        this.crls = set;
        Iterator iterator = this.crls.iterator();
        while (iterator.hasNext()) {
            Asn1 asn1 = Asn1.decode(((X509CRL)iterator.next()).getEncoded());
            this.addComponent(asn1);
        }
    }

    public CRLSet(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        this.crls = new HashSet();
        int n = 0;
        while (n < this.components.size()) {
            this.crls.add(new X509CRLImpl(((Asn1)this.components.elementAt(n)).encode()));
            ++n;
        }
    }

    public Set getCRLs() {
        return this.crls;
    }
}

