/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms.v1;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.SetOf;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public final class CertificateSet
extends SetOf {
    private Set certs;

    public CertificateSet(Set set) throws Asn1Exception, CertificateException {
        this.certs = set;
        Iterator iterator = this.certs.iterator();
        while (iterator.hasNext()) {
            Asn1 asn1 = Asn1.decode(((X509Certificate)iterator.next()).getEncoded());
            this.addComponent(asn1);
        }
    }

    public CertificateSet(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            this.certs = new HashSet();
            int n = 0;
            while (n < this.components.size()) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((Asn1)this.components.elementAt(n)).encode());
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                this.certs.add(x509Certificate);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Set getCerts() {
        return this.certs;
    }
}

