/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms.v1;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Constructed;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.AlgorithmId;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public final class EncryptedContentInfo
extends Sequence {
    private Oid contentType;
    private AlgorithmId contentEncryptionAlgoId;
    private byte[] encryptedContent;

    public EncryptedContentInfo(String string, AlgorithmId algorithmId, byte[] byArray) {
        this.contentType = new Oid(string);
        this.addComponent(this.contentType);
        this.contentEncryptionAlgoId = algorithmId;
        this.addComponent(algorithmId);
        this.encryptedContent = byArray;
        ConstructedOctet constructedOctet = new ConstructedOctet(0, byArray);
        this.addComponent(constructedOctet);
    }

    public EncryptedContentInfo(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        int n = 0;
        this.contentType = (Oid)this.components.elementAt(n++);
        this.contentEncryptionAlgoId = new AlgorithmId(((Asn1)this.components.elementAt(n++)).encode());
        try {
            this.encryptedContent = ((OctetString)this.components.elementAt(n)).getBytes();
            return;
        }
        catch (ClassCastException classCastException) {
            ConstructedOctet constructedOctet = new ConstructedOctet(((Asn1)this.components.elementAt(n)).encode());
            this.encryptedContent = constructedOctet.realContent;
            return;
        }
    }

    public AlgorithmId getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgoId;
    }

    public Oid getContentType() {
        return this.contentType;
    }

    public byte[] getEncryptedContent() {
        return (byte[])this.encryptedContent.clone();
    }

    protected class ConstructedOctet
    extends Constructed {
        byte[] realContent;

        protected ConstructedOctet(int n, byte[] byArray) {
            this.setTagClass((byte)-128);
            this.setTagNumber(0);
            this.addComponent(new OctetString(byArray));
        }

        protected ConstructedOctet(byte[] byArray) throws Asn1Exception {
            this.doDecode(byArray);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                int n = 0;
                while (n < this.components.size()) {
                    byteArrayOutputStream.write(((OctetString)this.components.elementAt(n)).getBytes());
                    ++n;
                }
                this.realContent = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

