/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms.v1;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Constructed;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.SetOf;
import com.dstc.security.cms.v1.EncryptedContentInfo;
import com.dstc.security.cms.v1.OriginatorInfo;
import com.dstc.security.cms.v1.RecipientInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public final class EnvelopedData
extends Sequence {
    private int version;
    private OriginatorInfo originatorInfo;
    private Set recipientInfos;
    private EncryptedContentInfo encryptedContentInfo;

    public EnvelopedData(int n, OriginatorInfo originatorInfo, Set set, EncryptedContentInfo encryptedContentInfo) {
        this.version = n;
        this.addComponent(new Integer(n));
        if (originatorInfo != null) {
            this.originatorInfo = originatorInfo;
        }
        this.recipientInfos = set;
        SetOf setOf = new SetOf();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            setOf.addComponent((RecipientInfo)iterator.next());
        }
        this.addComponent(setOf);
        this.encryptedContentInfo = encryptedContentInfo;
        this.addComponent(this.encryptedContentInfo);
    }

    public EnvelopedData(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        int n = 0;
        this.version = ((Integer)this.components.elementAt(n++)).getInt();
        Constructed constructed = (Constructed)this.components.elementAt(n);
        if (constructed.getTagNumber() == 0) {
            this.originatorInfo = new OriginatorInfo(constructed.encode());
        }
        this.recipientInfos = new HashSet();
        int n2 = ++n;
        ++n;
        SetOf setOf = (SetOf)this.components.elementAt(n2);
        Vector vector = setOf.getComponents();
        int n3 = 0;
        while (n3 < vector.size()) {
            this.recipientInfos.add(new RecipientInfo(((Asn1)vector.elementAt(n3)).encode()));
            ++n3;
        }
        this.encryptedContentInfo = new EncryptedContentInfo(((Asn1)this.components.elementAt(n++)).encode());
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public OriginatorInfo getOriginatorInfo() {
        return this.originatorInfo;
    }

    public Set getRecipientInfos() {
        return this.recipientInfos;
    }
}

