/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms.v1;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.X500Name;
import com.dstc.security.x509.X509CertImpl;
import java.math.BigInteger;
import java.security.cert.X509Certificate;

public final class IssuerAndSerialNumber
extends Sequence {
    private X500Name issuer;
    private BigInteger serialNumber;

    public IssuerAndSerialNumber(X509Certificate x509Certificate) {
        try {
            this.issuer = (X500Name)new X509CertImpl(x509Certificate.getEncoded()).getIssuerDN();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.addComponent(this.issuer);
        this.serialNumber = x509Certificate.getSerialNumber();
        this.addComponent(new Integer(this.serialNumber));
    }

    public IssuerAndSerialNumber(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        this.issuer = new X500Name(((Asn1)this.components.elementAt(0)).encode());
        this.serialNumber = ((Integer)this.components.elementAt(1)).getBigInteger();
    }

    public boolean equals(IssuerAndSerialNumber issuerAndSerialNumber) {
        return this.serialNumber.equals(issuerAndSerialNumber.getSerialNumber()) && this.issuer.equals(issuerAndSerialNumber.getIssuer());
    }

    public X500Name getIssuer() {
        return this.issuer;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }
}

