/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms.v1;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.cms.v1.IssuerAndSerialNumber;
import com.dstc.security.x509.AlgorithmId;

public final class RecipientInfo
extends Sequence {
    private int version;
    private IssuerAndSerialNumber rid;
    private AlgorithmId keyEncryptionAlgo;
    private byte[] encryptedKey;

    public RecipientInfo(IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmId algorithmId, byte[] byArray) {
        this.addComponent(new Integer(this.version));
        this.rid = issuerAndSerialNumber;
        this.addComponent(issuerAndSerialNumber);
        this.keyEncryptionAlgo = algorithmId;
        this.addComponent(algorithmId);
        this.encryptedKey = byArray;
        this.addComponent(new OctetString(byArray));
    }

    public RecipientInfo(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        int n = 0;
        this.version = ((Integer)this.components.elementAt(n++)).getInt();
        this.rid = new IssuerAndSerialNumber(((Asn1)this.components.elementAt(n++)).encode());
        this.keyEncryptionAlgo = new AlgorithmId(((Asn1)this.components.elementAt(n++)).encode());
        this.encryptedKey = ((OctetString)this.components.elementAt(n)).getBytes();
    }

    public byte[] getEncryptedKey() {
        return (byte[])this.encryptedKey.clone();
    }

    public AlgorithmId getKeyEncryptionAlgo() {
        return this.keyEncryptionAlgo;
    }

    public IssuerAndSerialNumber getRecipientIdentifier() {
        return this.rid;
    }
}

