/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms.v1;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Constructed;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.SetOf;
import com.dstc.security.cms.v1.CRLSet;
import com.dstc.security.cms.v1.CertificateSet;
import com.dstc.security.cms.v1.EncapContentInfo;
import com.dstc.security.cms.v1.SignerInfo;
import com.dstc.security.provider.OID;
import com.dstc.security.x509.AlgorithmId;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public final class SignedData
extends Sequence {
    private int version = 1;
    private Set digestAlgos;
    private EncapContentInfo contentInfo;
    private Set certificates;
    private Set crls;
    private Set signerInfos;

    public SignedData(Set set, EncapContentInfo encapContentInfo, Set set2, Set set3, Set set4) {
        if (!encapContentInfo.getContentType().equals("1.2.840.113549.1.7.1")) {
            this.version = 3;
        }
        this.addComponent(new Integer(this.version));
        this.digestAlgos = set;
        SetOf setOf = new SetOf();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            setOf.addComponent(new AlgorithmId(OID.getAlgOid((String)iterator.next())));
        }
        this.addComponent(setOf);
        this.contentInfo = encapContentInfo;
        this.addComponent(this.contentInfo);
        try {
            SetOf setOf2;
            if (set2 != null) {
                this.certificates = set2;
                setOf2 = new CertificateSet(set2);
                setOf2.setTagNumber(0);
                setOf2.setTagClass((byte)-128);
                this.addComponent(setOf2);
            }
            if (set3 != null) {
                this.crls = set3;
                setOf2 = new CRLSet(set3);
                setOf2.setTagNumber(1);
                setOf2.setTagClass((byte)-128);
                this.addComponent(setOf2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.signerInfos = set4;
        setOf = new SetOf();
        iterator = set4.iterator();
        while (iterator.hasNext()) {
            setOf.addComponent((SignerInfo)iterator.next());
        }
        this.addComponent(setOf);
    }

    public SignedData(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        int n = 0;
        this.version = ((Integer)this.components.elementAt(n++)).getInt();
        this.digestAlgos = new HashSet();
        SetOf setOf = (SetOf)this.components.elementAt(n++);
        Vector vector = setOf.getComponents();
        int n2 = 0;
        while (n2 < vector.size()) {
            this.digestAlgos.add(new AlgorithmId(((Asn1)vector.elementAt(n2)).encode()));
            ++n2;
        }
        this.contentInfo = new EncapContentInfo(((Asn1)this.components.elementAt(n++)).encode());
        try {
            if (((Constructed)this.components.elementAt(n)).getTagNumber() == 0) {
                this.certificates = new CertificateSet(((Asn1)this.components.elementAt(n)).encode()).getCerts();
                ++n;
            }
        }
        catch (ClassCastException classCastException) {}
        try {
            if (((Constructed)this.components.elementAt(n)).getTagNumber() == 1) {
                this.crls = new CRLSet(((Asn1)this.components.elementAt(n)).encode()).getCRLs();
            }
        }
        catch (ClassCastException classCastException) {}
        this.signerInfos = new HashSet();
        int n3 = ++n;
        ++n;
        setOf = (SetOf)this.components.elementAt(n3);
        vector = setOf.getComponents();
        int n4 = 0;
        while (n4 < vector.size()) {
            this.signerInfos.add(new SignerInfo(((Asn1)vector.elementAt(n4)).encode()));
            ++n4;
        }
    }

    public Set getCRLs() {
        return this.crls;
    }

    public Set getCertificates() {
        return this.certificates;
    }

    public EncapContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public Set getSignerInfos() {
        return this.signerInfos;
    }
}

