/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.cms.v1;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.cms.v1.IssuerAndSerialNumber;
import com.dstc.security.cms.v1.SignedAttributes;
import com.dstc.security.provider.OID;
import com.dstc.security.x509.AlgorithmId;
import java.util.Set;

public final class SignerInfo
extends Sequence {
    private int version = 2;
    private IssuerAndSerialNumber issuer;
    private AlgorithmId digestAlgo;
    private AlgorithmId signatureAlgo;
    private SignedAttributes signedAtts;
    private byte[] signature;

    public SignerInfo(IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmId algorithmId, Set set, String string, byte[] byArray) {
        try {
            this.addComponent(new Integer(this.version));
            this.issuer = issuerAndSerialNumber;
            this.addComponent(issuerAndSerialNumber);
            this.digestAlgo = algorithmId;
            this.addComponent(algorithmId);
            this.signedAtts = new SignedAttributes(set);
            this.signedAtts.setTagNumber(0);
            this.signedAtts.setTagClass((byte)-128);
            this.addComponent(this.signedAtts);
            this.signatureAlgo = string.equals("SHA-1/DSA") ? new AlgorithmId(OID.getAlgOid(string), false) : new AlgorithmId(OID.getAlgOid(string));
            this.addComponent(this.signatureAlgo);
            this.signature = byArray;
            this.addComponent(new OctetString(byArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public SignerInfo(byte[] byArray) throws Asn1Exception {
        this.doDecode(byArray);
        int n = 0;
        this.version = ((Integer)this.components.elementAt(n++)).getInt();
        this.issuer = new IssuerAndSerialNumber(((Asn1)this.components.elementAt(n++)).encode());
        this.digestAlgo = new AlgorithmId(((Asn1)this.components.elementAt(n++)).encode());
        this.signedAtts = new SignedAttributes(((Asn1)this.components.elementAt(n++)).encode());
        this.signatureAlgo = new AlgorithmId(((Asn1)this.components.elementAt(n++)).encode());
        this.signature = ((OctetString)this.components.elementAt(n)).getBytes();
    }

    public String getDigestAlgorithm() {
        return OID.getAlgName(this.digestAlgo.getOid());
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.issuer;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public String getSignatureAlgorithm() {
        return OID.getAlgName(this.signatureAlgo.getOid());
    }

    public Set getSignedAttributes() {
        return this.signedAtts.getAttributes();
    }

    public byte[] getToBeSigned() {
        return this.signedAtts.encode();
    }
}

