/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.kerberos.ApplicationRequest;
import com.dstc.security.kerberos.KerberosMessage;
import com.dstc.security.kerberos.RequestOptions;
import com.dstc.security.kerberos.crypto.KerberosCipher;
import com.dstc.security.kerberos.crypto.KeyMaterial;
import com.dstc.security.kerberos.v5.KDCReqBody;
import com.dstc.security.kerberos.v5.KrbASReq;
import com.dstc.security.kerberos.v5.base.HostAddresses;
import com.dstc.security.kerberos.v5.base.KerberosTime;
import com.dstc.security.kerberos.v5.base.PrincipalName;
import com.dstc.security.kerberos.v5.base.Realm;
import com.dstc.security.kerberos.v5.crypto.EncryptionType;
import java.util.StringTokenizer;
import java.util.Vector;

public class ASRequest
extends KerberosMessage {
    private RequestOptions reqOptions = null;
    private String cRealm = null;
    private PrincipalName cName = null;
    private PrincipalName sName = null;
    private KrbASReq req = null;
    private int cksumType;
    private KerberosCipher cipher = null;
    private int nonce;
    private Vector adds;
    private EncryptionType etype = null;
    private KerberosTime from = null;
    private KerberosTime till = null;
    private KerberosTime rtime = null;
    private ApplicationRequest appReq = null;

    public ASRequest(KeyMaterial keyMaterial, RequestOptions requestOptions) {
        try {
            this.cksumType = keyMaterial.getKeyType();
            int n = keyMaterial.getKeyType();
            Vector<Integer> vector = new Vector<Integer>();
            if (n != 1) {
                vector.addElement(new Integer(n));
            }
            vector.addElement(new Integer(1));
            this.etype = new EncryptionType(vector);
            this.reqOptions = requestOptions;
            this.adds = new Vector();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addAddress(String string) {
        this.adds.addElement(string);
    }

    public byte[] getEncoded() {
        KDCReqBody kDCReqBody = new KDCReqBody(this.reqOptions.getOptions(), this.cName, new Realm(this.cRealm), this.sName, this.from, this.till, this.rtime, this.nonce, this.etype, new HostAddresses(this.adds), null, null);
        this.req = new KrbASReq(kDCReqBody, null);
        return this.req.encode();
    }

    public void setClientName(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        this.cName = new PrincipalName(1, vector);
    }

    public void setClientRealm(String string) {
        this.cRealm = string;
    }

    public void setNonce(int n) {
        this.nonce = n;
    }

    public void setServerName(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        this.sName = new PrincipalName(2, vector);
    }

    public void setTicketValidity(int n) {
        this.till = new KerberosTime(n);
    }
}

