/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.KerberosMessage;
import com.dstc.security.kerberos.creds.CredentialInfo;
import com.dstc.security.kerberos.creds.KerberosTicket;
import com.dstc.security.kerberos.crypto.CryptoException;
import com.dstc.security.kerberos.crypto.KerberosCipher;
import com.dstc.security.kerberos.crypto.KeyMaterial;
import com.dstc.security.kerberos.v5.BadMessageTypeException;
import com.dstc.security.kerberos.v5.BadVersionException;
import com.dstc.security.kerberos.v5.EncASRepPart;
import com.dstc.security.kerberos.v5.EncKDCRepPart;
import com.dstc.security.kerberos.v5.KrbASRep;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;
import java.util.Date;

public class ASResponse
extends KerberosMessage {
    private KrbASRep rep = null;
    private KerberosCipher cipher = null;
    private EncASRepPart encASRepPart = null;
    private EncryptedData encData = null;

    public ASResponse(byte[] byArray) throws Asn1Exception, BadVersionException, BadMessageTypeException {
        this.rep = new KrbASRep(byArray);
        this.encData = this.rep.getKDCRep().getEncrypted();
    }

    public void decrypt() throws Asn1Exception, CryptoException, KerberosException, BadMessageTypeException {
        if (this.cipher == null) {
            throw new KerberosException("Cipher not yet set");
        }
        this.encASRepPart = new EncASRepPart(this.cipher.decrypt(this.encData));
    }

    public CredentialInfo getCredentialInfo() {
        EncKDCRepPart encKDCRepPart = this.encASRepPart.getEncKDCRepPart();
        return new CredentialInfo(encKDCRepPart.getEncryptionKey(), this.rep.getKDCRep().getClientRealm(), this.rep.getKDCRep().getClientName(), encKDCRepPart.getTicketFlags(), encKDCRepPart.getAuthTime(), encKDCRepPart.getStartTime(), encKDCRepPart.getEndTime(), encKDCRepPart.getRenewTill(), encKDCRepPart.getServerRealm(), encKDCRepPart.getServerName(), encKDCRepPart.getClientAddresses());
    }

    public byte[] getEncoded() {
        return this.rep.encode();
    }

    public Date getKeyExpiryTime() {
        return this.encASRepPart.getEncKDCRepPart().getKeyExpiryTime().getDate();
    }

    public int getNonce() {
        return this.encASRepPart.getEncKDCRepPart().getNonce();
    }

    public String getServerName() {
        return this.encASRepPart.getEncKDCRepPart().getServerName().toString();
    }

    public String getServerRealm() {
        return this.encASRepPart.getEncKDCRepPart().getServerRealm().getName();
    }

    public KerberosTicket getTicket() {
        return new KerberosTicket(this.rep.getKDCRep().getTicket());
    }

    public void initDecrypt(KeyMaterial keyMaterial, String string) throws CryptoException {
        KerberosCipher kerberosCipher = new KerberosCipher(keyMaterial, null, string);
        kerberosCipher.initDecrypt();
        this.cipher = kerberosCipher;
    }
}

