/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.KerberosMessage;
import com.dstc.security.kerberos.creds.Credential;
import com.dstc.security.kerberos.creds.KerberosTicket;
import com.dstc.security.kerberos.crypto.CryptoException;
import com.dstc.security.kerberos.crypto.KerberosCipher;
import com.dstc.security.kerberos.crypto.KeyMaterial;
import com.dstc.security.kerberos.v5.APReq;
import com.dstc.security.kerberos.v5.BadMessageTypeException;
import com.dstc.security.kerberos.v5.BadVersionException;
import com.dstc.security.kerberos.v5.base.APOptions;
import com.dstc.security.kerberos.v5.base.KerberosTime;
import com.dstc.security.kerberos.v5.base.PrincipalName;
import com.dstc.security.kerberos.v5.base.Realm;
import com.dstc.security.kerberos.v5.creds.Authenticator;
import com.dstc.security.kerberos.v5.creds.Ticket;
import com.dstc.security.kerberos.v5.crypto.Checksum;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;
import com.dstc.security.kerberos.v5.crypto.EncryptionKey;
import java.security.SecureRandom;
import java.util.Date;

public class ApplicationRequest
extends KerberosMessage {
    private String realm = null;
    private int checksumType;
    private byte[] checksumBytes = null;
    private int cusec = 0;
    private int seqNum = -1;
    private KerberosTime ctime = null;
    private APReq apReq = null;
    private KerberosCipher cipher = null;
    private EncryptedData encData = null;
    private Authenticator auth = null;
    private Ticket ticket = null;
    private PrincipalName clientName = null;
    private boolean useSessionKey = false;
    private boolean mutualAuthRequired = false;

    public ApplicationRequest(Credential credential, SecureRandom secureRandom) throws CryptoException {
        this.cipher = new KerberosCipher(credential, secureRandom, null);
        this.cipher.initEncrypt();
        this.setTicket(credential.getTicket());
        this.setClientName(credential.getClientName());
    }

    public ApplicationRequest(byte[] byArray) throws Asn1Exception, BadMessageTypeException, BadVersionException {
        this.apReq = new APReq(byArray);
        this.encData = this.apReq.getEncrypted();
        this.ticket = this.apReq.getTicket();
        this.useSessionKey = this.apReq.getAPOptions().isUsingSessionKey();
        this.mutualAuthRequired = this.apReq.getAPOptions().isMutualAuthRequired();
    }

    public void decrypt() throws KerberosException, CryptoException, Asn1Exception, BadMessageTypeException {
        if (this.cipher == null) {
            throw new KerberosException("Cipher not yet set");
        }
        this.auth = new Authenticator(this.cipher.decrypt(this.encData));
    }

    public void encrypt() throws KerberosException, CryptoException, Asn1Exception, BadMessageTypeException {
        if (this.cipher == null) {
            throw new KerberosException("Cipher not yet set");
        }
        this.auth = new Authenticator(new Realm(this.realm), this.clientName, new Checksum(this.checksumType, this.checksumBytes), this.cusec, this.ctime, null, this.seqNum, null);
        this.encData = this.cipher.encrypt(this.auth.encode());
        this.apReq = new APReq(new APOptions(this.useSessionKey, this.mutualAuthRequired), this.ticket, this.encData);
    }

    public byte[] getChecksumBytes() {
        return this.auth.getChecksum().getBytes();
    }

    public String getClientName() {
        return this.auth.getClientName().toString();
    }

    public Date getClientTime() {
        return this.auth.getCTime().getDate();
    }

    public int getCusec() {
        return this.auth.getCusec();
    }

    public byte[] getEncoded() {
        return this.apReq.encode();
    }

    public byte[] getEncodedClientName() {
        return this.auth.getClientName().encode();
    }

    public int getSequenceNumber() {
        return this.auth.getSeqNumber();
    }

    public byte[] getSubKeyBytes() {
        if (this.auth == null) {
            return null;
        }
        EncryptionKey encryptionKey = this.auth.getSubKey();
        if (encryptionKey != null) {
            return encryptionKey.getKeyBytes();
        }
        return null;
    }

    public KerberosTicket getTicket() {
        return new KerberosTicket(this.ticket);
    }

    public void initDecrypt(KeyMaterial keyMaterial) throws CryptoException {
        KerberosCipher kerberosCipher = new KerberosCipher(keyMaterial, null, null);
        kerberosCipher.initDecrypt();
        this.cipher = kerberosCipher;
    }

    public boolean isMutualAuthRequired() {
        return this.mutualAuthRequired;
    }

    public boolean isUsingSessionKey() {
        return this.useSessionKey;
    }

    public void setChecksum(byte[] byArray) {
        this.checksumBytes = byArray;
    }

    public void setChecksumType(int n) {
        this.checksumType = n;
    }

    public void setClientName(byte[] byArray) {
        try {
            this.clientName = new PrincipalName(byArray);
        }
        catch (Asn1Exception asn1Exception) {
            asn1Exception.printStackTrace();
        }
    }

    public void setClientTime(Date date) {
        this.ctime = new KerberosTime(date);
    }

    public void setCusec(int n) {
        this.cusec = n;
    }

    public void setMutualAuthRequired(boolean bl) {
        this.mutualAuthRequired = bl;
    }

    public void setRealm(String string) {
        this.realm = string;
    }

    public void setSequenceNumber(int n) {
        this.seqNum = n;
    }

    public void setTicket(KerberosTicket kerberosTicket) {
        try {
            this.ticket = new Ticket(kerberosTicket.getEncoded());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setUseSessionKey(boolean bl) {
        this.useSessionKey = bl;
    }
}

