/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.KerberosMessage;
import com.dstc.security.kerberos.crypto.CryptoException;
import com.dstc.security.kerberos.crypto.KerberosCipher;
import com.dstc.security.kerberos.crypto.KeyMaterial;
import com.dstc.security.kerberos.v5.APRep;
import com.dstc.security.kerberos.v5.BadMessageTypeException;
import com.dstc.security.kerberos.v5.BadVersionException;
import com.dstc.security.kerberos.v5.EncAPRepPart;
import com.dstc.security.kerberos.v5.base.KerberosTime;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;
import java.security.SecureRandom;
import java.util.Date;

public class ApplicationResponse
extends KerberosMessage {
    private APRep rep = null;
    private KerberosCipher cipher = null;
    private EncAPRepPart encAPRepPart = null;
    private EncryptedData encData = null;
    private KerberosTime clientTime = null;
    private int cusec;
    private int seqNum;
    private byte[] key = null;

    public ApplicationResponse(KeyMaterial keyMaterial, SecureRandom secureRandom) throws CryptoException {
        this.cipher = new KerberosCipher(keyMaterial, secureRandom, null);
        this.cipher.initEncrypt();
    }

    public ApplicationResponse(byte[] byArray) throws Asn1Exception, BadVersionException, BadMessageTypeException {
        this.rep = new APRep(byArray);
        this.encData = this.rep.getEncrypted();
    }

    public void decrypt() throws Asn1Exception, CryptoException, KerberosException, BadMessageTypeException {
        if (this.cipher == null) {
            throw new KerberosException("Cipher not yet set");
        }
        this.encAPRepPart = new EncAPRepPart(this.cipher.decrypt(this.encData));
    }

    public void encrypt() throws CryptoException, KerberosException {
        if (this.cipher == null) {
            throw new KerberosException("Cipher not yet set");
        }
        this.encAPRepPart = new EncAPRepPart(this.clientTime, this.cusec, null, this.seqNum);
        this.encData = this.cipher.encrypt(this.encAPRepPart.encode());
        this.rep = new APRep(this.encData);
    }

    public Date getClientTime() {
        return this.encAPRepPart.getClientTime().getDate();
    }

    public int getCusec() {
        return this.encAPRepPart.getCusec();
    }

    public byte[] getEncoded() {
        return this.rep.encode();
    }

    public int getSequenceNumber() {
        return this.encAPRepPart.getSequenceNumber();
    }

    public byte[] getSubSessionKey() {
        return this.encAPRepPart.getEncryptionKey().getKeyBytes();
    }

    public void initDecrypt(KeyMaterial keyMaterial) throws CryptoException {
        KerberosCipher kerberosCipher = new KerberosCipher(keyMaterial, null, null);
        kerberosCipher.initDecrypt();
        this.cipher = kerberosCipher;
    }

    public void setClientTime(Date date) {
        this.clientTime = new KerberosTime(date);
    }

    public void setCusec(int n) {
        this.cusec = n;
    }

    public void setSequenceNumber(int n) {
        this.seqNum = n;
    }
}

