/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.kerberos.ASRequest;
import com.dstc.security.kerberos.ASResponse;
import com.dstc.security.kerberos.KerberosContext;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.KerberosMessageFactory;
import com.dstc.security.kerberos.TGSRequest;
import com.dstc.security.kerberos.TGSResponse;
import com.dstc.security.kerberos.creds.Credential;
import com.dstc.security.kerberos.creds.CredentialInfo;
import com.dstc.security.kerberos.creds.CredentialStore;
import com.dstc.security.kerberos.creds.KeyTab;
import com.dstc.security.kerberos.crypto.CryptoException;
import com.dstc.security.kerberos.crypto.KerberosKey;
import com.dstc.security.kerberos.crypto.KeyMaterial;
import com.dstc.security.util.Config;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Kerberos {
    private static final String KRB_CONF = "jcsi.kerberos.conf";
    private static final String KRB_PROPERTIES = "kerberos.properties";
    private static final String KRBTGT = "krbtgt";
    private static Kerberos instance;
    private static KerberosContext ctx;
    private String localAddress = null;
    private DatagramSocket sock = null;
    private byte[] buffer = new byte[1500];
    private static CredentialStore credStore;
    private SecureRandom rand = new SecureRandom(new byte[8]);

    static {
        block2: {
            instance = null;
            ctx = null;
            if (instance != null) break block2;
            try {
                Properties properties = Config.getProperties(KRB_CONF, KRB_PROPERTIES);
                ctx = new KerberosContext(properties);
                instance = new Kerberos();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    Kerberos() throws IOException {
        this.localAddress = InetAddress.getLocalHost().getHostAddress();
    }

    public static Kerberos getDefault() {
        return instance;
    }

    public Credential getDelegationCredential(Credential credential, String string) throws IOException, KerberosException, CryptoException, Asn1Exception {
        CredentialInfo credentialInfo = credential.getCredentialInfo();
        boolean bl = credentialInfo.getTicketFlags().isOn("FORWARDABLE");
        boolean bl2 = credentialInfo.getTicketFlags().isOn("PROXIABLE");
        String string2 = "krbtgt/" + ctx.getRealm() + "@" + ctx.getRealm();
        return this.getServiceTicket(credential, string2, string);
    }

    public Credential getDelegationCredential(String string) throws IOException, KerberosException, CryptoException, Asn1Exception {
        Credential credential = this.getTGTCredential();
        return this.getDelegationCredential(credential, string);
    }

    public KerberosContext getKerberosContext() {
        return ctx;
    }

    public Credential getServiceTicket(Credential credential, String string) throws KerberosException, IOException, CryptoException, Asn1Exception {
        return this.getServiceTicket(credential, string, null);
    }

    public Credential getServiceTicket(Credential credential, String string, String string2) throws KerberosException, IOException, CryptoException, Asn1Exception {
        String string3 = string.substring(0, string.indexOf(64));
        this.requestServiceTicket(credential, string3, string2);
        return credStore.getCredential(string);
    }

    public Credential getTGTCredential() throws IOException {
        if (credStore == null) {
            credStore = CredentialStore.getDefault();
        }
        String string = ctx.getRealm();
        return credStore.getCredential("krbtgt/" + string + "@" + string);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        while (n < stringArray.length) {
            if ("-j".equalsIgnoreCase(stringArray[n])) {
                if (bl2) {
                    bl3 = true;
                    System.err.println("Error: duplicate -j options");
                    break;
                }
                if (bl) {
                    bl3 = true;
                    System.err.println("Error: conflicting -j and -k options");
                    break;
                }
                bl2 = true;
                string4 = stringArray[++n];
            } else if ("-k".equalsIgnoreCase(stringArray[n])) {
                if (bl) {
                    bl3 = true;
                    System.err.println("Error: duplicate -k options");
                    break;
                }
                if (bl2) {
                    bl3 = true;
                    System.err.println("Error: conflicting -c and -k options");
                    break;
                }
                if (n == stringArray.length - 1) {
                    bl3 = true;
                    System.err.println("Error: no keytab specified");
                    break;
                }
                bl = true;
                string2 = stringArray[++n];
            } else if ("-c".equalsIgnoreCase(stringArray[n])) {
                if (n == stringArray.length - 1) {
                    bl3 = true;
                    System.err.println("Error: no cache file specified");
                    break;
                }
                string3 = stringArray[++n];
            } else if (n == stringArray.length - 1) {
                string = stringArray[n];
            } else {
                System.err.println("Ignoring invalid argument " + stringArray[n]);
            }
            ++n;
        }
        if (!bl3 && string == null) {
            string = ctx.getUsername();
            if (string == null) {
                bl3 = true;
                System.err.println("Error: I don't know who the user is");
            }
        } else {
            ctx.setUsername(string);
        }
        if (bl3) {
            System.err.println("Usage jinit [-j | -k keytab] [-c cache] [user]");
            System.err.println("  -j provider Use a javacard with provider specified");
            System.err.println("  -k keytab   Use the keytab specified");
            System.err.println("  -c cache    Use the credential cache specified");
            System.err.println("  user        Principal name");
            System.exit(1);
        }
        if (string3 != null) {
            ctx.setCCName(string3);
        }
        try {
            Kerberos kerberos = Kerberos.getDefault();
            if (bl2) {
                kerberos.requestTGTWithJavaCard(string, string4);
            } else if (bl) {
                kerberos.requestTGTWithKeytab(string, string2);
            } else {
                String string5 = "Enter password for " + string + "@" + kerberos.getKerberosContext().getRealm() + ": ";
                System.out.print(string5);
                InputStreamReader inputStreamReader = new InputStreamReader(System.in);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string6 = bufferedReader.readLine();
                if (string6 == null || string6.equals("")) {
                    System.err.println("Invalid password");
                    System.exit(1);
                }
                kerberos.requestTGTWithPassword(string, string6);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void requestInitialTicket(KeyMaterial keyMaterial, String string, String string2) throws IOException, KerberosException, CryptoException, Asn1Exception {
        this.requestInitialTicket(keyMaterial, string, string2, null);
    }

    public void requestInitialTicket(KeyMaterial keyMaterial, String string, String string2, String string3) throws IOException, KerberosException, CryptoException, Asn1Exception {
        String string4 = "krbtgt/" + ctx.getRealm();
        int n = this.rand.nextInt();
        if (string2 == null) {
            string2 = this.localAddress;
        }
        ASRequest aSRequest = new ASRequest(keyMaterial, ctx.getDefaultOptions());
        aSRequest.setClientRealm(ctx.getRealm());
        aSRequest.setClientName(string);
        aSRequest.setServerName(string4);
        aSRequest.addAddress(string2);
        aSRequest.setNonce(n);
        aSRequest.setTicketValidity(ctx.getDefTicketLife());
        ASResponse aSResponse = (ASResponse)KerberosMessageFactory.getKDCMessage(this.sendRequest(aSRequest.getEncoded()));
        aSResponse.initDecrypt(keyMaterial, string3);
        aSResponse.decrypt();
        Credential credential = new Credential(aSResponse.getCredentialInfo(), aSResponse.getTicket());
        if (credStore == null) {
            credStore = CredentialStore.getDefault();
        }
        credStore.put(credential);
    }

    public void requestServiceTicket(Credential credential, String string, String string2) throws IOException, KerberosException, CryptoException, Asn1Exception {
        int n = this.rand.nextInt();
        if (string2 == null) {
            string2 = this.localAddress;
        }
        TGSRequest tGSRequest = new TGSRequest(credential, ctx.getDefaultOptions(), this.rand);
        tGSRequest.setClientRealm(ctx.getRealm());
        tGSRequest.setServerName(string);
        tGSRequest.addAddress(string2);
        tGSRequest.setNonce(n);
        tGSRequest.setTicketValidity(ctx.getDefTicketLife());
        tGSRequest.encrypt();
        TGSResponse tGSResponse = (TGSResponse)KerberosMessageFactory.getKDCMessage(this.sendRequest(tGSRequest.getEncoded()));
        tGSResponse.initDecrypt(credential);
        tGSResponse.decrypt();
        Credential credential2 = new Credential(tGSResponse.getCredentialInfo(), tGSResponse.getTicket());
        if (credStore == null) {
            credStore = CredentialStore.getDefault();
        }
        credStore.put(credential2);
    }

    public void requestServiceTicket(String string) throws IOException, KerberosException, CryptoException, Asn1Exception {
        Credential credential = this.getTGTCredential();
        this.requestServiceTicket(credential, string, null);
    }

    public void requestTGTWithJavaCard(String string, String string2) throws IOException, KerberosException, CryptoException, Asn1Exception {
        KerberosKey kerberosKey = new KerberosKey(3, new byte[8]);
        this.requestInitialTicket(kerberosKey, string, null, string2);
    }

    public void requestTGTWithKeytab(String string, String string2) throws IOException, KerberosException, CryptoException, Asn1Exception {
        this.requestTGTWithKeytab(string, string2, null);
    }

    public void requestTGTWithKeytab(String string, String string2, String string3) throws IOException, KerberosException, CryptoException, Asn1Exception {
        ctx.setKeyTabName(string2);
        KeyTab keyTab = KeyTab.getDefault();
        this.requestInitialTicket(keyTab.getKeyTabEntry(string), string, string3);
    }

    public void requestTGTWithPassword(String string, String string2) throws IOException, KerberosException, CryptoException, Asn1Exception {
        this.requestTGTWithPassword(string, string2, null);
    }

    public void requestTGTWithPassword(String string, String string2, String string3) throws IOException, KerberosException, CryptoException, Asn1Exception {
        StringBuffer stringBuffer = new StringBuffer(string2);
        stringBuffer.append(ctx.getRealm());
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        KerberosKey kerberosKey = new KerberosKey(1, stringBuffer.toString());
        this.requestInitialTicket(kerberosKey, string, string3);
    }

    private byte[] sendRequest(byte[] byArray) throws IOException {
        this.sock = new DatagramSocket();
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, ctx.getKDCAddress(), ctx.getKDCPort());
        this.sock.send(datagramPacket);
        DatagramPacket datagramPacket2 = new DatagramPacket(this.buffer, 1500);
        this.sock.receive(datagramPacket2);
        return datagramPacket2.getData();
    }
}

