/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.RequestOptions;
import com.dstc.security.kerberos.v5.crypto.EncryptionType;
import java.io.File;
import java.net.InetAddress;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class KerberosContext {
    private String realmName;
    private InetAddress kdcAddr;
    private int kdcPort;
    private EncryptionType etype;
    private RequestOptions defOptions;
    private int defTktLife;
    private int defRenewTime;
    private String userName;
    private int ccType;
    private String ccName;
    private String keyTabName;

    public KerberosContext(String string, Properties properties) throws KerberosException {
        this.buildContext(string, properties);
    }

    public KerberosContext(Properties properties) throws KerberosException {
        this.realmName = properties.getProperty("jcsi.krb5.default.realm");
        if (this.realmName == null) {
            throw new KerberosException(128);
        }
        this.buildContext(this.realmName, properties);
    }

    private void buildContext(String string, Properties properties) throws KerberosException {
        this.realmName = string;
        String string2 = properties.getProperty("jcsi.krb5.default.options");
        if (string2 != null) {
            this.defOptions = new RequestOptions(string2);
        }
        string2 = properties.getProperty("jcsi.krb5.default.etype");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\n\r\f,");
        Vector<Integer> vector = new Vector<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().toUpperCase();
            if (string3.equals("DES-CBC-CRC")) {
                vector.addElement(new Integer(1));
                continue;
            }
            if (string3.equals("DES-CBC-MD4")) {
                vector.addElement(new Integer(2));
                continue;
            }
            if (!string3.equals("DES-CBC-MD5")) continue;
            vector.addElement(new Integer(3));
        }
        if (vector.isEmpty()) {
            vector.addElement(new Integer(1));
        }
        this.etype = new EncryptionType(vector);
        string2 = properties.getProperty("jcsi.krb5.default.ticket.lifetime");
        this.defTktLife = KerberosContext.parseTime(string2, 10);
        string2 = properties.getProperty("jcsi.krb5.default.ticket.renewtime");
        this.defRenewTime = KerberosContext.parseTime(string2, 168);
        try {
            this.kdcAddr = InetAddress.getByName(properties.getProperty("jcsi.kdc.host." + this.realmName));
            this.kdcPort = Integer.parseInt(properties.getProperty("jcsi.kdc.port." + this.realmName));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new KerberosException(128);
        }
        String string4 = properties.getProperty("jcsi.kerberos.key.dir");
        if (string4 == null) {
            throw new KerberosException(128);
        }
        String string5 = properties.getProperty("jcsi.kerberos.ccache");
        if (string5 == null) {
            string5 = "krb5.ccache";
        }
        this.ccName = String.valueOf(string4) + File.separator + string5;
        string5 = properties.getProperty("jcsi.kerberos.keytab");
        if (string5 == null) {
            string5 = "krb5.keytab";
        }
        this.keyTabName = String.valueOf(string4) + File.separator + string5;
        try {
            this.userName = System.getProperty("user.name");
        }
        catch (Exception exception) {}
    }

    public String getCCName() {
        return this.ccName;
    }

    public int getDefRenewTime() {
        return this.defRenewTime;
    }

    public int getDefTicketLife() {
        return this.defTktLife;
    }

    public RequestOptions getDefaultOptions() {
        return this.defOptions;
    }

    public Vector getEncType() {
        return this.etype.getTypes();
    }

    public InetAddress getKDCAddress() {
        return this.kdcAddr;
    }

    public int getKDCPort() {
        return this.kdcPort;
    }

    public String getKeyTabName() {
        return this.keyTabName;
    }

    public String getRealm() {
        return this.realmName;
    }

    public String getUsername() {
        return this.userName;
    }

    private static int parseTime(String string, int n) {
        if (string == null || string.length() < 2) {
            return n;
        }
        char c = Character.toUpperCase(string.charAt(string.length() - 1));
        if (c != 'D' && c != 'H') {
            return n;
        }
        String string2 = string.substring(0, string.length() - 1);
        try {
            int n2 = Integer.parseInt(string2);
            if (c == 'D') {
                n2 *= 24;
            }
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public void setCCName(String string) {
        this.ccName = string;
    }

    public void setKeyTabName(String string) {
        this.keyTabName = string;
    }

    public void setRequestOptions(RequestOptions requestOptions) {
        this.defOptions = requestOptions;
    }

    public void setUsername(String string) {
        this.userName = string;
    }
}

