/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.KerberosMessage;
import com.dstc.security.kerberos.creds.Credential;
import com.dstc.security.kerberos.creds.CredentialInfo;
import com.dstc.security.kerberos.creds.KerberosTicket;
import com.dstc.security.kerberos.crypto.CryptoException;
import com.dstc.security.kerberos.crypto.KerberosCipher;
import com.dstc.security.kerberos.crypto.KeyMaterial;
import com.dstc.security.kerberos.v5.BadMessageTypeException;
import com.dstc.security.kerberos.v5.BadVersionException;
import com.dstc.security.kerberos.v5.EncKrbCredPart;
import com.dstc.security.kerberos.v5.KrbCred;
import com.dstc.security.kerberos.v5.KrbCredInfo;
import com.dstc.security.kerberos.v5.base.KerberosTime;
import com.dstc.security.kerberos.v5.creds.Ticket;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;
import java.security.SecureRandom;
import java.util.Vector;

public class KerberosCredential
extends KerberosMessage {
    private Vector creds = null;
    private Vector tickets = null;
    private Vector credsInfo;
    private EncKrbCredPart encKrbCredPart = null;
    private EncryptedData encData = null;
    private KerberosCipher cipher = null;
    private KrbCred krbCred = null;
    private int nonce;
    private String sAddr = null;
    private String rAddr = null;

    public KerberosCredential(KeyMaterial keyMaterial, SecureRandom secureRandom) throws CryptoException {
        this.cipher = new KerberosCipher(keyMaterial, secureRandom, null);
        this.cipher.initEncrypt();
    }

    public KerberosCredential(byte[] byArray) throws Asn1Exception, BadVersionException, BadMessageTypeException {
        this.krbCred = new KrbCred(byArray);
        this.tickets = this.krbCred.getTickets();
        this.encData = this.krbCred.getEncrypted();
    }

    public void decrypt() throws Asn1Exception, CryptoException, KerberosException {
        if (this.cipher == null) {
            throw new KerberosException("Cipher not yet set");
        }
        this.encKrbCredPart = new EncKrbCredPart(this.cipher.decrypt(this.encData));
        Vector vector = this.encKrbCredPart.getCredsInfo();
        int n = vector.size() <= this.tickets.size() ? vector.size() : this.tickets.size();
        this.creds = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            this.creds.addElement(new Credential(new CredentialInfo(((KrbCredInfo)vector.elementAt(n2)).encode()), new KerberosTicket(((Ticket)this.tickets.elementAt(n2)).encode())));
            ++n2;
        }
    }

    public void encrypt() throws CryptoException {
        this.encKrbCredPart = new EncKrbCredPart(this.credsInfo, this.nonce, this.sAddr, this.rAddr);
        this.encData = this.cipher.encrypt(this.encKrbCredPart.encode());
        this.krbCred = new KrbCred(this.tickets, this.encData);
    }

    public Vector getCredentials() {
        return this.creds;
    }

    public byte[] getEncoded() {
        return this.krbCred.encode();
    }

    public int getNonce() {
        return this.encKrbCredPart.getNonce();
    }

    public String getReceiverAddress() {
        return this.encKrbCredPart.getReceiverAddress().toString();
    }

    public String getSenderAddress() {
        return this.encKrbCredPart.getSenderAddress().toString();
    }

    public KerberosTime getTimestamp() {
        return this.encKrbCredPart.getTimestamp();
    }

    public int getUsec() {
        return this.encKrbCredPart.getUsec();
    }

    public void initDecrypt(KeyMaterial keyMaterial) throws CryptoException {
        KerberosCipher kerberosCipher = new KerberosCipher(keyMaterial, null, null);
        kerberosCipher.initDecrypt();
        this.cipher = kerberosCipher;
    }

    public void setCredentials(Vector vector) throws Asn1Exception, BadVersionException {
        this.creds = vector;
        this.tickets = new Vector();
        int n = 0;
        while (n < vector.size()) {
            this.tickets.addElement(new Ticket(((Credential)vector.elementAt(n)).getTicket().getEncoded()));
            ++n;
        }
        this.credsInfo = new Vector();
        int n2 = 0;
        while (n2 < vector.size()) {
            this.credsInfo.addElement(new KrbCredInfo(((Credential)vector.elementAt(n2)).getCredentialInfo().getEncoded()));
            ++n2;
        }
    }

    public void setNonce(int n) {
        this.nonce = n;
    }

    public void setRecipientAddress(String string) {
        this.rAddr = string;
    }

    public void setSenderAddress(String string) {
        this.sAddr = string;
    }
}

