/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.kerberos.ApplicationRequest;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.KerberosMessage;
import com.dstc.security.kerberos.RequestOptions;
import com.dstc.security.kerberos.creds.Credential;
import com.dstc.security.kerberos.crypto.CryptoException;
import com.dstc.security.kerberos.crypto.KerberosCipher;
import com.dstc.security.kerberos.crypto.KerberosMac;
import com.dstc.security.kerberos.v5.KDCReqBody;
import com.dstc.security.kerberos.v5.KrbTGSReq;
import com.dstc.security.kerberos.v5.PaData;
import com.dstc.security.kerberos.v5.base.HostAddresses;
import com.dstc.security.kerberos.v5.base.KerberosTime;
import com.dstc.security.kerberos.v5.base.PrincipalName;
import com.dstc.security.kerberos.v5.base.Realm;
import com.dstc.security.kerberos.v5.crypto.EncryptionType;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;

public class TGSRequest
extends KerberosMessage {
    private RequestOptions reqOptions = null;
    private String cRealm = null;
    private PrincipalName cName = null;
    private PrincipalName sName = null;
    private KrbTGSReq req = null;
    private int cksumType;
    private KerberosCipher cipher = null;
    private int nonce;
    private Vector adds;
    private EncryptionType etype = null;
    private KerberosTime from = null;
    private KerberosTime till = null;
    private KerberosTime rtime = null;
    private ApplicationRequest appReq = null;

    public TGSRequest(Credential credential, RequestOptions requestOptions, SecureRandom secureRandom) {
        try {
            this.cksumType = 7;
            int n = credential.getKeyType();
            Vector<Integer> vector = new Vector<Integer>();
            if (n != 1) {
                vector.addElement(new Integer(n));
            }
            vector.addElement(new Integer(1));
            this.etype = new EncryptionType(vector);
            this.reqOptions = requestOptions;
            this.adds = new Vector();
            this.appReq = new ApplicationRequest(credential, secureRandom);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addAddress(String string) {
        this.adds.addElement(string);
    }

    public void encrypt() throws KerberosException, CryptoException, Asn1Exception {
        KDCReqBody kDCReqBody = new KDCReqBody(this.reqOptions.getOptions(), null, new Realm(this.cRealm), this.sName, this.from, this.till, this.rtime, this.nonce, this.etype, new HostAddresses(this.adds), null, null);
        KerberosMac kerberosMac = KerberosMac.getInstance(this.cksumType);
        kerberosMac.update(kDCReqBody.encode());
        this.appReq.setChecksumType(this.cksumType);
        this.appReq.setChecksum(kerberosMac.doFinal());
        this.appReq.setRealm(this.cRealm);
        this.appReq.setClientTime(Calendar.getInstance().getTime());
        if (this.cName != null) {
            this.appReq.setClientName(this.cName.encode());
        }
        this.appReq.encrypt();
        PaData paData = new PaData(1, this.appReq.getEncoded());
        Vector<PaData> vector = new Vector<PaData>();
        vector.addElement(paData);
        this.req = new KrbTGSReq(kDCReqBody, vector);
    }

    public byte[] getEncoded() {
        return this.req.encode();
    }

    public void setClientName(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        this.cName = new PrincipalName(1, vector);
    }

    public void setClientRealm(String string) {
        this.cRealm = string;
    }

    public void setNonce(int n) {
        this.nonce = n;
    }

    public void setServerName(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        this.sName = new PrincipalName(1, vector);
    }

    public void setTicketValidity(int n) {
        this.till = new KerberosTime(n);
    }
}

