/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.KerberosMessage;
import com.dstc.security.kerberos.creds.CredentialInfo;
import com.dstc.security.kerberos.creds.KerberosTicket;
import com.dstc.security.kerberos.crypto.CryptoException;
import com.dstc.security.kerberos.crypto.KerberosCipher;
import com.dstc.security.kerberos.crypto.KeyMaterial;
import com.dstc.security.kerberos.v5.BadMessageTypeException;
import com.dstc.security.kerberos.v5.BadVersionException;
import com.dstc.security.kerberos.v5.EncKDCRepPart;
import com.dstc.security.kerberos.v5.EncTGSRepPart;
import com.dstc.security.kerberos.v5.KrbTGSRep;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;
import java.util.Date;

public class TGSResponse
extends KerberosMessage {
    private KrbTGSRep rep = null;
    private KerberosCipher cipher = null;
    private EncTGSRepPart encTGSRepPart = null;
    private EncryptedData encData = null;

    public TGSResponse(byte[] byArray) throws Asn1Exception, BadVersionException, BadMessageTypeException {
        this.rep = new KrbTGSRep(byArray);
        this.encData = this.rep.getKDCRep().getEncrypted();
    }

    public void decrypt() throws Asn1Exception, CryptoException, KerberosException, BadMessageTypeException {
        if (this.cipher == null) {
            throw new KerberosException("Cipher not yet set");
        }
        this.encTGSRepPart = new EncTGSRepPart(this.cipher.decrypt(this.encData));
    }

    public CredentialInfo getCredentialInfo() {
        EncKDCRepPart encKDCRepPart = this.encTGSRepPart.getEncKDCRepPart();
        return new CredentialInfo(encKDCRepPart.getEncryptionKey(), this.rep.getKDCRep().getClientRealm(), this.rep.getKDCRep().getClientName(), encKDCRepPart.getTicketFlags(), encKDCRepPart.getAuthTime(), encKDCRepPart.getStartTime(), encKDCRepPart.getEndTime(), encKDCRepPart.getRenewTill(), encKDCRepPart.getServerRealm(), encKDCRepPart.getServerName(), encKDCRepPart.getClientAddresses());
    }

    public byte[] getEncoded() {
        return this.rep.encode();
    }

    public Date getKeyExpiryTime() {
        return this.encTGSRepPart.getEncKDCRepPart().getKeyExpiryTime().getDate();
    }

    public int getNonce() {
        return this.encTGSRepPart.getEncKDCRepPart().getNonce();
    }

    public String getServerName() {
        return this.encTGSRepPart.getEncKDCRepPart().getServerName().toString();
    }

    public String getServerRealm() {
        return this.encTGSRepPart.getEncKDCRepPart().getServerRealm().getName();
    }

    public KerberosTicket getTicket() {
        return new KerberosTicket(this.rep.getKDCRep().getTicket());
    }

    public void initDecrypt(KeyMaterial keyMaterial) throws CryptoException {
        KerberosCipher kerberosCipher = new KerberosCipher(keyMaterial, null, null);
        kerberosCipher.initDecrypt();
        this.cipher = kerberosCipher;
    }
}

