/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.creds;

import com.dstc.security.kerberos.creds.CCInputStream;
import com.dstc.security.kerberos.creds.CCOutputStream;
import com.dstc.security.kerberos.creds.CredentialInfo;
import com.dstc.security.kerberos.creds.CredentialName;
import com.dstc.security.kerberos.creds.KerberosTicket;
import com.dstc.security.kerberos.crypto.KeyMaterial;
import com.dstc.security.kerberos.v5.base.HostAddress;
import com.dstc.security.kerberos.v5.base.HostAddresses;
import com.dstc.security.kerberos.v5.base.KerberosTime;
import com.dstc.security.kerberos.v5.base.PrincipalName;
import com.dstc.security.kerberos.v5.base.Realm;
import com.dstc.security.kerberos.v5.base.TicketFlags;
import com.dstc.security.kerberos.v5.crypto.EncryptionKey;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.Vector;

public class Credential
implements KeyMaterial {
    private CredentialInfo credInfo;
    private CredentialName client = new CredentialName();
    private CredentialName server = new CredentialName();
    private byte sKey;
    private byte[] authData;
    private KerberosTicket ticket;
    private KerberosTicket ticket2;

    public Credential() {
    }

    public Credential(CCInputStream cCInputStream) throws IOException {
        this();
        this.client = new CredentialName(cCInputStream);
        PrincipalName principalName = new PrincipalName(this.client.getNameType(), this.client.getNameComponents());
        Realm realm = new Realm(this.client.getRealm());
        this.server = new CredentialName(cCInputStream);
        PrincipalName principalName2 = new PrincipalName(this.server.getNameType(), this.server.getNameComponents());
        Realm realm2 = new Realm(this.server.getRealm());
        short s = cCInputStream.readShort();
        s = cCInputStream.readShort();
        byte[] byArray = cCInputStream.readBinaryString();
        EncryptionKey encryptionKey = new EncryptionKey(s, byArray);
        KerberosTime kerberosTime = new KerberosTime(new Date((long)cCInputStream.readInt() * 1000L));
        KerberosTime kerberosTime2 = new KerberosTime(new Date((long)cCInputStream.readInt() * 1000L));
        KerberosTime kerberosTime3 = new KerberosTime(new Date((long)cCInputStream.readInt() * 1000L));
        KerberosTime kerberosTime4 = new KerberosTime(new Date((long)cCInputStream.readInt() * 1000L));
        this.sKey = cCInputStream.readByte();
        TicketFlags ticketFlags = new TicketFlags(cCInputStream.readInt());
        Vector vector = this.readAddresses(cCInputStream);
        HostAddresses hostAddresses = new HostAddresses(vector);
        this.authData = cCInputStream.readBinaryString();
        byte[] byArray2 = cCInputStream.readBinaryString();
        this.ticket = null;
        if (byArray2 != null && byArray2.length > 0) {
            try {
                this.ticket = new KerberosTicket(byArray2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        byte[] byArray3 = cCInputStream.readBinaryString();
        this.ticket2 = null;
        if (byArray3 != null && byArray3.length > 0) {
            try {
                this.ticket2 = new KerberosTicket(byArray3);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.credInfo = new CredentialInfo(encryptionKey, realm, principalName, ticketFlags, kerberosTime, kerberosTime2, kerberosTime3, kerberosTime4, realm2, principalName2, hostAddresses);
    }

    public Credential(CredentialInfo credentialInfo, KerberosTicket kerberosTicket) {
        this();
        this.credInfo = credentialInfo;
        this.ticket = kerberosTicket;
        this.sKey = 0;
        this.authData = new byte[0];
        if (credentialInfo.getClientName() != null && credentialInfo.getClientRealm() != null) {
            this.client = new CredentialName(credentialInfo.getClientName().getNameType(), credentialInfo.getClientRealm().getName(), credentialInfo.getClientName().getNameString());
        }
        if (credentialInfo.getServerName() != null && credentialInfo.getServerRealm() != null) {
            this.server = new CredentialName(credentialInfo.getServerName().getNameType(), credentialInfo.getServerRealm().getName(), credentialInfo.getServerName().getNameString());
        }
    }

    public byte[] getAuthData() {
        return this.authData;
    }

    public byte[] getClientName() {
        return this.credInfo.getClientName().encode();
    }

    public CredentialInfo getCredentialInfo() {
        return this.credInfo;
    }

    public Date getExpiryTime() {
        KerberosTime kerberosTime = this.credInfo.getEndTime();
        if (kerberosTime != null) {
            return kerberosTime.getDate();
        }
        return new Date(0L);
    }

    public byte[] getKeyBytes() {
        return this.getSessionKey();
    }

    public int getKeyType() {
        return this.credInfo.getSessionKey().getKeyType();
    }

    public byte getSKey() {
        return this.sKey;
    }

    public KerberosTicket getSecondTicket() {
        return this.ticket2;
    }

    public String getServiceName() {
        return this.server.toString();
    }

    public byte[] getSessionKey() {
        return this.credInfo.getSessionKey().getKeyBytes();
    }

    public KerberosTicket getTicket() {
        return this.ticket;
    }

    private StringBuffer ipToString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(" ");
        int n = 0;
        while (n < byArray.length) {
            int n2;
            if (n > 0) {
                stringBuffer.append(".");
            }
            if ((n2 = byArray[n]) < 0) {
                n2 += 256;
            }
            stringBuffer.append(n2);
            ++n;
        }
        return stringBuffer;
    }

    private Vector readAddresses(CCInputStream cCInputStream) throws IOException {
        Vector<HostAddress> vector = new Vector<HostAddress>();
        int n = cCInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(new HostAddress(cCInputStream.readShort(), cCInputStream.readBinaryString()));
            ++n2;
        }
        return vector;
    }

    private String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(Integer.toHexString(byArray[n] & 0xFF));
            stringBuffer.append("  ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n\nClient: ");
        stringBuffer.append(this.client.toString());
        stringBuffer.append("\nServer: ");
        stringBuffer.append(this.server.toString());
        stringBuffer.append("\nSession key type: " + this.credInfo.getSessionKey().getKeyType());
        stringBuffer.append("\nSession key: " + this.toHexString(this.credInfo.getSessionKey().getKeyBytes()));
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        dateFormat.setTimeZone(TimeZone.getTimeZone("AEST"));
        Date date = this.credInfo.getAuthTime() != null ? this.credInfo.getAuthTime().getDate() : new Date(0L);
        stringBuffer.append("\nStart time: " + dateFormat.format(date));
        date = this.credInfo.getEndTime() != null ? this.credInfo.getEndTime().getDate() : new Date(0L);
        stringBuffer.append("\nEnd time: " + dateFormat.format(date));
        int n = this.credInfo.getTicketFlags() != null ? this.credInfo.getTicketFlags().getFlagsMask() : 0;
        stringBuffer.append("\nTicket Flags: " + n);
        stringBuffer.append("\nValid for:");
        if (this.credInfo.getClientAddress() != null) {
            Enumeration enumeration = this.credInfo.getClientAddress().getAddresses().elements();
            if (!enumeration.hasMoreElements()) {
                stringBuffer.append(" local host");
            }
            while (enumeration.hasMoreElements()) {
                byte[] byArray = ((HostAddress)enumeration.nextElement()).getAddress();
                stringBuffer.append((Object)this.ipToString(byArray));
            }
        } else {
            stringBuffer.append(" local host");
        }
        return stringBuffer.toString();
    }

    public void write(CCOutputStream cCOutputStream) throws IOException {
        this.client.write(cCOutputStream);
        this.server.write(cCOutputStream);
        cCOutputStream.writeShort(this.credInfo.getSessionKey().getKeyType());
        cCOutputStream.writeShort(this.credInfo.getSessionKey().getKeyType());
        cCOutputStream.writeBinaryString(this.credInfo.getSessionKey().getKeyBytes());
        KerberosTime kerberosTime = this.credInfo.getAuthTime();
        Date date = kerberosTime != null ? kerberosTime.getDate() : new Date(0L);
        cCOutputStream.writeInt((int)(date.getTime() / 1000L));
        kerberosTime = this.credInfo.getStartTime();
        date = kerberosTime != null ? kerberosTime.getDate() : new Date(0L);
        cCOutputStream.writeInt((int)(date.getTime() / 1000L));
        kerberosTime = this.credInfo.getEndTime();
        date = kerberosTime != null ? kerberosTime.getDate() : new Date(0L);
        cCOutputStream.writeInt((int)(date.getTime() / 1000L));
        kerberosTime = this.credInfo.getRenewTill();
        date = kerberosTime != null ? kerberosTime.getDate() : new Date(0L);
        cCOutputStream.writeInt((int)(date.getTime() / 1000L));
        cCOutputStream.writeByte(this.sKey);
        TicketFlags ticketFlags = this.credInfo.getTicketFlags();
        int n = ticketFlags != null ? ticketFlags.getFlagsMask() : 0;
        cCOutputStream.writeInt(n);
        Vector vector = this.credInfo.getClientAddress() != null ? this.credInfo.getClientAddress().getAddresses() : new Vector();
        cCOutputStream.writeInt(vector.size());
        int n2 = 0;
        while (n2 < vector.size()) {
            cCOutputStream.writeShort(((HostAddress)vector.elementAt(n2)).getAddressType());
            cCOutputStream.writeBinaryString(((HostAddress)vector.elementAt(n2)).getAddress());
            ++n2;
        }
        cCOutputStream.writeBinaryString(this.authData);
        cCOutputStream.writeBinaryString(this.ticket.getEncoded());
        if (this.ticket2 == null) {
            cCOutputStream.writeBinaryString(new byte[0]);
        } else {
            cCOutputStream.writeBinaryString(this.ticket2.getEncoded());
        }
    }
}

