/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.creds;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.kerberos.v5.KrbCredInfo;
import com.dstc.security.kerberos.v5.base.HostAddresses;
import com.dstc.security.kerberos.v5.base.KerberosTime;
import com.dstc.security.kerberos.v5.base.PrincipalName;
import com.dstc.security.kerberos.v5.base.Realm;
import com.dstc.security.kerberos.v5.base.TicketFlags;
import com.dstc.security.kerberos.v5.crypto.EncryptionKey;

public class CredentialInfo {
    private EncryptionKey sessionKey;
    private Realm crealm;
    private Realm srealm;
    private PrincipalName cname;
    private PrincipalName sname;
    private KerberosTime authTime;
    private KerberosTime startTime;
    private KerberosTime endTime;
    private KerberosTime renewTill;
    private TicketFlags flags;
    private HostAddresses caddr;
    private KrbCredInfo krbCredInfo = null;

    public CredentialInfo(EncryptionKey encryptionKey, Realm realm, PrincipalName principalName, TicketFlags ticketFlags, KerberosTime kerberosTime, KerberosTime kerberosTime2, KerberosTime kerberosTime3, KerberosTime kerberosTime4, Realm realm2, PrincipalName principalName2, HostAddresses hostAddresses) {
        this.sessionKey = encryptionKey;
        this.crealm = realm;
        this.cname = principalName;
        this.flags = ticketFlags;
        this.authTime = kerberosTime;
        this.startTime = kerberosTime2;
        this.endTime = kerberosTime3;
        this.renewTill = kerberosTime4;
        this.srealm = realm2;
        this.sname = principalName2;
        this.caddr = hostAddresses;
        this.krbCredInfo = new KrbCredInfo(encryptionKey, realm, principalName, ticketFlags, kerberosTime, kerberosTime2, kerberosTime3, kerberosTime4, realm2, principalName2, hostAddresses);
    }

    public CredentialInfo(byte[] byArray) throws Asn1Exception {
        this.krbCredInfo = new KrbCredInfo(byArray);
    }

    public KerberosTime getAuthTime() {
        return this.authTime;
    }

    public HostAddresses getClientAddress() {
        return this.caddr;
    }

    public PrincipalName getClientName() {
        return this.cname;
    }

    public Realm getClientRealm() {
        return this.crealm;
    }

    public byte[] getEncoded() {
        return this.krbCredInfo.encode();
    }

    public KerberosTime getEndTime() {
        return this.endTime;
    }

    public KerberosTime getRenewTill() {
        return this.renewTill;
    }

    public PrincipalName getServerName() {
        return this.sname;
    }

    public Realm getServerRealm() {
        return this.srealm;
    }

    public EncryptionKey getSessionKey() {
        return this.sessionKey;
    }

    public KerberosTime getStartTime() {
        return this.startTime;
    }

    public TicketFlags getTicketFlags() {
        return this.flags;
    }

    public void setClientName(PrincipalName principalName) {
        this.cname = principalName;
    }

    public void setClientRealm(Realm realm) {
        this.crealm = realm;
    }

    private String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(Integer.toHexString(byArray[n] & 0xFF));
            stringBuffer.append("  ");
            ++n;
        }
        return stringBuffer.toString();
    }
}

