/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.creds;

import com.dstc.security.kerberos.creds.CCInputStream;
import com.dstc.security.kerberos.creds.CCOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class CredentialName {
    private int nameType;
    private String realm;
    private Vector nameComponents;

    public CredentialName() {
        this.nameComponents = new Vector();
    }

    public CredentialName(int n, String string, Vector vector) {
        this.nameType = n;
        this.realm = string;
        this.nameComponents = vector;
    }

    public CredentialName(CCInputStream cCInputStream) throws IOException {
        this();
        this.nameType = cCInputStream.readInt();
        int n = cCInputStream.readInt();
        this.realm = new String(cCInputStream.readBinaryString());
        int n2 = 0;
        while (n2 < n) {
            this.nameComponents.addElement(new String(cCInputStream.readBinaryString()));
            ++n2;
        }
    }

    public CredentialName(String string) {
        this.nameType = 1;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "@", false);
        this.nameComponents = new Vector();
        this.nameComponents.addElement(stringTokenizer.nextToken());
        this.realm = stringTokenizer.nextToken();
    }

    public Vector getNameComponents() {
        return this.nameComponents;
    }

    public int getNameType() {
        return this.nameType;
    }

    public String getRealm() {
        return this.realm;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            stringBuffer.append((String)this.nameComponents.elementAt(n++));
            if (n == this.nameComponents.size()) break;
            stringBuffer.append("/");
        }
        stringBuffer.append("@" + this.realm);
        return stringBuffer.toString();
    }

    public void write(CCOutputStream cCOutputStream) throws IOException {
        cCOutputStream.writeInt(this.nameType);
        cCOutputStream.writeInt(this.nameComponents.size());
        cCOutputStream.writeBinaryString(this.realm);
        int n = 0;
        while (n < this.nameComponents.size()) {
            cCOutputStream.writeBinaryString((String)this.nameComponents.elementAt(n));
            ++n;
        }
    }
}

