/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.creds;

import com.dstc.security.kerberos.Kerberos;
import com.dstc.security.kerberos.KerberosContext;
import com.dstc.security.kerberos.creds.Credential;
import com.dstc.security.kerberos.creds.FileCredentialStore;
import com.dstc.security.kerberos.creds.MemoryCredentialStore;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;

public abstract class CredentialStore {
    private static CredentialStore instance;
    protected static KerberosContext ctx;

    static {
        block3: {
            instance = null;
            ctx = null;
            if (instance != null) break block3;
            try {
                ctx = Kerberos.getDefault().getKerberosContext();
                instance = new FileCredentialStore(ctx.getCCName());
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("CredentialStore exception:");
                System.out.println("  Check System property jcsi.kerberos.ccache");
                fileNotFoundException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public abstract Credential getCredential(String var1);

    public abstract Iterator getCredentials();

    public static CredentialStore getDefault() {
        return instance;
    }

    public abstract String getDefaultUser();

    public static CredentialStore getInstance(String string) {
        if (string.equalsIgnoreCase("File")) {
            return instance;
        }
        if (string.equalsIgnoreCase("Memory")) {
            return new MemoryCredentialStore();
        }
        return null;
    }

    public abstract String getStoreType();

    public abstract void put(Credential var1);
}

