/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.creds;

import com.dstc.security.kerberos.creds.CCInputStream;
import com.dstc.security.kerberos.creds.CCOutputStream;
import com.dstc.security.kerberos.creds.Credential;
import com.dstc.security.kerberos.creds.CredentialName;
import com.dstc.security.kerberos.creds.CredentialStore;
import com.dstc.security.kerberos.creds.MemoryCredentialStore;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

final class FileCredentialStore
extends MemoryCredentialStore {
    private File file = null;

    FileCredentialStore(String string) throws IOException {
        this.file = new File(string);
        if (this.file.exists()) {
            this.load(this.file);
        } else {
            this.file.createNewFile();
            this.client = new CredentialName(String.valueOf(CredentialStore.ctx.getUsername()) + "@" + CredentialStore.ctx.getRealm());
        }
    }

    public String getStoreType() {
        return "File";
    }

    synchronized void load(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        CCInputStream cCInputStream = new CCInputStream(new DataInputStream(new BufferedInputStream(fileInputStream)));
        int n = fileInputStream.read();
        int n2 = fileInputStream.read();
        if ((byte)(n & 0xFF) != 5 || (byte)(n2 & 0xFF) != 3) {
            throw new IOException("Not an acceptable credential file");
        }
        this.client = new CredentialName(cCInputStream);
        while (cCInputStream.available() != 0) {
            Credential credential = new Credential(cCInputStream);
            this.creds.put(credential.getServiceName(), credential);
        }
        fileInputStream.close();
    }

    public void put(Credential credential) {
        super.put(credential);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            this.write(fileOutputStream);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    synchronized void write(OutputStream outputStream) throws IOException {
        CCOutputStream cCOutputStream = new CCOutputStream(outputStream);
        cCOutputStream.writeByte((byte)5);
        cCOutputStream.writeByte((byte)3);
        this.client.write(cCOutputStream);
        Enumeration enumeration = this.creds.elements();
        while (enumeration.hasMoreElements()) {
            ((Credential)enumeration.nextElement()).write(cCOutputStream);
        }
    }
}

