/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.creds;

import com.dstc.security.kerberos.creds.CCInputStream;
import com.dstc.security.kerberos.creds.KeyTab;
import com.dstc.security.kerberos.creds.KeyTabEntry;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

final class FileKeyTab
extends KeyTab {
    private Hashtable entries;
    private String fileName;
    private String defaultUser;

    FileKeyTab(String string) throws IOException {
        this.fileName = string;
        this.entries = new Hashtable();
        this.load(string);
        this.defaultUser = KeyTab.ctx.getUsername();
    }

    public byte[] getKey(String string) {
        KeyTabEntry keyTabEntry = (KeyTabEntry)this.entries.get(string);
        if (keyTabEntry != null) {
            return keyTabEntry.getKeyBytes();
        }
        return null;
    }

    public Iterator getKeyTabEntries() {
        return this.entries.values().iterator();
    }

    public KeyTabEntry getKeyTabEntry(String string) {
        return (KeyTabEntry)this.entries.get(string);
    }

    public String getKeyTabType() {
        return "File";
    }

    synchronized void load(String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        CCInputStream cCInputStream = new CCInputStream(new BufferedInputStream(fileInputStream));
        cCInputStream.readShort();
        while (cCInputStream.available() != 0) {
            int n = cCInputStream.readInt();
            byte[] byArray = new byte[n];
            cCInputStream.read(byArray);
            CCInputStream cCInputStream2 = new CCInputStream(new ByteArrayInputStream(byArray));
            this.readEntry(cCInputStream2);
        }
    }

    private void readEntry(CCInputStream cCInputStream) throws IOException {
        KeyTabEntry keyTabEntry = new KeyTabEntry(cCInputStream);
        this.entries.put(keyTabEntry.getServiceName(), keyTabEntry);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("\n");
            stringBuffer.append(((KeyTabEntry)enumeration.nextElement()).toString());
        }
        return stringBuffer.toString();
    }
}

