/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.creds;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.crypto.CryptoException;
import com.dstc.security.kerberos.crypto.KerberosCipher;
import com.dstc.security.kerberos.crypto.KerberosKey;
import com.dstc.security.kerberos.crypto.KeyMaterial;
import com.dstc.security.kerberos.v5.BadMessageTypeException;
import com.dstc.security.kerberos.v5.BadVersionException;
import com.dstc.security.kerberos.v5.creds.EncTicketPart;
import com.dstc.security.kerberos.v5.creds.Ticket;
import com.dstc.security.kerberos.v5.crypto.EncryptedData;

public class KerberosTicket {
    private Ticket ticket = null;
    private EncryptedData encData = null;
    private EncTicketPart encTicketPart = null;
    private KerberosCipher cipher = null;

    public KerberosTicket(Ticket ticket) {
        this.ticket = ticket;
        this.encData = this.ticket.getEncrypted();
    }

    public KerberosTicket(byte[] byArray) throws Asn1Exception, BadVersionException, BadMessageTypeException {
        this.ticket = new Ticket(byArray);
        this.encData = this.ticket.getEncrypted();
    }

    public void decrypt() throws Asn1Exception, CryptoException, KerberosException, BadMessageTypeException {
        if (this.cipher == null) {
            throw new KerberosException("Cipher not yet set");
        }
        this.encTicketPart = new EncTicketPart(this.cipher.decrypt(this.encData));
    }

    public KerberosKey getContextKey() {
        return new KerberosKey(this.getKeyType(), this.getKeyBytes());
    }

    public byte[] getEncoded() {
        return this.ticket.encode();
    }

    public byte[] getKeyBytes() {
        return this.encTicketPart.getKey().getKeyBytes();
    }

    public int getKeyType() {
        return this.encTicketPart.getKey().getKeyType();
    }

    public String getRealm() {
        return this.ticket.getRealm().getName();
    }

    public String getServerName() {
        return this.ticket.getServerName().toString();
    }

    public void initDecrypt(KeyMaterial keyMaterial) throws CryptoException {
        KerberosCipher kerberosCipher = new KerberosCipher(keyMaterial, null, null);
        kerberosCipher.initDecrypt();
        this.cipher = kerberosCipher;
    }
}

