/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.creds;

import com.dstc.security.kerberos.creds.CCInputStream;
import com.dstc.security.kerberos.crypto.KeyMaterial;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;

public class KeyTabEntry
implements KeyMaterial {
    private CredentialName name;
    private int principalType;
    private int timestamp;
    private byte kvno;
    private int keyType;
    private byte[] key;

    public KeyTabEntry(CCInputStream cCInputStream) throws IOException {
        this.name = new CredentialName(cCInputStream);
        this.principalType = cCInputStream.readInt();
        this.timestamp = cCInputStream.readInt();
        this.kvno = cCInputStream.readByte();
        this.keyType = cCInputStream.readShort();
        this.key = new byte[cCInputStream.readShort()];
        cCInputStream.read(this.key);
    }

    public byte[] getKeyBytes() {
        return this.key;
    }

    public int getKeyType() {
        return this.keyType;
    }

    public String getServiceName() {
        return this.name.print();
    }

    private String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(Integer.toHexString(byArray[n] & 0xFF));
            stringBuffer.append("  ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name.print());
        stringBuffer.append("\nPrincipalType: " + this.principalType);
        stringBuffer.append("\nTimeStamp: ");
        stringBuffer.append(new Date((long)this.timestamp * 1000L).toString());
        stringBuffer.append("\nKVNO: " + this.kvno);
        stringBuffer.append("\nKey Type: " + this.keyType);
        stringBuffer.append("\nKey: " + this.toHexString(this.key));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    protected class CredentialName {
        private String realm;
        private Vector nameComponents = new Vector();

        protected CredentialName() {
        }

        protected CredentialName(CCInputStream cCInputStream) throws IOException {
            this();
            int n = cCInputStream.readShort();
            byte[] byArray = new byte[cCInputStream.readShort()];
            cCInputStream.read(byArray);
            this.realm = new String(byArray);
            int n2 = 0;
            while (n2 < n) {
                byte[] byArray2 = new byte[cCInputStream.readShort()];
                cCInputStream.read(byArray2);
                this.nameComponents.addElement(new String(byArray2));
                ++n2;
            }
        }

        protected String print() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (true) {
                stringBuffer.append((String)this.nameComponents.elementAt(n++));
                if (n == this.nameComponents.size()) break;
                stringBuffer.append("/");
            }
            stringBuffer.append("@" + this.realm);
            return stringBuffer.toString();
        }
    }
}

